/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.qpid.server.logging.LogLevel;
import org.apache.qpid.server.logging.logback.PredicateAndLoggerNameAndLevelFilter;
import org.apache.qpid.server.logging.logback.QpidLoggerTurboFilter;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;

public abstract class AbstractPredicateLogInclusionRule<X extends AbstractPredicateLogInclusionRule<X>>
extends AbstractConfiguredObject<X> {
    @ManagedAttributeField
    private String _loggerName;
    @ManagedAttributeField(afterSet="logLevelAfterSet")
    private LogLevel _level;
    private PredicateAndLoggerNameAndLevelFilter _filter;

    protected AbstractPredicateLogInclusionRule(ConfiguredObject<?> parent, Map<String, Object> attributes) {
        super(parent, attributes);
    }

    protected void postResolve() {
        super.postResolve();
        this._filter = new PredicateAndLoggerNameAndLevelFilter(this.getLoggerName(), Level.toLevel((String)this.getLevel().name()), this.getPredicate());
    }

    protected abstract PredicateAndLoggerNameAndLevelFilter.Predicate getPredicate();

    public String getLoggerName() {
        return this._loggerName;
    }

    public LogLevel getLevel() {
        return this._level;
    }

    private void logLevelAfterSet() {
        if (this._filter != null) {
            this._filter.setLevel(Level.toLevel((String)this.getLevel().name()));
            QpidLoggerTurboFilter.filterChangedOnRootContext(this._filter);
        }
    }

    public Filter<ILoggingEvent> asFilter() {
        return this._filter;
    }

    protected CompletableFuture<Void> onDelete() {
        QpidLoggerTurboFilter.filterRemovedFromRootContext(this._filter);
        return super.onDelete();
    }

    @StateTransition(currentState={State.ERRORED, State.UNINITIALIZED}, desiredState=State.ACTIVE)
    private CompletableFuture<Void> doActivate() {
        this.setState(State.ACTIVE);
        QpidLoggerTurboFilter.filterAddedToRootContext(this._filter);
        return CompletableFuture.completedFuture(null);
    }
}

