/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.BrokerConnectionLimitProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostConnectionLimitProvider;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.security.limit.CachedConnectionLimiterImpl;
import org.apache.qpid.server.security.limit.ConnectionLimitProvider;
import org.apache.qpid.server.security.limit.ConnectionLimiter;
import org.apache.qpid.server.security.limit.ConnectionLimiterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VirtualHostConnectionLimiter
extends CachedConnectionLimiterImpl
implements ConnectionLimiter.CachedLimiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualHostConnectionLimiter.class);
    private final VirtualHost<?> _virtualHost;
    private final Broker<?> _broker;
    private final Map<ConnectionLimitProvider<?>, ConnectionLimiter> _connectionLimitProviders = new ConcurrentHashMap();
    private final List<ConnectionLimiterService> _serviceLimiters = new CopyOnWriteArrayList<ConnectionLimiterService>();
    private final ChangeListener _virtualHostChangeListener;
    private final ChangeListener _brokerChangeListener;

    VirtualHostConnectionLimiter(VirtualHost<?> virtualHost, Broker<?> broker) {
        super(ConnectionLimiter.noLimits());
        this._virtualHost = Objects.requireNonNull(virtualHost);
        this._broker = Objects.requireNonNull(broker);
        this._virtualHostChangeListener = ChangeListener.virtualHostChangeListener(this);
        this._brokerChangeListener = ChangeListener.brokerChangeListener(this);
    }

    public void open() {
        this._virtualHost.addChangeListener(this._virtualHostChangeListener);
        this._broker.addChangeListener(this._brokerChangeListener);
        this._virtualHost.getChildren(VirtualHostConnectionLimitProvider.class).forEach(child -> child.addChangeListener(ProviderChangeListener.virtualHostChangeListener(this)));
        this._broker.getChildren(BrokerConnectionLimitProvider.class).forEach(child -> child.addChangeListener(ProviderChangeListener.brokerChangeListener(this)));
        QpidServiceLoader serviceLoader = new QpidServiceLoader();
        for (ConnectionLimiterService service : serviceLoader.instancesOf(ConnectionLimiterService.class)) {
            LOGGER.debug("New connection limiter service found: {}", (Object)service.getType());
            this._serviceLimiters.add(service);
        }
    }

    public void activate() {
        this.update();
    }

    public void close() {
        this._virtualHost.removeChangeListener(this._virtualHostChangeListener);
        this._broker.removeChangeListener(this._brokerChangeListener);
        ProviderChangeListener virtualHostChangeListener = ProviderChangeListener.virtualHostChangeListener(this);
        this._virtualHost.getChildren(VirtualHostConnectionLimitProvider.class).forEach(child -> child.removeChangeListener(virtualHostChangeListener));
        ProviderChangeListener brokerChangeListener = ProviderChangeListener.brokerChangeListener(this);
        this._broker.getChildren(BrokerConnectionLimitProvider.class).forEach(child -> child.removeChangeListener(brokerChangeListener));
        this._serviceLimiters.clear();
        this.swapLimiter(ConnectionLimiter.noLimits());
    }

    private void update(ConfiguredObject<?> object) {
        this._connectionLimitProviders.remove(object);
        this.update();
    }

    private void update() {
        if (!((SystemConfig)this._broker.getParent()).isManagementMode()) {
            this.swapLimiter(this.newLimiter(this._connectionLimitProviders));
        }
    }

    private ConnectionLimiter newLimiter(Map<ConnectionLimitProvider<?>, ConnectionLimiter> cache) {
        ConnectionLimiter limiter = ConnectionLimiter.noLimits();
        LOGGER.debug("Updating virtual host connection limiters");
        for (VirtualHostConnectionLimitProvider virtualHostConnectionLimitProvider : this._virtualHost.getChildren(VirtualHostConnectionLimitProvider.class)) {
            if (virtualHostConnectionLimitProvider.getState() == State.ACTIVE) {
                limiter = limiter.append(cache.computeIfAbsent(virtualHostConnectionLimitProvider, ConnectionLimitProvider::getConnectionLimiter));
                continue;
            }
            if (virtualHostConnectionLimitProvider.getState() != State.ERRORED) continue;
            limiter = ConnectionLimiter.blockEveryone();
        }
        LOGGER.debug("Updating broker connection limiters");
        for (BrokerConnectionLimitProvider brokerConnectionLimitProvider : this._broker.getChildren(BrokerConnectionLimitProvider.class)) {
            if (brokerConnectionLimitProvider.getState() == State.ACTIVE) {
                limiter = limiter.append(cache.computeIfAbsent(brokerConnectionLimitProvider, ConnectionLimitProvider::getConnectionLimiter));
                continue;
            }
            if (brokerConnectionLimitProvider.getState() != State.ERRORED) continue;
            limiter = ConnectionLimiter.blockEveryone();
        }
        LOGGER.debug("Updating service based connection limiters");
        for (ConnectionLimiterService connectionLimiterService : this._serviceLimiters) {
            limiter = limiter.append(connectionLimiterService);
        }
        return limiter;
    }

    private static final class ChangeListener
    extends AbstractChangeListener {
        private final Class<?> _categoryClass;

        static ChangeListener virtualHostChangeListener(VirtualHostConnectionLimiter limiter) {
            return new ChangeListener(limiter, VirtualHost.class, VirtualHostConnectionLimitProvider.class);
        }

        static ChangeListener brokerChangeListener(VirtualHostConnectionLimiter limiter) {
            return new ChangeListener(limiter, Broker.class, BrokerConnectionLimitProvider.class);
        }

        private ChangeListener(VirtualHostConnectionLimiter limiter, Class<?> categoryClass, Class<?> childCategoryClass) {
            super(limiter, childCategoryClass);
            this._categoryClass = categoryClass;
        }

        @Override
        public void childAdded(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            super.childAdded(object, child);
            if (object.getCategoryClass() == this._categoryClass && child.getCategoryClass() == this._providerClazz) {
                this.addProvider(child);
            }
        }

        @Override
        public void childRemoved(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            super.childRemoved(object, child);
            if (object.getCategoryClass() == this._categoryClass && child.getCategoryClass() == this._providerClazz) {
                this.removeProvider(child);
            }
        }
    }

    private static final class ProviderChangeListener
    extends AbstractChangeListener {
        private final Map<ConfiguredObject<?>, Boolean> _bulkChanges = new ConcurrentHashMap();

        static ProviderChangeListener virtualHostChangeListener(VirtualHostConnectionLimiter limiter) {
            return new ProviderChangeListener(limiter, VirtualHostConnectionLimitProvider.class);
        }

        static ProviderChangeListener brokerChangeListener(VirtualHostConnectionLimiter limiter) {
            return new ProviderChangeListener(limiter, BrokerConnectionLimitProvider.class);
        }

        ProviderChangeListener(VirtualHostConnectionLimiter limiter, Class<?> clazz) {
            super(limiter, clazz);
        }

        @Override
        public void attributeSet(ConfiguredObject<?> object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
            super.attributeSet(object, attributeName, oldAttributeValue, newAttributeValue);
            if (object.getCategoryClass() == this._providerClazz && !this._bulkChanges.containsKey(object)) {
                this.updateProvider(object);
            }
        }

        @Override
        public void bulkChangeStart(ConfiguredObject<?> object) {
            super.bulkChangeStart(object);
            this._bulkChanges.put(object, Boolean.TRUE);
        }

        @Override
        public void bulkChangeEnd(ConfiguredObject<?> object) {
            super.bulkChangeEnd(object);
            if (Optional.ofNullable(this._bulkChanges.remove(object)).orElse(Boolean.FALSE).booleanValue()) {
                this.updateProvider(object);
            }
        }
    }

    private static abstract class AbstractChangeListener
    extends AbstractConfigurationChangeListener {
        final VirtualHostConnectionLimiter _limiter;
        final Class<?> _providerClazz;

        AbstractChangeListener(VirtualHostConnectionLimiter limiter, Class<?> providerClazz) {
            this._limiter = Objects.requireNonNull(limiter);
            this._providerClazz = Objects.requireNonNull(providerClazz);
        }

        void addProvider(ConfiguredObject<?> provider) {
            provider.addChangeListener(new ProviderChangeListener(this._limiter, this._providerClazz));
            this._limiter.update();
        }

        void removeProvider(ConfiguredObject<?> provider) {
            provider.removeChangeListener(new ProviderChangeListener(this._limiter, this._providerClazz));
            this._limiter.update(provider);
        }

        void updateProvider(ConfiguredObject<?> provider) {
            this._limiter.update(provider);
        }

        public int hashCode() {
            return 31 * this._limiter.hashCode() + this._providerClazz.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof AbstractChangeListener) {
                AbstractChangeListener changeListener = (AbstractChangeListener)obj;
                return this._limiter == changeListener._limiter && this._providerClazz == changeListener._providerClazz;
            }
            return false;
        }
    }
}

