/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.SimpleFormat;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.util.ClassResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class SimpleCatalog
implements Catalog {
    private static final Map<String, Class> keywordToPrimitive = new HashMap<String, Class>(8);
    private static final Map<Class, Class> primitiveTypeToWrapper;
    private static final SimpleCatalog instance;
    private final ClassLoader classLoader;
    private final List<SimpleFormat> formatList;
    private final Map<String, SimpleFormat> formatMap;

    static boolean isSimpleType(Class type) {
        return SimpleCatalog.instance.formatMap.containsKey(type.getName());
    }

    static Class primitiveToWrapper(Class type) {
        Class cls = primitiveTypeToWrapper.get(type);
        if (cls == null) {
            throw DbCompat.unexpectedState(type.getName());
        }
        return cls;
    }

    public static Class resolveClass(String className, ClassLoader loader) throws ClassNotFoundException {
        Class cls = keywordToPrimitive.get(className);
        if (cls == null) {
            cls = ClassResolver.resolveClass(className, loader);
        }
        return cls;
    }

    public static Class resolveKeyClass(String className, ClassLoader loader) {
        Class cls = keywordToPrimitive.get(className);
        if (cls != null) {
            cls = primitiveTypeToWrapper.get(cls);
        } else {
            try {
                cls = ClassResolver.resolveClass(className, loader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Key class not found: " + className);
            }
        }
        return cls;
    }

    public static String keyClassName(String className) {
        Class cls = keywordToPrimitive.get(className);
        if (cls != null) {
            cls = primitiveTypeToWrapper.get(cls);
            return cls.getName();
        }
        return className;
    }

    static List<Format> getAllSimpleFormats(ClassLoader loader) {
        return new ArrayList<Format>(new SimpleCatalog((ClassLoader)loader).formatList);
    }

    static boolean addMissingSimpleFormats(ClassLoader loader, List<Format> copyToList) {
        boolean anyCopied = false;
        SimpleCatalog tempCatalog = null;
        for (int i = 0; i <= 30; ++i) {
            Format thisFormat = SimpleCatalog.instance.formatList.get(i);
            Format otherFormat = copyToList.get(i);
            if (thisFormat == null || otherFormat != null) continue;
            assert (thisFormat.getWrapperFormat() == null);
            if (tempCatalog == null) {
                tempCatalog = new SimpleCatalog(loader);
            }
            copyToList.set(i, tempCatalog.formatList.get(i));
            anyCopied = true;
        }
        return anyCopied;
    }

    SimpleCatalog(ClassLoader classLoader) {
        this.classLoader = classLoader;
        int initCapacity = 60;
        this.formatList = new ArrayList<SimpleFormat>(initCapacity);
        this.formatMap = new HashMap<String, SimpleFormat>(initCapacity);
        for (int i = 0; i <= 30; ++i) {
            this.formatList.add(null);
        }
        this.setFormat(2, new SimpleFormat.FBool((Catalog)this, true));
        this.setFormat(3, new SimpleFormat.FBool((Catalog)this, false));
        this.setFormat(4, new SimpleFormat.FByte((Catalog)this, true));
        this.setFormat(5, new SimpleFormat.FByte((Catalog)this, false));
        this.setFormat(6, new SimpleFormat.FShort((Catalog)this, true));
        this.setFormat(7, new SimpleFormat.FShort((Catalog)this, false));
        this.setFormat(8, new SimpleFormat.FInt((Catalog)this, true));
        this.setFormat(9, new SimpleFormat.FInt((Catalog)this, false));
        this.setFormat(10, new SimpleFormat.FLong((Catalog)this, true));
        this.setFormat(11, new SimpleFormat.FLong((Catalog)this, false));
        this.setFormat(12, new SimpleFormat.FFloat((Catalog)this, true));
        this.setFormat(13, new SimpleFormat.FFloat((Catalog)this, false));
        this.setFormat(14, new SimpleFormat.FDouble((Catalog)this, true));
        this.setFormat(15, new SimpleFormat.FDouble((Catalog)this, false));
        this.setFormat(16, new SimpleFormat.FChar((Catalog)this, true));
        this.setFormat(17, new SimpleFormat.FChar((Catalog)this, false));
        this.setFormat(18, new SimpleFormat.FString(this));
        this.setFormat(19, new SimpleFormat.FBigInt(this));
        this.setFormat(20, new SimpleFormat.FBigDec(this));
        this.setFormat(21, new SimpleFormat.FDate(this));
        this.setWrapper(2, 3);
        this.setWrapper(4, 5);
        this.setWrapper(6, 7);
        this.setWrapper(8, 9);
        this.setWrapper(10, 11);
        this.setWrapper(12, 13);
        this.setWrapper(14, 15);
        this.setWrapper(16, 17);
    }

    private void setFormat(int id, SimpleFormat format) {
        format.setId(id);
        format.initializeIfNeeded(this, null);
        this.formatList.set(id, format);
        this.formatMap.put(format.getClassName(), format);
    }

    private void setWrapper(int primitiveId, int wrapperId) {
        SimpleFormat primitiveFormat = this.formatList.get(primitiveId);
        SimpleFormat wrapperFormat = this.formatList.get(wrapperId);
        primitiveFormat.setWrapperFormat(wrapperFormat);
    }

    @Override
    public int getInitVersion(Format format, boolean forReader) {
        return 1;
    }

    @Override
    public Format getFormat(int formatId, boolean expectStored) {
        try {
            Format format = this.formatList.get(formatId);
            if (format == null) {
                throw DbCompat.unexpectedState("Not a simple type: " + formatId);
            }
            return format;
        }
        catch (NoSuchElementException e) {
            throw DbCompat.unexpectedState("Not a simple type: " + formatId);
        }
    }

    @Override
    public Format getFormat(Class cls, boolean checkEntitySubclassIndexes) {
        Format format = this.formatMap.get(cls.getName());
        if (format == null) {
            throw new IllegalArgumentException("Not a simple type: " + cls.getName());
        }
        return format;
    }

    @Override
    public Format getFormat(String className) {
        return this.formatMap.get(className);
    }

    @Override
    public Format createFormat(String clsName, Map<String, Format> newFormats) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public Format createFormat(Class type, Map<String, Format> newFormats) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public boolean isRawAccess() {
        return false;
    }

    @Override
    public Object convertRawObject(RawObject o, IdentityHashMap converted) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public Class resolveClass(String clsName) throws ClassNotFoundException {
        return SimpleCatalog.resolveClass(clsName, this.classLoader);
    }

    @Override
    public Class resolveKeyClass(String clsName) {
        return SimpleCatalog.resolveKeyClass(clsName, this.classLoader);
    }

    public static boolean allowRegisterProxy(Class type) {
        return !SimpleCatalog.isSimpleType(type);
    }

    static {
        keywordToPrimitive.put("boolean", Boolean.TYPE);
        keywordToPrimitive.put("char", Character.TYPE);
        keywordToPrimitive.put("byte", Byte.TYPE);
        keywordToPrimitive.put("short", Short.TYPE);
        keywordToPrimitive.put("int", Integer.TYPE);
        keywordToPrimitive.put("long", Long.TYPE);
        keywordToPrimitive.put("float", Float.TYPE);
        keywordToPrimitive.put("double", Double.TYPE);
        primitiveTypeToWrapper = new HashMap<Class, Class>(8);
        primitiveTypeToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveTypeToWrapper.put(Character.TYPE, Character.class);
        primitiveTypeToWrapper.put(Byte.TYPE, Byte.class);
        primitiveTypeToWrapper.put(Short.TYPE, Short.class);
        primitiveTypeToWrapper.put(Integer.TYPE, Integer.class);
        primitiveTypeToWrapper.put(Long.TYPE, Long.class);
        primitiveTypeToWrapper.put(Float.TYPE, Float.class);
        primitiveTypeToWrapper.put(Double.TYPE, Double.class);
        instance = new SimpleCatalog(null);
    }
}

