/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;

public abstract class ArrayTypeConstructor
implements TypeConstructor<Object[]> {
    private static final ArrayTypeConstructor ONE_BYTE_SIZE_ARRAY = new ArrayTypeConstructor(){

        @Override
        int read(QpidByteBuffer in) throws AmqpErrorException {
            if (!in.hasRemaining()) {
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Insufficient data to decode array", new Object[0]);
            }
            return in.get() & 0xFF;
        }
    };
    private static final ArrayTypeConstructor FOUR_BYTE_SIZE_ARRAY = new ArrayTypeConstructor(){

        @Override
        int read(QpidByteBuffer in) throws AmqpErrorException {
            if (!in.hasRemaining(4)) {
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Insufficient data to decode array", new Object[0]);
            }
            return in.getInt();
        }
    };

    @Override
    public Object[] construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        int size = this.read(in);
        long remaining = in.remaining();
        if (remaining < (long)size) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Insufficient data to decode array - requires %d octects, only %d remaining.", size, remaining);
        }
        int count = this.read(in);
        TypeConstructor t = handler.readConstructor(in);
        ArrayList rval = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            rval.add(t.construct(in, handler));
        }
        long expectedRemaining = remaining - (long)size;
        long unconsumedBytes = (long)in.remaining() - expectedRemaining;
        if (unconsumedBytes > 0L) {
            String msg = String.format("Array incorrectly encoded, %d bytes remaining after decoding %d elements", unconsumedBytes, count);
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, msg, new Object[0]);
        }
        if (unconsumedBytes < 0L) {
            String msg = String.format("Array incorrectly encoded, %d bytes beyond provided size consumed after decoding %d elements", -unconsumedBytes, count);
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, msg, new Object[0]);
        }
        if (rval.size() == 0) {
            return null;
        }
        return rval.toArray((Object[])Array.newInstance(rval.get(0).getClass(), rval.size()));
    }

    abstract int read(QpidByteBuffer var1) throws AmqpErrorException;

    public static ArrayTypeConstructor getOneByteSizeTypeConstructor() {
        return ONE_BYTE_SIZE_ARRAY;
    }

    public static ArrayTypeConstructor getFourByteSizeTypeConstructor() {
        return FOUR_BYTE_SIZE_ARRAY;
    }
}

