/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import io.netty.buffer.ByteBuf;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class BytesSchema
extends AbstractSchema<byte[]> {
    private static final BytesSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static BytesSchema of() {
        return INSTANCE;
    }

    public byte[] encode(byte[] message) {
        return message;
    }

    public byte[] decode(byte[] bytes) {
        return bytes;
    }

    @Override
    public byte[] decode(ByteBuf byteBuf) {
        if (byteBuf == null) {
            return null;
        }
        int size = byteBuf.readableBytes();
        byte[] bytes = new byte[size];
        byteBuf.getBytes(byteBuf.readerIndex(), bytes);
        return bytes;
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = SchemaInfoImpl.builder().name("Bytes").type(SchemaType.BYTES).schema(new byte[0]).build();
        INSTANCE = new BytesSchema();
    }
}

