/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.HeapDoublesSketch;
import com.yahoo.sketches.quantiles.Util;
import java.util.Arrays;

class DoublesUpdateImpl {
    DoublesUpdateImpl() {
    }

    static void growBaseBuffer(DoublesSketch sketch) {
        double[] baseBuffer = sketch.getCombinedBuffer();
        int oldSize = sketch.getCombinedBufferItemCapacity();
        int k = sketch.getK();
        assert (oldSize < 2 * k);
        int newSize = Math.max(Math.min(2 * k, 2 * oldSize), 1);
        sketch.putCombinedBufferItemCapacity(newSize);
        sketch.putCombinedBuffer(Arrays.copyOf(baseBuffer, newSize));
    }

    static void processFullBaseBuffer(HeapDoublesSketch sketch) {
        int bbCount = sketch.getBaseBufferCount();
        int k = sketch.getK();
        long newN = sketch.getN();
        assert (bbCount == 2 * k);
        DoublesUpdateImpl.maybeGrowLevels(newN, sketch);
        double[] baseBuffer = sketch.getCombinedBuffer();
        Arrays.sort(baseBuffer, 0, bbCount);
        DoublesUpdateImpl.inPlacePropagateCarry(0, null, 0, baseBuffer, 0, true, sketch);
        sketch.baseBufferCount_ = 0;
        assert (newN / (long)(2 * k) == sketch.getBitPattern());
    }

    static void maybeGrowLevels(long newN, HeapDoublesSketch sketch) {
        int k = sketch.getK();
        int numLevelsNeeded = Util.computeNumLevelsNeeded(k, newN);
        if (numLevelsNeeded == 0) {
            return;
        }
        assert (newN >= 2L * (long)k);
        assert (numLevelsNeeded > 0);
        int spaceNeeded = (2 + numLevelsNeeded) * k;
        if (spaceNeeded <= sketch.getCombinedBufferItemCapacity()) {
            return;
        }
        sketch.combinedBuffer_ = Arrays.copyOf(sketch.getCombinedBuffer(), spaceNeeded);
        sketch.combinedBufferItemCapacity_ = spaceNeeded;
    }

    static void inPlacePropagateCarry(int startingLevel, double[] sizeKBuf, int sizeKStart, double[] size2KBuf, int size2KStart, boolean doUpdateVersion, HeapDoublesSketch sketch) {
        double[] levelsArr = sketch.getCombinedBuffer();
        int k = sketch.getK();
        long bitPattern = sketch.bitPattern_;
        int endingLevel = Util.positionOfLowestZeroBitStartingAt(bitPattern, startingLevel);
        if (doUpdateVersion) {
            DoublesUpdateImpl.zipSize2KBuffer(size2KBuf, size2KStart, levelsArr, (2 + endingLevel) * k, k);
        } else {
            System.arraycopy(sizeKBuf, sizeKStart, levelsArr, (2 + endingLevel) * k, k);
        }
        for (int lvl = startingLevel; lvl < endingLevel; ++lvl) {
            assert ((bitPattern & 1L << lvl) > 0L);
            DoublesUpdateImpl.mergeTwoSizeKBuffers(levelsArr, (2 + lvl) * k, levelsArr, (2 + endingLevel) * k, size2KBuf, size2KStart, k);
            DoublesUpdateImpl.zipSize2KBuffer(size2KBuf, size2KStart, levelsArr, (2 + endingLevel) * k, k);
        }
        sketch.bitPattern_ = bitPattern + (1L << startingLevel);
    }

    private static void zipSize2KBuffer(double[] bufA, int startA, double[] bufC, int startC, int k) {
        int randomOffset = DoublesSketch.rand.nextBoolean() ? 1 : 0;
        int limC = startC + k;
        int a = startA + randomOffset;
        for (int c = startC; c < limC; ++c) {
            bufC[c] = bufA[a];
            a += 2;
        }
    }

    private static void mergeTwoSizeKBuffers(double[] keySrc1, int arrStart1, double[] keySrc2, int arrStart2, double[] keyDst, int arrStart3, int k) {
        int arrStop1 = arrStart1 + k;
        int arrStop2 = arrStart2 + k;
        int i1 = arrStart1;
        int i2 = arrStart2;
        int i3 = arrStart3;
        while (i1 < arrStop1 && i2 < arrStop2) {
            if (keySrc2[i2] < keySrc1[i1]) {
                keyDst[i3++] = keySrc2[i2++];
                continue;
            }
            keyDst[i3++] = keySrc1[i1++];
        }
        if (i1 < arrStop1) {
            System.arraycopy(keySrc1, i1, keyDst, i3, arrStop1 - i1);
        } else {
            assert (i2 < arrStop2);
            System.arraycopy(keySrc1, i2, keyDst, i3, arrStop2 - i2);
        }
    }
}

