/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2003 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.w3c.domts.DOMTest.load;


/**
 * The method "isSupported(feature,version)" Tests whether the DOM implementation
 * implements a specific feature and that feature is supported by this node.
 * Call the isSupported method on a new attribute node with a combination of features
 * versions and versions as below.  Valid feature names are case insensitive and versions
 * "2.0", "1.0" and if the version is not specified, supporting any version of the feature
 * should return true.  Check if the value returned value was true.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#Level-2-Core-Node-supports">http://www.w3.org/TR/DOM-Level-2-Core/core#Level-2-Core-Node-supports</a>
 */
public class nodeissupported02 {
    @Test
    void testRun() throws Throwable {
        String version = "";
        String version1 = "1.0";
        String version2 = "2.0";
        String[] featuresXML = { "XML", "xmL" };
        String[] featuresCore = { "Core", "CORE" };

        Document doc = load("staffNS", false);
        Attr attribute = doc.createAttribute("TestAttr");
        for (String featureXML : featuresXML) {
            assertTrue(attribute.isSupported(featureXML, version), "nodeissupported02_XML1");
            assertTrue(attribute.isSupported(featureXML, version1), "nodeissupported02_XML2");
        }
        for (String featureCore : featuresCore) {
            assertTrue(attribute.isSupported(featureCore, version), "nodeissupported02_Core1");
            assertTrue(attribute.isSupported(featureCore, version1), "nodeissupported02_Core2");
            assertTrue(attribute.isSupported(featureCore, version2), "nodeissupported02_Core3");
        }
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/nodeissupported02";
    }

}
