/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SecurityDataStatusReport1 extends SecurityData implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final SecurityArmCode armCodeType;
  protected final TamperStatus tamperStatus;
  protected final PanicStatus panicStatus;
  protected final List<ZoneStatus> zoneStatus;

  public SecurityDataStatusReport1(
      SecurityCommandTypeContainer commandTypeContainer,
      byte argument,
      SecurityArmCode armCodeType,
      TamperStatus tamperStatus,
      PanicStatus panicStatus,
      List<ZoneStatus> zoneStatus) {
    super(commandTypeContainer, argument);
    this.armCodeType = armCodeType;
    this.tamperStatus = tamperStatus;
    this.panicStatus = panicStatus;
    this.zoneStatus = zoneStatus;
  }

  public SecurityArmCode getArmCodeType() {
    return armCodeType;
  }

  public TamperStatus getTamperStatus() {
    return tamperStatus;
  }

  public PanicStatus getPanicStatus() {
    return panicStatus;
  }

  public List<ZoneStatus> getZoneStatus() {
    return zoneStatus;
  }

  @Override
  protected void serializeSecurityDataChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SecurityDataStatusReport1");

    // Simple Field (armCodeType)
    writeSimpleField("armCodeType", armCodeType, writeComplex(writeBuffer));

    // Simple Field (tamperStatus)
    writeSimpleField("tamperStatus", tamperStatus, writeComplex(writeBuffer));

    // Simple Field (panicStatus)
    writeSimpleField("panicStatus", panicStatus, writeComplex(writeBuffer));

    // Array Field (zoneStatus)
    writeComplexTypeArrayField("zoneStatus", zoneStatus, writeBuffer);

    writeBuffer.popContext("SecurityDataStatusReport1");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SecurityDataStatusReport1 _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (armCodeType)
    lengthInBits += armCodeType.getLengthInBits();

    // Simple field (tamperStatus)
    lengthInBits += tamperStatus.getLengthInBits();

    // Simple field (panicStatus)
    lengthInBits += panicStatus.getLengthInBits();

    // Array field
    if (zoneStatus != null) {
      int i = 0;
      for (ZoneStatus element : zoneStatus) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= zoneStatus.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static SecurityDataBuilder staticParseSecurityDataBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("SecurityDataStatusReport1");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    SecurityArmCode armCodeType =
        readSimpleField(
            "armCodeType", readComplex(() -> SecurityArmCode.staticParse(readBuffer), readBuffer));

    TamperStatus tamperStatus =
        readSimpleField(
            "tamperStatus", readComplex(() -> TamperStatus.staticParse(readBuffer), readBuffer));

    PanicStatus panicStatus =
        readSimpleField(
            "panicStatus", readComplex(() -> PanicStatus.staticParse(readBuffer), readBuffer));

    List<ZoneStatus> zoneStatus =
        readCountArrayField(
            "zoneStatus", readComplex(() -> ZoneStatus.staticParse(readBuffer), readBuffer), 32);

    readBuffer.closeContext("SecurityDataStatusReport1");
    // Create the instance
    return new SecurityDataStatusReport1BuilderImpl(
        armCodeType, tamperStatus, panicStatus, zoneStatus);
  }

  public static class SecurityDataStatusReport1BuilderImpl
      implements SecurityData.SecurityDataBuilder {
    private final SecurityArmCode armCodeType;
    private final TamperStatus tamperStatus;
    private final PanicStatus panicStatus;
    private final List<ZoneStatus> zoneStatus;

    public SecurityDataStatusReport1BuilderImpl(
        SecurityArmCode armCodeType,
        TamperStatus tamperStatus,
        PanicStatus panicStatus,
        List<ZoneStatus> zoneStatus) {
      this.armCodeType = armCodeType;
      this.tamperStatus = tamperStatus;
      this.panicStatus = panicStatus;
      this.zoneStatus = zoneStatus;
    }

    public SecurityDataStatusReport1 build(
        SecurityCommandTypeContainer commandTypeContainer, byte argument) {
      SecurityDataStatusReport1 securityDataStatusReport1 =
          new SecurityDataStatusReport1(
              commandTypeContainer, argument, armCodeType, tamperStatus, panicStatus, zoneStatus);
      return securityDataStatusReport1;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SecurityDataStatusReport1)) {
      return false;
    }
    SecurityDataStatusReport1 that = (SecurityDataStatusReport1) o;
    return (getArmCodeType() == that.getArmCodeType())
        && (getTamperStatus() == that.getTamperStatus())
        && (getPanicStatus() == that.getPanicStatus())
        && (getZoneStatus() == that.getZoneStatus())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getArmCodeType(), getTamperStatus(), getPanicStatus(), getZoneStatus());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
