/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetFaultParameterFaultCharacterStringListOfFaultValues is the corresponding interface of BACnetFaultParameterFaultCharacterStringListOfFaultValues
type BACnetFaultParameterFaultCharacterStringListOfFaultValues interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetListOfFaultValues returns ListOfFaultValues (property field)
	GetListOfFaultValues() []BACnetApplicationTagCharacterString
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetFaultParameterFaultCharacterStringListOfFaultValues is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetFaultParameterFaultCharacterStringListOfFaultValues()
	// CreateBuilder creates a BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder
	CreateBACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder() BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder
}

// _BACnetFaultParameterFaultCharacterStringListOfFaultValues is the data-structure of this message
type _BACnetFaultParameterFaultCharacterStringListOfFaultValues struct {
	OpeningTag        BACnetOpeningTag
	ListOfFaultValues []BACnetApplicationTagCharacterString
	ClosingTag        BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

var _ BACnetFaultParameterFaultCharacterStringListOfFaultValues = (*_BACnetFaultParameterFaultCharacterStringListOfFaultValues)(nil)

// NewBACnetFaultParameterFaultCharacterStringListOfFaultValues factory function for _BACnetFaultParameterFaultCharacterStringListOfFaultValues
func NewBACnetFaultParameterFaultCharacterStringListOfFaultValues(openingTag BACnetOpeningTag, listOfFaultValues []BACnetApplicationTagCharacterString, closingTag BACnetClosingTag, tagNumber uint8) *_BACnetFaultParameterFaultCharacterStringListOfFaultValues {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetFaultParameterFaultCharacterStringListOfFaultValues must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetFaultParameterFaultCharacterStringListOfFaultValues must not be nil")
	}
	return &_BACnetFaultParameterFaultCharacterStringListOfFaultValues{OpeningTag: openingTag, ListOfFaultValues: listOfFaultValues, ClosingTag: closingTag, TagNumber: tagNumber}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder is a builder for BACnetFaultParameterFaultCharacterStringListOfFaultValues
type BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, listOfFaultValues []BACnetApplicationTagCharacterString, closingTag BACnetClosingTag) BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder
	// WithListOfFaultValues adds ListOfFaultValues (property field)
	WithListOfFaultValues(...BACnetApplicationTagCharacterString) BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder
	// Build builds the BACnetFaultParameterFaultCharacterStringListOfFaultValues or returns an error if something is wrong
	Build() (BACnetFaultParameterFaultCharacterStringListOfFaultValues, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetFaultParameterFaultCharacterStringListOfFaultValues
}

// NewBACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder() creates a BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder
func NewBACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder() BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder {
	return &_BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder{_BACnetFaultParameterFaultCharacterStringListOfFaultValues: new(_BACnetFaultParameterFaultCharacterStringListOfFaultValues)}
}

type _BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder struct {
	*_BACnetFaultParameterFaultCharacterStringListOfFaultValues

	collectedErr []error
}

var _ (BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder) = (*_BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder)(nil)

func (b *_BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, listOfFaultValues []BACnetApplicationTagCharacterString, closingTag BACnetClosingTag) BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder {
	return b.WithOpeningTag(openingTag).WithListOfFaultValues(listOfFaultValues...).WithClosingTag(closingTag)
}

func (b *_BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder) WithListOfFaultValues(listOfFaultValues ...BACnetApplicationTagCharacterString) BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder {
	b.ListOfFaultValues = listOfFaultValues
	return b
}

func (b *_BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder) WithArgTagNumber(tagNumber uint8) BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder {
	b.TagNumber = tagNumber
	return b
}

func (b *_BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder) Build() (BACnetFaultParameterFaultCharacterStringListOfFaultValues, error) {
	if b.OpeningTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'openingTag' not set"))
	}
	if b.ClosingTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'closingTag' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetFaultParameterFaultCharacterStringListOfFaultValues.deepCopy(), nil
}

func (b *_BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder) MustBuild() BACnetFaultParameterFaultCharacterStringListOfFaultValues {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder) DeepCopy() any {
	_copy := b.CreateBACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder().(*_BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder creates a BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder
func (b *_BACnetFaultParameterFaultCharacterStringListOfFaultValues) CreateBACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder() BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder {
	if b == nil {
		return NewBACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder()
	}
	return &_BACnetFaultParameterFaultCharacterStringListOfFaultValuesBuilder{_BACnetFaultParameterFaultCharacterStringListOfFaultValues: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetFaultParameterFaultCharacterStringListOfFaultValues) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetFaultParameterFaultCharacterStringListOfFaultValues) GetListOfFaultValues() []BACnetApplicationTagCharacterString {
	return m.ListOfFaultValues
}

func (m *_BACnetFaultParameterFaultCharacterStringListOfFaultValues) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetFaultParameterFaultCharacterStringListOfFaultValues(structType any) BACnetFaultParameterFaultCharacterStringListOfFaultValues {
	if casted, ok := structType.(BACnetFaultParameterFaultCharacterStringListOfFaultValues); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetFaultParameterFaultCharacterStringListOfFaultValues); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetFaultParameterFaultCharacterStringListOfFaultValues) GetTypeName() string {
	return "BACnetFaultParameterFaultCharacterStringListOfFaultValues"
}

func (m *_BACnetFaultParameterFaultCharacterStringListOfFaultValues) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Array field
	if len(m.ListOfFaultValues) > 0 {
		for _, element := range m.ListOfFaultValues {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetFaultParameterFaultCharacterStringListOfFaultValues) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetFaultParameterFaultCharacterStringListOfFaultValuesParse(ctx context.Context, theBytes []byte, tagNumber uint8) (BACnetFaultParameterFaultCharacterStringListOfFaultValues, error) {
	return BACnetFaultParameterFaultCharacterStringListOfFaultValuesParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber)
}

func BACnetFaultParameterFaultCharacterStringListOfFaultValuesParseWithBufferProducer(tagNumber uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetFaultParameterFaultCharacterStringListOfFaultValues, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetFaultParameterFaultCharacterStringListOfFaultValues, error) {
		return BACnetFaultParameterFaultCharacterStringListOfFaultValuesParseWithBuffer(ctx, readBuffer, tagNumber)
	}
}

func BACnetFaultParameterFaultCharacterStringListOfFaultValuesParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (BACnetFaultParameterFaultCharacterStringListOfFaultValues, error) {
	v, err := (&_BACnetFaultParameterFaultCharacterStringListOfFaultValues{TagNumber: tagNumber}).parse(ctx, readBuffer, tagNumber)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetFaultParameterFaultCharacterStringListOfFaultValues) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (__bACnetFaultParameterFaultCharacterStringListOfFaultValues BACnetFaultParameterFaultCharacterStringListOfFaultValues, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetFaultParameterFaultCharacterStringListOfFaultValues"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetFaultParameterFaultCharacterStringListOfFaultValues")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	listOfFaultValues, err := ReadTerminatedArrayField[BACnetApplicationTagCharacterString](ctx, "listOfFaultValues", ReadComplex[BACnetApplicationTagCharacterString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagCharacterString](), readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'listOfFaultValues' field"))
	}
	m.ListOfFaultValues = listOfFaultValues

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetFaultParameterFaultCharacterStringListOfFaultValues"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetFaultParameterFaultCharacterStringListOfFaultValues")
	}

	return m, nil
}

func (m *_BACnetFaultParameterFaultCharacterStringListOfFaultValues) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetFaultParameterFaultCharacterStringListOfFaultValues) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetFaultParameterFaultCharacterStringListOfFaultValues"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetFaultParameterFaultCharacterStringListOfFaultValues")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}

	if err := WriteComplexTypeArrayField(ctx, "listOfFaultValues", m.GetListOfFaultValues(), writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'listOfFaultValues' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetFaultParameterFaultCharacterStringListOfFaultValues"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetFaultParameterFaultCharacterStringListOfFaultValues")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetFaultParameterFaultCharacterStringListOfFaultValues) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_BACnetFaultParameterFaultCharacterStringListOfFaultValues) IsBACnetFaultParameterFaultCharacterStringListOfFaultValues() {
}

func (m *_BACnetFaultParameterFaultCharacterStringListOfFaultValues) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetFaultParameterFaultCharacterStringListOfFaultValues) deepCopy() *_BACnetFaultParameterFaultCharacterStringListOfFaultValues {
	if m == nil {
		return nil
	}
	_BACnetFaultParameterFaultCharacterStringListOfFaultValuesCopy := &_BACnetFaultParameterFaultCharacterStringListOfFaultValues{
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopySlice[BACnetApplicationTagCharacterString, BACnetApplicationTagCharacterString](m.ListOfFaultValues),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
	}
	return _BACnetFaultParameterFaultCharacterStringListOfFaultValuesCopy
}

func (m *_BACnetFaultParameterFaultCharacterStringListOfFaultValues) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
