/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.webbeans.el22;

import org.apache.webbeans.el.ELContextStore;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;

public class WrappedMethodExpression extends MethodExpression
{
    private final MethodExpression delegate;

    public WrappedMethodExpression(final MethodExpression methodExpression)
    {
        this.delegate = methodExpression;
    }

    @Override
    public MethodInfo getMethodInfo(final ELContext context)
            throws NullPointerException, PropertyNotFoundException, MethodNotFoundException, ELException
    {
        return delegate.getMethodInfo(context);
    }

    @Override
    public Object invoke(final ELContext context, final Object[] params)
            throws NullPointerException, PropertyNotFoundException, MethodNotFoundException, ELException
    {
        try
        {
            return delegate.invoke(context, params);
        }
        finally
        {
            final ELContextStore store = ELContextStore.getInstance(false);
            if (store != null)
            {
                store.destroyDependents();
            }
        }
    }

    @Override
    public boolean equals(final Object obj)
    {
        return obj == this || delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return delegate.hashCode();
    }

    @Override
    public String getExpressionString()
    {
        return delegate.getExpressionString();
    }

    @Override
    public boolean isLiteralText()
    {
        return delegate.isLiteralText();
    }
}
