/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.bundles;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.bundles.IResourceBundle;

public class ResourceBundleReference
extends ResourceReference
implements IResourceBundle {
    private static final long serialVersionUID = 1L;
    private final ResourceReference bundleRef;
    private final List<HeaderItem> providedResources;

    public ResourceBundleReference(ResourceReference bundleRef) {
        super(bundleRef.getScope(), bundleRef.getName(), bundleRef.getLocale(), bundleRef.getStyle(), bundleRef.getVariation());
        this.bundleRef = bundleRef;
        this.providedResources = new ArrayList<HeaderItem>();
    }

    public ResourceReference getBundleReference() {
        return this.bundleRef;
    }

    public void addProvidedResources(HeaderItem ... items) {
        this.providedResources.addAll(Arrays.asList(items));
    }

    @Override
    public IResource getResource() {
        return this.getBundleReference().getResource();
    }

    @Override
    public Iterable<? extends HeaderItem> getProvidedResources() {
        return this.providedResources;
    }

    @Override
    public List<HeaderItem> getDependencies() {
        LinkedHashSet<HeaderItem> ret = new LinkedHashSet<HeaderItem>();
        for (HeaderItem curProvided : this.providedResources) {
            for (HeaderItem curDependency : curProvided.getDependencies()) {
                ret.add(curDependency);
            }
        }
        for (HeaderItem curProvided : this.providedResources) {
            ret.remove(curProvided);
        }
        List<HeaderItem> dependencies = super.getDependencies();
        dependencies.addAll(ret);
        return dependencies;
    }
}

