/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMatchingRuleType
extends GrammarAction<LdapMessageContainer<SearchRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreMatchingRuleType.class);

    public StoreMatchingRuleType() {
        super("Store matching type Value");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequest> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_05141_NULL_MATCHING_RULE_ASSERTION_TYPE, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)container.getTerminalFilter();
        String type = Strings.utf8ToString(tlv.getValue().getData());
        extensibleMatchFilter.setType(type);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05166_STORED_TYPE_MATCHING_RULE, type));
        }
    }
}

