/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jqplot.lib.chart;

import org.wicketstuff.jqplot.lib.ChartConfiguration;
import org.wicketstuff.jqplot.lib.JqPlotResources;
import org.wicketstuff.jqplot.lib.chart.AbstractChart;
import org.wicketstuff.jqplot.lib.data.BubbleData;
import org.wicketstuff.jqplot.lib.data.item.BubbleItem;
import org.wicketstuff.jqplot.lib.elements.Title;
import org.wicketstuff.jqplot.lib.metadata.JqPlotPlugin;

@JqPlotPlugin(values={JqPlotResources.BubbleRenderer})
public class BubbleChart
extends AbstractChart<BubbleData<BubbleItem>, String> {
    private static final long serialVersionUID = -8122703368130701972L;
    private final ChartConfiguration<String> chartConfig;
    private BubbleData<BubbleItem> bubbleData = new BubbleData();

    public BubbleChart() {
        this(null);
    }

    public BubbleChart(String title) {
        this.chartConfig = new ChartConfiguration();
        this.chartConfig.setTitle(new Title(title)).seriesDefaultsInstance().setRenderer(JqPlotResources.BubbleRenderer);
    }

    @Override
    public BubbleData<BubbleItem> getChartData() {
        return this.bubbleData;
    }

    public void addValue(BubbleItem item) {
        this.bubbleData.addValue(item);
    }

    public void addValue(Float x, Float y, Float radius, String label) {
        this.bubbleData.addValue(new BubbleItem(x, y, radius, label));
    }

    public void addValue(Integer x, Integer y, Integer radius, String label) {
        this.bubbleData.addValue(new BubbleItem(x, y, radius, label));
    }

    @Override
    public ChartConfiguration<String> getChartConfiguration() {
        return null;
    }
}

