/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.collectors;

import de.agilecoders.wicket.webjars.collectors.ProtocolAwareAssetPathCollector;
import de.agilecoders.wicket.webjars.util.WebJarAssetLocator;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class FileAssetPathCollector
extends ProtocolAwareAssetPathCollector {
    private final String pathPrefix;

    public FileAssetPathCollector(String pathPrefix) {
        super("file");
        this.pathPrefix = pathPrefix;
    }

    @Override
    public Collection<String> collect(URL url, Pattern filterExpr) {
        File file;
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new WebJarAssetLocator.ResourceException(url.toString(), e.getMessage());
        }
        return this.listFiles(file, filterExpr);
    }

    private Set<String> listFiles(File file, Pattern filterExpr) {
        HashSet<String> aggregatedChildren = new HashSet<String>();
        this.aggregateChildren(file, aggregatedChildren, filterExpr);
        return aggregatedChildren;
    }

    private void aggregateChildren(File file, Set<String> aggregatedChildren, Pattern filterExpr) {
        if (file != null && file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.aggregateChildren(child, aggregatedChildren, filterExpr);
                }
            }
        } else if (file != null) {
            this.aggregateFile(file, aggregatedChildren, filterExpr);
        }
    }

    private void aggregateFile(File file, Set<String> aggregatedChildren, Pattern filterExpr) {
        String path = file.getPath().replace('\\', '/');
        String relativePath = path.substring(path.indexOf(this.pathPrefix));
        if (filterExpr.matcher(relativePath).matches()) {
            aggregatedChildren.add(relativePath);
        }
    }
}

