/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.sequence;

import com.hazelcast.core.HazelcastOverloadException;
import com.hazelcast.internal.util.ConcurrencyDetection;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.Timer;
import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.internal.util.concurrent.IdleStrategy;
import com.hazelcast.spi.impl.sequence.AbstractCallIdSequence;
import java.util.concurrent.TimeUnit;

public final class CallIdSequenceWithBackpressure
extends AbstractCallIdSequence {
    static final int MAX_DELAY_MS = 500;
    private static final IdleStrategy IDLER = new BackoffIdleStrategy(0L, 0L, TimeUnit.MILLISECONDS.toNanos(1L), TimeUnit.MILLISECONDS.toNanos(500L));
    private final long backoffTimeoutNanos;

    public CallIdSequenceWithBackpressure(int maxConcurrentInvocations, long backoffTimeoutMs, ConcurrencyDetection concurrencyDetection) {
        super(maxConcurrentInvocations, concurrencyDetection);
        Preconditions.checkPositive("backoffTimeoutMs", backoffTimeoutMs);
        this.backoffTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(backoffTimeoutMs);
    }

    @Override
    protected void handleNoSpaceLeft() {
        long startNanos = Timer.nanos();
        long idleCount = 0L;
        while (true) {
            long elapsedNanos;
            if ((elapsedNanos = Timer.nanosElapsed(startNanos)) > this.backoffTimeoutNanos) {
                throw new HazelcastOverloadException(String.format("Timed out trying to acquire another call ID. maxConcurrentInvocations = %d, backoffTimeout = %d msecs, elapsed:%d msecs", this.getMaxConcurrentInvocations(), TimeUnit.NANOSECONDS.toMillis(this.backoffTimeoutNanos), TimeUnit.NANOSECONDS.toMillis(elapsedNanos)));
            }
            IDLER.idle(idleCount);
            if (this.hasSpace()) {
                return;
            }
            ++idleCount;
        }
    }
}

