/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.BinaryOperatorEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.impl.connector.HazelcastWriters;
import com.hazelcast.jet.impl.connector.MapSinkConfiguration;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.Sinks;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;

public class MapSinkBuilder<T, K, V> {
    private final String mapName;
    private DataConnectionRef dataConnectionRef;
    private ClientConfig clientConfig;
    private FunctionEx<? super T, ? extends K> toKeyFn;
    private FunctionEx<? super T, ? extends V> toValueFn;
    private BiFunctionEx<? super V, ? super T, ? extends V> updateFn;
    private BinaryOperatorEx<V> mergeFn;

    public MapSinkBuilder(@Nonnull String mapName) {
        this.mapName = Objects.requireNonNull(mapName, "mapName must not be null");
    }

    public MapSinkBuilder<T, K, V> dataConnectionRef(DataConnectionRef dataConnectionRef) {
        if (this.clientConfig != null) {
            throw new IllegalStateException("You cannot set dataConnectionRef, clientConfig is already set");
        }
        this.dataConnectionRef = Objects.requireNonNull(dataConnectionRef, "dataConnectionRef can not be null");
        return this;
    }

    public MapSinkBuilder<T, K, V> clientConfig(ClientConfig clientConfig) {
        if (this.dataConnectionRef != null) {
            throw new IllegalStateException("You cannot set clientConfig, dataConnectionRef is already set");
        }
        this.clientConfig = Objects.requireNonNull(clientConfig, "clientConfig can not be null");
        return this;
    }

    public MapSinkBuilder<T, K, V> toKeyFn(FunctionEx<? super T, ? extends K> toKeyFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        this.toKeyFn = toKeyFn;
        return this;
    }

    public MapSinkBuilder<T, K, V> toValueFn(FunctionEx<? super T, ? extends V> toValueFn) {
        Util.checkSerializable(toValueFn, "toValueFn");
        this.toValueFn = toValueFn;
        return this;
    }

    public MapSinkBuilder<T, K, V> updateFn(BiFunctionEx<? super V, ? super T, ? extends V> updateFn) {
        Util.checkSerializable(updateFn, "updateFn");
        this.updateFn = updateFn;
        return this;
    }

    public MapSinkBuilder<T, K, V> mergeFn(BinaryOperatorEx<V> mergeFn) {
        Util.checkSerializable(mergeFn, "mergeFn");
        this.mergeFn = mergeFn;
        return this;
    }

    public Sink<T> build() {
        this.validateOperation();
        MapSinkConfiguration<Object, ? extends K, Object> configuration = new MapSinkConfiguration<Object, K, Object>(this.mapName);
        configuration.setDataConnectionRef(this.dataConnectionRef);
        configuration.setClientXml(ImdgUtil.asXmlString(this.clientConfig));
        configuration.setToKeyFn(this.toKeyFn);
        configuration.setToValueFn(this.toValueFn);
        configuration.setUpdateFn(this.updateFn);
        configuration.setMergeFn(this.mergeFn);
        ProcessorMetaSupplier processorMetaSupplier = this.buildProcessorMetaSupplier(configuration);
        return Sinks.fromProcessor(this.getSinkName(), processorMetaSupplier, this.toKeyFn);
    }

    private void validateOperation() {
        boolean hasMergeFn;
        boolean hasToValueFn = this.toValueFn != null;
        boolean hasUpdateFn = this.updateFn != null;
        boolean bl = hasMergeFn = this.mergeFn != null;
        if (hasToValueFn && hasUpdateFn || hasUpdateFn && hasMergeFn) {
            throw new IllegalArgumentException("You must set exactly one combination of toValueFn, updateFn or updateFn and mergeFn parameters");
        }
    }

    private ProcessorMetaSupplier buildProcessorMetaSupplier(MapSinkConfiguration<T, K, V> configuration) {
        if (this.updateFn != null) {
            return HazelcastWriters.updateMapSupplier(configuration);
        }
        if (this.mergeFn != null) {
            return HazelcastWriters.mergeMapSupplier(configuration);
        }
        return HazelcastWriters.writeMapSupplier(configuration);
    }

    private String getSinkName() {
        StringBuilder sb = new StringBuilder();
        if (this.isRemote()) {
            sb.append("remote");
        }
        if (this.updateFn != null) {
            sb.append("MapWithUpdatingSink");
        } else if (this.mergeFn != null) {
            sb.append("MapWithMergingSink");
        } else {
            sb.append("MapSink");
        }
        sb.append('(').append(this.mapName).append(')');
        sb.replace(0, 1, sb.substring(0, 1).toLowerCase(Locale.ROOT));
        return sb.toString();
    }

    private boolean isRemote() {
        return this.dataConnectionRef != null || this.clientConfig != null;
    }
}

