/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.requests;

import java.io.InputStream;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ServiceHandler;
import org.apache.olingo.server.core.ServiceRequest;
import org.apache.olingo.server.core.responses.NoContentResponse;
import org.apache.olingo.server.core.responses.StreamResponse;

public class MediaRequest
extends ServiceRequest {
    private UriResourceEntitySet uriResourceEntitySet;

    public MediaRequest(OData odata, ServiceMetadata serviceMetadata) {
        super(odata, serviceMetadata);
    }

    @Override
    public void execute(ServiceHandler handler, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
        this.assertHttpMethod(response);
        if (this.isGET()) {
            handler.readMediaStream(this, new StreamResponse(this.getServiceMetaData(), response));
        } else if (this.isPUT()) {
            handler.upsertMediaStream(this, this.getETag(), this.getMediaStream(), new NoContentResponse(this.getServiceMetaData(), response));
        } else if (this.isDELETE()) {
            handler.upsertMediaStream(this, this.getETag(), null, new NoContentResponse(this.getServiceMetaData(), response));
        }
    }

    @Override
    public ContentType getResponseContentType() throws ContentNegotiatorException {
        return this.getRequestContentType();
    }

    public EdmEntitySet getEntitySet() {
        return this.uriResourceEntitySet.getEntitySet();
    }

    public EdmEntityType getEntityType() {
        return this.uriResourceEntitySet.getEntitySet().getEntityType();
    }

    public void setUriResourceEntitySet(UriResourceEntitySet uriResourceEntitySet) {
        this.uriResourceEntitySet = uriResourceEntitySet;
    }

    public List<UriParameter> getKeyPredicates() {
        if (this.uriResourceEntitySet != null) {
            return this.uriResourceEntitySet.getKeyPredicates();
        }
        return null;
    }

    private InputStream getMediaStream() {
        return this.request.getBody();
    }

    @Override
    public HttpMethod[] allowedMethods() {
        return new HttpMethod[]{HttpMethod.GET, HttpMethod.PUT, HttpMethod.DELETE};
    }
}

