/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch.impl;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import org.archive.util.binsearch.AbstractSeekableLineReader;
import org.archive.util.binsearch.ByteBufferInputStream;

public class MappedSeekableLineReader
extends AbstractSeekableLineReader {
    private ByteBufferInputStream bbis;

    public MappedSeekableLineReader(ByteBufferInputStream bbis, int blockSize) throws IOException {
        super(blockSize);
        this.bbis = bbis;
    }

    public long getOffset() throws IOException {
        if (this.closed) {
            return 0L;
        }
        return this.bbis.position();
    }

    @Override
    protected InputStream doSeekLoad(long offset, int maxLength) throws IOException {
        this.bbis.position(offset);
        if (maxLength > 0) {
            return ByteStreams.limit((InputStream)this.bbis, (long)maxLength);
        }
        return this.bbis;
    }

    @Override
    public long getSize() throws IOException {
        return this.bbis.length();
    }

    @Override
    protected void doClose() throws IOException {
        this.bbis = null;
    }
}

