/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.monitor.jvm;

import java.lang.management.ManagementFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class JvmPid {
    private static final long PID = JvmPid.initializePid();

    JvmPid() {
    }

    static long getPid() {
        return PID;
    }

    private static long initializePid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        try {
            return Long.parseLong(name.split("@")[0]);
        }
        catch (NumberFormatException e) {
            LogManager.getLogger(JvmPid.class).debug((Message)new ParameterizedMessage("failed parsing PID from [{}]", (Object)name), (Throwable)e);
            return -1L;
        }
    }
}

