/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.web.api.dto.NarCoordinateDTO;
import org.apache.nifi.web.api.dto.NarSummaryDTO;
import org.apache.nifi.web.api.entity.NarSummaryEntity;

public class NarUploadResult
extends AbstractWritableResult<NarSummaryEntity> {
    private static final String NAR_COORDINATE_FORMAT = "%s - %s - %s";
    private final NarSummaryEntity narSummaryEntity;

    public NarUploadResult(ResultType resultType, NarSummaryEntity narSummaryEntity) {
        super(resultType);
        this.narSummaryEntity = narSummaryEntity;
    }

    @Override
    public NarSummaryEntity getResult() {
        return this.narSummaryEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        NarSummaryDTO summaryDTO = this.narSummaryEntity.getNarSummary();
        output.println("Identifier: " + summaryDTO.getIdentifier());
        NarCoordinateDTO coordinateDTO = summaryDTO.getCoordinate();
        String narCoordinate = this.getCoordinateString(coordinateDTO);
        output.println("Coordinate: " + narCoordinate);
        NarCoordinateDTO dependencyCoordinateDTO = summaryDTO.getDependencyCoordinate();
        if (dependencyCoordinateDTO != null) {
            String dependencyCoordinate = this.getCoordinateString(dependencyCoordinateDTO);
            output.println("Dependency: " + dependencyCoordinate);
        }
        output.println("State: " + summaryDTO.getState());
    }

    private String getCoordinateString(NarCoordinateDTO coordinateDTO) {
        return NAR_COORDINATE_FORMAT.formatted(coordinateDTO.getGroup(), coordinateDTO.getArtifact(), coordinateDTO.getVersion());
    }
}

