/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.component.api;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.c2.protocol.component.api.BuildInfo;
import org.apache.nifi.c2.protocol.component.api.DefinedType;
import org.apache.nifi.c2.protocol.component.api.Restriction;
import org.apache.nifi.c2.protocol.component.api.Stateful;
import org.apache.nifi.c2.protocol.component.api.SystemResourceConsideration;

public class ExtensionComponent
extends DefinedType {
    private static final long serialVersionUID = 1L;
    private BuildInfo buildInfo;
    private List<DefinedType> providedApiImplementations;
    private Set<String> tags;
    private Set<String> seeAlso;
    private Boolean deprecated;
    private String deprecationReason;
    private Set<String> deprecationAlternatives;
    private Boolean restricted;
    private String restrictedExplanation;
    private Set<Restriction> explicitRestrictions;
    private Stateful stateful;
    private List<SystemResourceConsideration> systemResourceConsiderations;
    private boolean additionalDetails;

    @Schema(description="The build metadata for this component")
    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public void setBuildInfo(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    @Schema(description="If this type represents a provider for an interface, this lists the APIs it implements")
    public List<DefinedType> getProvidedApiImplementations() {
        return this.providedApiImplementations != null ? Collections.unmodifiableList(this.providedApiImplementations) : null;
    }

    public void setProvidedApiImplementations(List<DefinedType> providedApiImplementations) {
        this.providedApiImplementations = providedApiImplementations;
    }

    @Schema(description="The tags associated with this type")
    public Set<String> getTags() {
        return this.tags != null ? Collections.unmodifiableSet(this.tags) : null;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Schema(description="The names of other component types that may be related")
    public Set<String> getSeeAlso() {
        return this.seeAlso;
    }

    public void setSeeAlso(Set<String> seeAlso) {
        this.seeAlso = seeAlso;
    }

    @Schema(description="Whether or not the component has been deprecated")
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Schema(description="If this component has been deprecated, this optional field can be used to provide an explanation")
    public String getDeprecationReason() {
        return this.deprecationReason;
    }

    public void setDeprecationReason(String deprecationReason) {
        this.deprecationReason = deprecationReason;
    }

    @Schema(description="If this component has been deprecated, this optional field provides alternatives to use")
    public Set<String> getDeprecationAlternatives() {
        return this.deprecationAlternatives;
    }

    public void setDeprecationAlternatives(Set<String> deprecationAlternatives) {
        this.deprecationAlternatives = deprecationAlternatives;
    }

    @Schema(description="Whether or not the component has a general restriction")
    public Boolean isRestricted() {
        return this.restricted;
    }

    public Boolean getRestricted() {
        return this.restricted;
    }

    public void setRestricted(Boolean restricted) {
        this.restricted = restricted;
    }

    @Schema(description="An optional description of the general restriction")
    public String getRestrictedExplanation() {
        return this.restrictedExplanation;
    }

    public void setRestrictedExplanation(String restrictedExplanation) {
        this.restrictedExplanation = restrictedExplanation;
    }

    @Schema(description="Explicit restrictions that indicate a require permission to use the component")
    public Set<Restriction> getExplicitRestrictions() {
        return this.explicitRestrictions;
    }

    public void setExplicitRestrictions(Set<Restriction> explicitRestrictions) {
        this.explicitRestrictions = explicitRestrictions;
    }

    @Schema(description="Indicates if the component stores state")
    public Stateful getStateful() {
        return this.stateful;
    }

    public void setStateful(Stateful stateful) {
        this.stateful = stateful;
    }

    @Schema(description="The system resource considerations for the given component")
    public List<SystemResourceConsideration> getSystemResourceConsiderations() {
        return this.systemResourceConsiderations;
    }

    public void setSystemResourceConsiderations(List<SystemResourceConsideration> systemResourceConsiderations) {
        this.systemResourceConsiderations = systemResourceConsiderations;
    }

    @Schema(description="Indicates if the component has additional details documentation")
    public boolean isAdditionalDetails() {
        return this.additionalDetails;
    }

    public void setAdditionalDetails(boolean additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionComponent that = (ExtensionComponent)o;
        return super.equals(o) && Objects.equals(this.buildInfo, that.buildInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buildInfo);
    }
}

