/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.generator.FrameGenerator;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.http2.hpack.HpackEncoder;
import org.eclipse.jetty.http2.hpack.HpackException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class PushPromiseGenerator
extends FrameGenerator {
    private final HpackEncoder encoder;

    public PushPromiseGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder) {
        super(headerGenerator);
        this.encoder = encoder;
    }

    @Override
    public int generate(ByteBufferPool.Accumulator accumulator, Frame frame) throws HpackException {
        PushPromiseFrame pushPromiseFrame = (PushPromiseFrame)frame;
        return this.generatePushPromise(accumulator, pushPromiseFrame.getStreamId(), pushPromiseFrame.getPromisedStreamId(), (MetaData)pushPromiseFrame.getMetaData());
    }

    public int generatePushPromise(ByteBufferPool.Accumulator accumulator, int streamId, int promisedStreamId, MetaData metaData) throws HpackException {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        if (promisedStreamId < 0) {
            throw new IllegalArgumentException("Invalid promised stream id: " + promisedStreamId);
        }
        int maxFrameSize = this.getMaxFrameSize();
        int extraSpace = 4;
        RetainableByteBuffer hpack = this.encode(this.encoder, metaData, maxFrameSize -= extraSpace);
        ByteBuffer hpackByteBuffer = hpack.getByteBuffer();
        int hpackLength = hpackByteBuffer.position();
        BufferUtil.flipToFlush((ByteBuffer)hpackByteBuffer, (int)0);
        int length = hpackLength + extraSpace;
        int flags = 4;
        RetainableByteBuffer header = this.generateHeader(FrameType.PUSH_PROMISE, length, flags, streamId);
        ByteBuffer headerByteBuffer = header.getByteBuffer();
        headerByteBuffer.putInt(promisedStreamId);
        BufferUtil.flipToFlush((ByteBuffer)headerByteBuffer, (int)0);
        accumulator.append(header);
        accumulator.append(hpack);
        return 9 + length;
    }
}

