/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.logout;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class StandardLogoutFilter
extends OncePerRequestFilter {
    private final AntPathRequestMatcher requestMatcher;
    private final LogoutSuccessHandler logoutSuccessHandler;

    public StandardLogoutFilter(AntPathRequestMatcher requestMatcher, LogoutSuccessHandler logoutSuccessHandler) {
        this.requestMatcher = requestMatcher;
        this.logoutSuccessHandler = logoutSuccessHandler;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.requestMatcher.matches(request)) {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            Authentication authentication = securityContext.getAuthentication();
            this.logoutSuccessHandler.onLogoutSuccess(request, response, authentication);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

