/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.DefaultCairoConfiguration;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlExecutionContextImpl;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuestDbDatabaseManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestDbDatabaseManager.class);
    private static final Set<String> COMPONENT_TABLES = new HashSet<String>();
    private static final Set<String> NODE_TABLES = new HashSet<String>();

    private QuestDbDatabaseManager() {
    }

    public static void checkDatabaseStatus(Path persistLocation) {
        DatabaseStatus databaseStatus = QuestDbDatabaseManager.getDatabaseStatus(persistLocation);
        LOGGER.debug("Starting Status Repository: Database Status [{}]", (Object)databaseStatus);
        if (databaseStatus == DatabaseStatus.NON_EXISTING) {
            QuestDbDatabaseManager.createDatabase(persistLocation);
        } else if (databaseStatus == DatabaseStatus.CORRUPTED) {
            throw new RuntimeException("The database is corrupted. The expected set of tables is not matching with the reachable tables.");
        }
    }

    private static DatabaseStatus getDatabaseStatus(Path persistLocation) {
        if (!QuestDbDatabaseManager.checkPersistentLocationExists(persistLocation)) {
            return DatabaseStatus.NON_EXISTING;
        }
        if (QuestDbDatabaseManager.checkPersistentLocationExists(persistLocation) && QuestDbDatabaseManager.checkPersistentLocationIsEmpty(persistLocation)) {
            return DatabaseStatus.NON_EXISTING;
        }
        if (!QuestDbDatabaseManager.checkTablesAreInPlace(persistLocation) || !QuestDbDatabaseManager.checkConnection(persistLocation)) {
            return DatabaseStatus.CORRUPTED;
        }
        return DatabaseStatus.HEALTHY;
    }

    private static boolean checkPersistentLocationExists(Path persistLocation) {
        File persistLocationDirectory = persistLocation.toFile();
        return persistLocationDirectory.exists() && persistLocationDirectory.isDirectory();
    }

    private static boolean checkPersistentLocationIsEmpty(Path persistLocation) {
        File persistLocationDirectory = persistLocation.toFile();
        return persistLocationDirectory.list().length == 0;
    }

    private static boolean checkTablesAreInPlace(Path persistLocation) {
        File persistLocationDirectory = persistLocation.toFile();
        Map<String, File> databaseFiles = Arrays.stream(persistLocationDirectory.listFiles()).collect(Collectors.toMap(f -> f.getAbsolutePath().substring(persistLocationDirectory.getAbsolutePath().length() + 1), f -> f));
        HashSet<String> expectedTables = new HashSet<String>();
        expectedTables.addAll(NODE_TABLES);
        expectedTables.addAll(COMPONENT_TABLES);
        for (String expectedTable : expectedTables) {
            if (databaseFiles.containsKey(expectedTable) && databaseFiles.get(expectedTable).isDirectory()) continue;
            LOGGER.error("Missing table during database status check: {}", (Object)expectedTable);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkConnection(Path persistLocation) {
        String absolutePath = persistLocation.toFile().getAbsolutePath();
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration((CharSequence)absolutePath);
        try (CairoEngine engine = new CairoEngine((CairoConfiguration)configuration);){
            LOGGER.info("Database connection successful [{}]", (Object)absolutePath);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Database connection failed [{}]", (Object)absolutePath, (Object)e);
            return false;
        }
    }

    private static void createDatabase(Path persistLocation) {
        LOGGER.debug("Database creation started [{}]", (Object)persistLocation);
        try {
            FileUtils.ensureDirectoryExistAndCanReadAndWrite((File)persistLocation.toFile());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Database directory creation failed [%s]", persistLocation), e);
        }
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration((CharSequence)persistLocation.toFile().getAbsolutePath());
        try (CairoEngine engine = new CairoEngine((CairoConfiguration)configuration);
             SqlCompiler compiler = new SqlCompiler(engine);){
            SqlExecutionContextImpl context = new SqlExecutionContextImpl(engine, 1);
            compiler.compile((CharSequence)"CREATE TABLE garbageCollectionStatus (capturedAt TIMESTAMP,memoryManagerName SYMBOL capacity 4 nocache,collectionCount LONG,collectionMinis LONG) TIMESTAMP(capturedAt) PARTITION BY DAY", (SqlExecutionContext)context);
            compiler.compile((CharSequence)"CREATE TABLE nodeStatus (capturedAt TIMESTAMP,freeHeap LONG,usedHeap LONG,heapUtilization LONG,freeNonHeap LONG,usedNonHeap LONG,openFileHandlers LONG,processorLoadAverage DOUBLE,totalThreads LONG,eventDrivenThreads LONG,timerDrivenThreads LONG) TIMESTAMP(capturedAt) PARTITION BY DAY", (SqlExecutionContext)context);
            compiler.compile((CharSequence)"CREATE TABLE storageStatus (capturedAt TIMESTAMP,name SYMBOL capacity 256 nocache,storageType SHORT,freeSpace LONG,usedSpace LONG) TIMESTAMP(capturedAt) PARTITION BY DAY", (SqlExecutionContext)context);
            compiler.compile((CharSequence)"CREATE TABLE connectionStatus (capturedAt TIMESTAMP,componentId SYMBOL capacity 2000 nocache index capacity 1500,inputBytes LONG,inputCount LONG,outputBytes LONG,outputCount LONG,queuedBytes LONG,queuedCount LONG,totalQueuedDuration LONG,maxQueuedDuration LONG,averageQueuedDuration LONG) TIMESTAMP(capturedAt) PARTITION BY DAY", (SqlExecutionContext)context);
            compiler.compile((CharSequence)"CREATE TABLE processGroupStatus (capturedAt TIMESTAMP,componentId SYMBOL capacity 2000 nocache index capacity 1500,bytesRead LONG,bytesWritten LONG,bytesTransferred LONG,inputBytes LONG,inputCount LONG,outputBytes LONG,outputCount LONG,queuedBytes LONG,queuedCount LONG,taskMillis LONG) TIMESTAMP(capturedAt) PARTITION BY DAY", (SqlExecutionContext)context);
            compiler.compile((CharSequence)"CREATE TABLE remoteProcessGroupStatus (capturedAt TIMESTAMP,componentId SYMBOL capacity 2000 nocache index capacity 1500,sentBytes LONG,sentCount LONG,receivedBytes LONG,receivedCount LONG,receivedBytesPerSecond LONG,sentBytesPerSecond LONG,totalBytesPerSecond LONG,averageLineageDuration LONG) TIMESTAMP(capturedAt) PARTITION BY DAY", (SqlExecutionContext)context);
            compiler.compile((CharSequence)"CREATE TABLE processorStatus (capturedAt TIMESTAMP,componentId SYMBOL capacity 2000 nocache index capacity 1500,bytesRead LONG,bytesWritten LONG,bytesTransferred LONG,inputBytes LONG,inputCount LONG,outputBytes LONG,outputCount LONG,taskCount LONG,taskMillis LONG,taskNanos LONG,flowFilesRemoved LONG,averageLineageDuration LONG,averageTaskNanos LONG) TIMESTAMP(capturedAt) PARTITION BY DAY", (SqlExecutionContext)context);
            compiler.compile((CharSequence)"CREATE TABLE componentCounter (capturedAt TIMESTAMP,componentId SYMBOL capacity 2000 nocache index capacity 1500,name SYMBOL capacity 256 nocache,value LONG) TIMESTAMP(capturedAt) PARTITION BY DAY", (SqlExecutionContext)context);
            LOGGER.info("Database creation completed [{}]", (Object)persistLocation);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Database creation failed [%s]", persistLocation), e);
        }
    }

    public static Set<String> getNodeTableNames() {
        return NODE_TABLES;
    }

    public static Set<String> getComponentTableNames() {
        return COMPONENT_TABLES;
    }

    static {
        COMPONENT_TABLES.add("componentCounter");
        COMPONENT_TABLES.add("connectionStatus");
        COMPONENT_TABLES.add("processGroupStatus");
        COMPONENT_TABLES.add("remoteProcessGroupStatus");
        COMPONENT_TABLES.add("processorStatus");
        NODE_TABLES.add("nodeStatus");
        NODE_TABLES.add("garbageCollectionStatus");
        NODE_TABLES.add("storageStatus");
    }

    private static enum DatabaseStatus {
        HEALTHY,
        NON_EXISTING,
        CORRUPTED;

    }
}

