/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageException;

public class GetUriEvaluator
extends StringEvaluator {
    private final List<Evaluator<String>> uriArgs;

    public GetUriEvaluator(List<Evaluator<String>> uriArgs) {
        this.uriArgs = uriArgs;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        List args = this.uriArgs.stream().map(uriArg -> (String)uriArg.evaluate(evaluationContext).getValue()).collect(Collectors.toList());
        try {
            if (args.size() == 7) {
                String scheme = (String)args.get(0);
                String userInfo = (String)args.get(1);
                String host = (String)args.get(2);
                int port = this.getPort((String)args.get(3));
                String path = (String)args.get(4);
                String query = (String)args.get(5);
                String fragment = (String)args.get(6);
                URI uri = new URI(scheme, userInfo, host, port, path, query, fragment);
                return new StringQueryResult(uri.toString());
            }
            throw new AttributeExpressionLanguageException("Could not evaluate 'getUri' function with " + args.size() + " argument(s)");
        }
        catch (URISyntaxException use) {
            throw new AttributeExpressionLanguageException("Could not evaluate 'getUri' function with argument(s) " + args, use);
        }
    }

    private int getPort(String portArg) {
        try {
            return Integer.parseInt(portArg);
        }
        catch (NumberFormatException nfe) {
            throw new AttributeExpressionLanguageException("Could not evaluate 'getUri' function with argument '" + portArg + "' which is not a number", nfe);
        }
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return null;
    }
}

