/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public class File {
    @NotNull
    private final String path;
    private final long fd;
    private final long created;
    private final long lastModified;

    File(@NotNull String path, long fd, long created, long lastModified) {
        this.path = path;
        this.fd = fd;
        this.created = created;
        this.lastModified = lastModified;
    }

    File(@NotNull File origin) {
        this(origin.path, origin.fd, origin.created, System.currentTimeMillis());
    }

    File(@NotNull String path, @NotNull ByteIterable iterable) {
        this.path = path;
        ByteIterator iterator = iterable.iterator();
        this.fd = LongBinding.readCompressed((ByteIterator)iterator);
        this.created = LongBinding.readCompressed((ByteIterator)iterator);
        this.lastModified = LongBinding.readCompressed((ByteIterator)iterator);
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    public long getDescriptor() {
        return this.fd;
    }

    public long getCreated() {
        return this.created;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String toString() {
        return this.path + "[fd = " + this.fd + ']';
    }

    ArrayByteIterable toByteIterable() {
        LightOutputStream output = new LightOutputStream();
        int[] bytes = new int[8];
        LongBinding.writeCompressed((LightOutputStream)output, (long)this.fd, (int[])bytes);
        LongBinding.writeCompressed((LightOutputStream)output, (long)this.created, (int[])bytes);
        LongBinding.writeCompressed((LightOutputStream)output, (long)this.lastModified, (int[])bytes);
        return output.asArrayByteIterable();
    }
}

