/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinFactory;
import org.apache.myfaces.trinidadinternal.skin.RequestSkinWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinFactoryImpl
extends SkinFactory {
    private Map<String, Skin> _skins = new HashMap<String, Skin>();
    private static final String _SIMPLE_PDA = "simple.pda";
    private static final String _SIMPLE_DESKTOP = "simple.desktop";
    private static final String _SIMPLE_PORTLET = "simple.portlet";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinFactoryImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSkin(String skinId, Skin skin) {
        if (skinId == null || skin == null) {
            _LOG.warning("CANNOT_ADD_SKIN");
            return;
        }
        Map<String, Skin> map = this._skins;
        synchronized (map) {
            this._skins.put(skinId, skin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Skin getSkin(FacesContext context, String skinId) {
        if (skinId == null) {
            _LOG.warning("CANNOT_GET_SKIN_WITH_NULL_SKINID");
            return null;
        }
        Skin skin = null;
        Map<String, Skin> map = this._skins;
        synchronized (map) {
            if (this._skins.containsKey(skinId)) {
                skin = this._skins.get(skinId);
            }
        }
        return skin;
    }

    public Skin getSkin(FacesContext context, String family, String renderKitId) {
        if (family == null) {
            throw new NullPointerException("Null skin family");
        }
        if (renderKitId == null) {
            renderKitId = "org.apache.myfaces.trinidad.desktop";
        }
        Skin matchingSkin = null;
        for (Skin skin : this._skins.values()) {
            if (!family.equalsIgnoreCase(skin.getFamily()) || !renderKitId.equalsIgnoreCase(skin.getRenderKitId())) continue;
            matchingSkin = skin;
            break;
        }
        if (matchingSkin == null) {
            if (_LOG.isWarning()) {
                _LOG.warning("CANNOT_FIND_MATCHING_SKIN", new Object[]{family, renderKitId});
            }
            matchingSkin = renderKitId.equals("portlet") ? this.getSkin(context, _SIMPLE_PORTLET) : (renderKitId.equals("org.apache.myfaces.trinidad.pda") ? this.getSkin(context, _SIMPLE_PDA) : this.getSkin(context, _SIMPLE_DESKTOP));
        }
        return matchingSkin == null ? null : new RequestSkinWrapper(matchingSkin);
    }

    public Iterator<String> getSkinIds() {
        return this._skins.keySet().iterator();
    }
}

