/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.core.data.CoreColumn;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.SortCriterion;
import org.apache.myfaces.trinidad.render.XhtmlConstants;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.CellUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.ColumnData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.RenderStage;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;

public class ColumnGroupRenderer
extends XhtmlRenderer {
    protected static final int SORT_NO = 0;
    protected static final int SORT_SORTABLE = 1;
    protected static final int SORT_ASCENDING = 2;
    protected static final int SORT_DESCENDING = 3;
    private PropertyKey _headerTextKey;
    private PropertyKey _headerNoWrapKey;
    private PropertyKey _rowHeaderKey;
    private PropertyKey _separateRowsKey;
    private PropertyKey _noWrapKey;
    private PropertyKey _alignKey;
    private PropertyKey _widthKey;
    private PropertyKey _sortPropertyKey;
    private PropertyKey _sortableKey;
    private PropertyKey _defaultSortOrderKey;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ColumnGroupRenderer.class);

    public ColumnGroupRenderer() {
        super(CoreColumn.TYPE);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._headerTextKey = type.findKey("headerText");
        this._headerNoWrapKey = type.findKey("headerNoWrap");
        this._noWrapKey = type.findKey("noWrap");
        this._separateRowsKey = type.findKey("separateRows");
        this._rowHeaderKey = type.findKey("rowHeader");
        this._alignKey = type.findKey("align");
        this._widthKey = type.findKey("width");
        this._sortableKey = type.findKey("sortable");
        this._sortPropertyKey = type.findKey("sortProperty");
        this._defaultSortOrderKey = type.findKey("defaultSortOrder");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String getHeaderText(FacesBean bean) {
        return ColumnGroupRenderer.toString((Object)bean.getProperty(this._headerTextKey));
    }

    protected boolean getHeaderNoWrap(FacesBean bean) {
        Object o = bean.getProperty(this._headerNoWrapKey);
        if (o == null) {
            o = this._headerNoWrapKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected boolean getNoWrap(FacesBean bean) {
        Object o = bean.getProperty(this._noWrapKey);
        if (o == null) {
            o = this._noWrapKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected boolean getRowHeader(FacesBean bean) {
        Object o = bean.getProperty(this._rowHeaderKey);
        if (o == null) {
            o = this._rowHeaderKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected boolean getSeparateRows(FacesBean bean) {
        Object o = bean.getProperty(this._separateRowsKey);
        if (o == null) {
            o = this._separateRowsKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected String getWidth(FacesBean bean) {
        return ColumnGroupRenderer.toString((Object)bean.getProperty(this._widthKey));
    }

    protected String getFormatType(FacesBean bean) {
        return ColumnGroupRenderer.toString((Object)bean.getProperty(this._alignKey));
    }

    protected boolean getSortable(FacesBean bean) {
        Object o = bean.getProperty(this._sortableKey);
        if (o == null) {
            o = this._sortableKey.getDefault();
        }
        return !Boolean.FALSE.equals(o);
    }

    protected String getSortProperty(FacesBean bean) {
        return ColumnGroupRenderer.toString((Object)bean.getProperty(this._sortPropertyKey));
    }

    protected String getDefaultSortOrder(FacesBean bean) {
        if (this._defaultSortOrderKey == null) {
            return null;
        }
        return ColumnGroupRenderer.toString((Object)bean.getProperty(this._defaultSortOrderKey));
    }

    public static String getDefaultHeaderStyleClass(TableRenderingContext tContext) {
        return ColumnData.selectFormat(tContext, "af|column::header-text", "af|column::header-number", "af|column::header-icon-format");
    }

    protected String getHeaderStyleClass(TableRenderingContext tContext) {
        return ColumnGroupRenderer.getDefaultHeaderStyleClass(tContext);
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
        RenderStage rs = tContext.getRenderStage();
        int stage = rs.getStage();
        switch (stage) {
            case 0: {
                this._computeMode(context, tContext, component);
                break;
            }
            case 20: {
                this._renderHeaderMode(context, arc, tContext, component);
                break;
            }
            case 30: 
            case 35: 
            case 60: {
                this._renderChildren(context, component, null);
                break;
            }
            case 100: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Bad renderStage:" + stage));
            }
        }
    }

    private void _renderHeaderMode(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent column) throws IOException {
        NodeData currentNode;
        boolean areWeRoot;
        NodeData parentNode = this.getParentNode(tContext);
        if (parentNode == null) {
            areWeRoot = true;
            currentNode = this._getNodeList(tContext, false).getNext();
        } else {
            areWeRoot = false;
            currentNode = parentNode.get(parentNode.currentChild);
        }
        ColumnData colData = tContext.getColumnData();
        int row = colData.getRowIndex();
        int waitUntilRow = currentNode.waitUntilRow;
        if (waitUntilRow == 0) {
            int totalRows = colData.getHeaderRowSpan();
            int rowSpan = totalRows - row - currentNode.rows + 1;
            currentNode.waitUntilRow = rowSpan + row;
            String headerID = this._renderColumnHeader(context, arc, tContext, column, rowSpan, currentNode.cols);
            if (headerID != null) {
                currentNode.headerIDs = areWeRoot ? headerID : parentNode.headerIDs + " " + headerID;
            }
        } else if (row >= waitUntilRow) {
            this._setParentNode(tContext, currentNode);
            this._renderChildren(context, column, currentNode);
            this._setParentNode(tContext, parentNode);
            return;
        }
        colData.setColumnIndex(colData.getPhysicalColumnIndex() + currentNode.cols, colData.getLogicalColumnIndex());
    }

    private String _renderColumnHeader(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent column, int rowSpan, int colSpan) throws IOException {
        ColumnData colData = tContext.getColumnData();
        boolean isNoWrap = this.getHeaderNoWrap(this.getFacesBean(column));
        colData.setColumnGroupHeader(true);
        colData.setCurrentHeaderNoWrap(isNoWrap);
        String colID = this.renderHeaderAndSpan(context, arc, tContext, column, rowSpan, colSpan);
        colData.setColumnGroupHeader(false);
        colData.setCurrentHeaderNoWrap(false);
        return colID;
    }

    protected final String renderHeaderAndSpan(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent column, int rowSpan, int colSpan) throws IOException {
        boolean hasSortingIcon;
        FormData formData;
        Object domLevel;
        boolean sortable;
        ColumnData colData = tContext.getColumnData();
        String colID = this.shouldRenderId(context, column) || tContext.isExplicitHeaderIDMode() ? this.getClientId(context, column) : null;
        int physicalIndex = colData.getPhysicalColumnIndex();
        int sortability = this.getSortability(tContext, column);
        boolean bl = sortable = sortability != 0 && ColumnGroupRenderer.supportsNavigation(arc);
        if (sortable && ((domLevel = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_DOM)) == null || domLevel == TrinidadAgent.DOM_CAP_NONE || domLevel == TrinidadAgent.DOM_CAP_FORM) && (formData = arc.getFormData()) != null) {
            formData.addNeededValue("state");
        }
        boolean isNoWrap = colData.isColumnGroupHeader() ? colData.getCurrentHeaderNoWrap() : colData.getHeaderNoWrap(physicalIndex);
        String sortIconName = this._getIconName(sortability);
        Icon sortIcon = arc.getIcon(sortIconName);
        boolean bl2 = hasSortingIcon = sortIcon != null && !sortIcon.isNull();
        if (!ColumnGroupRenderer.isPDA((RenderingContext)arc)) {
            isNoWrap = isNoWrap || hasSortingIcon;
        }
        Object width = tContext.getColumnWidth(physicalIndex);
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("th", column);
        rw.writeAttribute("id", (Object)colID, "id");
        CellUtils.renderHeaderAttrs(context, tContext, null, width, isNoWrap, true);
        String styleClass = this.getSortableHeaderStyleClass(tContext, sortability);
        String borderStyleClass = CellUtils.getHeaderBorderStyle(tContext, arc, true, sortable);
        ColumnGroupRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)arc, (String[])new String[]{styleClass, borderStyleClass});
        String style = this.getHeaderInlineStyle(arc);
        ColumnGroupRenderer.renderInlineStyleAttribute(context, arc, style);
        if (colSpan > 1) {
            rw.writeAttribute("colspan", (Object)IntegerUtils.getString((int)colSpan), null);
        }
        if (rowSpan == 0) {
            rowSpan = colData.getHeaderRowSpan();
        }
        if (rowSpan > 1) {
            rw.writeAttribute("rowspan", (Object)IntegerUtils.getString((int)rowSpan), null);
        }
        String sortOnclick = "";
        if (ColumnGroupRenderer.supportsScripting(arc)) {
            sortOnclick = this.getSortingOnclick(arc, tContext, column, sortability);
        }
        if (!ColumnGroupRenderer.isPDA((RenderingContext)arc) && ColumnGroupRenderer.supportsScripting(arc)) {
            rw.writeAttribute("onclick", (Object)sortOnclick, null);
        }
        this.renderHeaderContents(context, arc, tContext, column, sortability, sortIcon, sortOnclick);
        rw.endElement("th");
        return colID;
    }

    protected String getHeaderInlineStyle(RenderingContext arc) {
        return null;
    }

    protected String getSortingOnclick(RenderingContext arc, TableRenderingContext tContext, UIComponent column, int sortability) {
        FacesBean bean = this.getFacesBean(column);
        String onclick = this.getOnclick(bean);
        if (sortability == 0) {
            return onclick;
        }
        if (arc.getFormData() == null) {
            _LOG.warning("SORTING_DISABLED_TABLE_NOT_IN_FORM");
            return onclick;
        }
        String formName = arc.getFormData().getName();
        String source = tContext.getTableId();
        String value = this.getSortProperty(bean);
        String state = this.findSortState(sortability, bean);
        StringBuffer buffer = new StringBuffer(33 + formName.length() + source.length() + value.length() + state.length());
        buffer.append("return _tableSort('");
        buffer.append(formName);
        buffer.append(tContext.isImmediate() ? "',0,'" : "',1,'");
        buffer.append(source);
        buffer.append("','");
        buffer.append(value);
        if (state != "") {
            buffer.append("','");
            buffer.append(state);
        }
        buffer.append("');");
        String sortJS = buffer.toString();
        if (onclick != null) {
            sortJS = XhtmlUtils.getChainedJS(onclick, sortJS, true);
        }
        return sortJS;
    }

    protected void renderHeaderContents(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent column, int sortability, Icon sortIcon, String sortOnclick) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        UIComponent header = ColumnGroupRenderer.getFacet((UIComponent)column, (String)"header");
        if (header != null) {
            this.encodeChild(context, header);
        } else {
            String headerText = this.getHeaderText(this.getFacesBean(column));
            if (headerText != null) {
                rw.writeText((Object)headerText, "headerText");
            }
        }
        this.renderSortOrderSymbol(context, arc, column, tContext, sortability, sortIcon, sortOnclick);
    }

    protected void renderSortOrderSymbol(FacesContext context, RenderingContext arc, UIComponent column, TableRenderingContext tContext, int sortability, Icon icon, String sortOnclick) throws IOException {
        if (icon == null || icon.isNull()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean supportNav = ColumnGroupRenderer.supportsNavigation(arc);
        boolean NonJavaScriptBrowser = false;
        boolean renderedInput = false;
        if (supportNav) {
            if (ColumnGroupRenderer.isPDA((RenderingContext)arc)) {
                writer.writeText((Object)XhtmlConstants.NBSP_STRING, null);
            }
            boolean bl = NonJavaScriptBrowser = !ColumnGroupRenderer.supportsScripting(arc);
            if (NonJavaScriptBrowser) {
                renderedInput = true;
                writer.startElement("input", null);
                writer.writeAttribute("type", (Object)"submit", null);
                String source = tContext.getTableId();
                FacesBean bean = this.getFacesBean(column);
                String value = this.getSortProperty(bean);
                String state = this.findSortState(sortability, bean);
                String nameAttri = state != "" ? XhtmlUtils.getEncodedParameter("source") + XhtmlUtils.getEncodedParameter(source) + XhtmlUtils.getEncodedParameter("value") + XhtmlUtils.getEncodedParameter(value) + XhtmlUtils.getEncodedParameter("event") + XhtmlUtils.getEncodedParameter("sort") + XhtmlUtils.getEncodedParameter("state") + state : XhtmlUtils.getEncodedParameter("source") + XhtmlUtils.getEncodedParameter(source) + XhtmlUtils.getEncodedParameter("event") + XhtmlUtils.getEncodedParameter("sort") + XhtmlUtils.getEncodedParameter("value") + value;
                writer.writeAttribute("name", (Object)nameAttri, null);
                if (state.equals("ascending")) {
                    writer.writeAttribute("value", (Object)"^", null);
                } else {
                    writer.writeAttribute("value", (Object)"v", null);
                }
                writer.writeAttribute("class", (Object)"AFSortableHeaderSortIcon", null);
            } else {
                writer.startElement("a", null);
                writer.writeURIAttribute("href", (Object)"#", null);
                writer.writeAttribute("onclick", (Object)sortOnclick, null);
            }
        }
        String altTextKey = null;
        if (sortability == 2) {
            altTextKey = "af_column.SORTED_ASCEND_TIP";
        } else if (sortability == 3) {
            altTextKey = "af_column.SORTED_DESCEND_TIP";
        } else if (sortability == 1) {
            altTextKey = "af_column.SORTED_SORTABLE_TIP";
        }
        String altText = arc.getTranslatedString(altTextKey);
        String align = OutputUtils.getMiddleIconAlignment(arc);
        if (!renderedInput) {
            OutputUtils.renderIcon(context, arc, icon, altText, align, true);
        }
        if (supportNav) {
            if (NonJavaScriptBrowser) {
                writer.writeAttribute("title", (Object)altText, null);
                writer.endElement("input");
            } else {
                writer.endElement("a");
            }
        }
    }

    protected final int getSortability(TableRenderingContext tContext, UIComponent column) {
        SortCriterion criterion;
        if (tContext.getRowData().isEmptyTable()) {
            return 0;
        }
        FacesBean bean = this.getFacesBean(column);
        if (column == null) {
            return 0;
        }
        String property = this.getSortProperty(bean);
        if (property == null) {
            return 0;
        }
        if (!this.getSortable(bean)) {
            return 0;
        }
        UIXCollection table = (UIXCollection)tContext.getTable();
        List criteria = table.getSortCriteria();
        if (criteria.size() > 0 && property.equals((criterion = (SortCriterion)criteria.get(0)).getProperty())) {
            return criterion.isAscending() ? 2 : 3;
        }
        return table.isSortable(property) ? 1 : 0;
    }

    protected boolean hasSortingIcon(RenderingContext arc, int sortability) {
        return sortability != 0;
    }

    private String _getIconName(int sortable) {
        switch (sortable) {
            case 1: {
                return "af|column::unsorted-icon";
            }
            case 2: {
                return "af|column::sort-ascend-icon";
            }
            case 3: {
                return "af|column::sort-descend-icon";
            }
        }
        return null;
    }

    private void _computeMode(FacesContext context, TableRenderingContext tContext, UIComponent component) throws IOException {
        tContext.setExplicitHeaderIDMode(true);
        NodeData parentNode = this.getParentNode(tContext);
        boolean areWeRoot = parentNode == null;
        int kids = component.getChildCount();
        NodeData currentNode = new NodeData(kids);
        if (areWeRoot) {
            this._getNodeList(tContext, true).add(currentNode);
        }
        this._setParentNode(tContext, currentNode);
        this._renderChildren(context, component, currentNode);
        ColumnData colData = tContext.getColumnData();
        if (areWeRoot) {
            colData.setHeaderRowSpan(currentNode.rows);
            int cols = currentNode.cols + colData.getColumnCount() - 1;
            colData.setColumnCount(cols);
        } else {
            int rows = currentNode.rows + 1;
            if (parentNode.rows < rows) {
                parentNode.rows = rows;
            }
            parentNode.cols += currentNode.cols;
            parentNode.set(parentNode.currentChild, currentNode);
        }
        this._setParentNode(tContext, parentNode);
    }

    private void _renderChildren(FacesContext context, UIComponent component, NodeData parentNode) throws IOException {
        int i = 0;
        for (UIComponent child : component.getChildren()) {
            if (child.isRendered()) {
                if (parentNode != null) {
                    parentNode.currentChild = i;
                }
                this.encodeChild(context, child);
            }
            ++i;
        }
    }

    protected final NodeData getParentNode(TableRenderingContext tContext) {
        NodeList nl = this._getNodeList(tContext, false);
        return nl == null ? null : nl.currentNode;
    }

    private void _setParentNode(TableRenderingContext tContext, NodeData parentNode) {
        this._getNodeList((TableRenderingContext)tContext, (boolean)true).currentNode = parentNode;
    }

    protected String getSortableHeaderStyleClass(TableRenderingContext tContext, int sortability) {
        ColumnData colData = tContext.getColumnData();
        if (colData.isColumnGroupHeader()) {
            return "af|column::header-icon-format";
        }
        switch (sortability) {
            case 0: {
                return this.getHeaderStyleClass(tContext);
            }
            case 1: {
                return ColumnData.selectFormat(tContext, "af|column::sortable-header-text", "af|column::sortable-header-number", "af|column::sortable-header-icon-format");
            }
        }
        return ColumnData.selectFormat(tContext, "af|column::sorted-header-text", "af|column::sorted-header-number", "af|column::sorted-header-icon-format");
    }

    private NodeList _getNodeList(TableRenderingContext tContext, boolean create) {
        NodeList root = (NodeList)tContext.getHeaderNodesList();
        if (root == null && create) {
            root = new NodeList();
            tContext.setHeaderNodeList(root);
        }
        return root;
    }

    private String findSortState(int sortability, FacesBean bean) {
        String state = sortability == 2 ? "ascending" : (sortability == 3 ? "descending" : ("descending".equals(this.getDefaultSortOrder(bean)) ? "ascending" : ""));
        return state;
    }

    protected static final class NodeData {
        private final NodeData[] _kids;
        public int rows;
        public int cols;
        public int waitUntilRow = 0;
        public int currentChild;
        public String headerIDs = null;

        public NodeData() {
            this.cols = 1;
            this.rows = 1;
            this._kids = null;
        }

        private NodeData(int kids) {
            this.cols = 0;
            this.rows = 0;
            this._kids = new NodeData[kids];
        }

        public void set(int index, NodeData kid) {
            this._kids[index] = kid;
        }

        public int size() {
            return this._kids == null ? 0 : this._kids.length;
        }

        public NodeData get(int index) {
            return this._kids[index];
        }
    }

    private static final class NodeList {
        private final ArrayList<NodeData> _list = new ArrayList(10);
        private int _index = 0;
        public NodeData currentNode = null;

        private NodeList() {
        }

        public void add(NodeData node) {
            this._list.add(node);
        }

        public NodeData getNext() {
            if (this._index >= this._list.size()) {
                this._index = 0;
            }
            return this._list.get(this._index++);
        }
    }
}

