/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.context.external;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractAttributeMap<K, V>
implements Map<K, V> {
    private Set<Map.Entry<K, V>> _entrySet;
    private Set<K> _keySet;
    private Collection<V> _values;

    AbstractAttributeMap() {
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getAttribute(key) != null;
    }

    @Override
    public boolean containsValue(Object findValue) {
        if (findValue == null) {
            return false;
        }
        Enumeration<K> e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            V value = this.getAttribute(e.nextElement());
            if (!findValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._entrySet != null ? this._entrySet : (this._entrySet = new EntrySet());
    }

    @Override
    public V get(Object key) {
        return this.getAttribute(key.toString());
    }

    @Override
    public boolean isEmpty() {
        return !this.getAttributeNames().hasMoreElements();
    }

    @Override
    public Set<K> keySet() {
        return this._keySet != null ? this._keySet : (this._keySet = new KeySet());
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int size = 0;
        Enumeration<K> e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            ++size;
            e.nextElement();
        }
        return size;
    }

    @Override
    public Collection<V> values() {
        return this._values != null ? this._values : (this._values = new Values());
    }

    protected abstract V getAttribute(Object var1);

    protected abstract Enumeration<K> getAttributeNames();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesIterator
    extends BaseAbstractIterator<V> {
        private ValuesIterator() {
        }

        @Override
        public V next() {
            this.advance();
            return AbstractAttributeMap.this.get(this._currentKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends BaseAbstractSet<V> {
        private Values() {
        }

        @Override
        public boolean contains(Object o) {
            return AbstractAttributeMap.this.containsValue(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValuesIterator();
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                return false;
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                it.remove();
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends BaseAbstractSet<K> {
        private KeySet() {
        }

        @Override
        public boolean contains(Object o) {
            return AbstractAttributeMap.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object o) {
            return AbstractAttributeMap.this.remove(o) != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends BaseAbstractIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            this.advance();
            return this._currentKey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySetEntry
    implements Map.Entry<K, V> {
        private final K _currentKey;

        public EntrySetEntry(K currentKey) {
            this._currentKey = currentKey;
        }

        @Override
        public K getKey() {
            return this._currentKey;
        }

        @Override
        public V getValue() {
            return AbstractAttributeMap.this.get(this._currentKey);
        }

        @Override
        public V setValue(V value) {
            return AbstractAttributeMap.this.put(this._currentKey, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends BaseAbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) {
                return false;
            }
            return value.equals(AbstractAttributeMap.this.get(key));
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null || !value.equals(AbstractAttributeMap.this.get(key))) {
                return false;
            }
            return AbstractAttributeMap.this.remove(((Map.Entry)o).getKey()) != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends BaseAbstractIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            this.advance();
            return new EntrySetEntry(this._currentKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseAbstractSet<T>
    extends AbstractSet<T> {
        private BaseAbstractSet() {
        }

        @Override
        public void clear() {
            AbstractAttributeMap.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return AbstractAttributeMap.this.isEmpty();
        }

        @Override
        public int size() {
            return AbstractAttributeMap.this.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseAbstractIterator<T>
    implements Iterator<T> {
        protected K _currentKey;
        protected final Enumeration<K> _e;

        private BaseAbstractIterator() {
            this._e = AbstractAttributeMap.this.getAttributeNames();
        }

        @Override
        public boolean hasNext() {
            return this._e.hasMoreElements();
        }

        @Override
        public void remove() {
            if (this._currentKey == null) {
                throw new NoSuchElementException();
            }
            AbstractAttributeMap.this.remove(this._currentKey);
        }

        protected void advance() {
            this._currentKey = this._e.nextElement();
        }
    }
}

