/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.event.SortActionEvent;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.LazyScrollPosition;
import org.apache.myfaces.tobago.model.ScrollPosition;
import org.apache.myfaces.tobago.model.ScrollPositionState;
import org.apache.myfaces.tobago.model.SelectedState;
import org.apache.myfaces.tobago.model.SortedColumnList;

public class SheetState
implements Serializable,
ScrollPositionState {
    private static final long serialVersionUID = 2L;
    private int first;
    private SortedColumnList sortedColumnList;
    private List<Integer> columnWidths;
    private List<Integer> selectedRows;
    private ScrollPosition scrollPosition;
    private LazyScrollPosition lazyScrollPosition;
    private ExpandedState expandedState;
    private SelectedState selectedState;

    @Deprecated(since="5.3.0", forRemoval=true)
    public SheetState() {
        this(1);
    }

    public SheetState(int maxSortColumns) {
        this.reset(maxSortColumns);
    }

    @Deprecated(since="5.3.0", forRemoval=true)
    public void reset() {
        this.reset(1);
    }

    public void reset(int maxSortColumns) {
        this.first = -1;
        this.sortedColumnList = new SortedColumnList(maxSortColumns);
        this.columnWidths = new ArrayList<Integer>();
        this.resetSelected();
        if (this.expandedState != null) {
            this.expandedState.reset();
        }
        if (this.selectedState != null) {
            this.selectedState.clear();
        }
        if (this.scrollPosition != null) {
            this.scrollPosition.clear();
        } else {
            this.scrollPosition = new ScrollPosition();
        }
        if (this.lazyScrollPosition != null) {
            this.lazyScrollPosition.clear();
        } else {
            this.lazyScrollPosition = new LazyScrollPosition();
        }
    }

    public void resetSelected() {
        this.selectedRows = new ArrayList<Integer>();
    }

    public List<Integer> getSelectedRows() {
        return this.selectedRows;
    }

    public void setSelectedRows(List<Integer> selectedRows) {
        assert (selectedRows != null);
        this.selectedRows = selectedRows;
    }

    @Deprecated(since="5.3.0", forRemoval=true)
    public String getSortedColumnId() {
        if (this.sortedColumnList.isEmpty()) {
            return null;
        }
        return this.sortedColumnList.getFirst().getId();
    }

    @Deprecated(since="5.3.0", forRemoval=true)
    public void setSortedColumnId(String sortedColumnId) {
        if (!FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Production)) {
            Deprecation.LOG.warn("Method SheetState.setSortedColumnId() should not be called!");
        }
        if (this.sortedColumnList.isEmpty()) {
            this.sortedColumnList.add(sortedColumnId, true);
        } else if (StringUtils.notEquals(this.sortedColumnList.getFirst().getId(), sortedColumnId)) {
            this.sortedColumnList.getFirst().setId(sortedColumnId);
        }
    }

    @Deprecated(since="5.3.0", forRemoval=true)
    public boolean isAscending() {
        if (this.sortedColumnList.isEmpty()) {
            return true;
        }
        return this.sortedColumnList.getFirst().isAscending();
    }

    @Deprecated(since="5.3.0", forRemoval=true)
    public void setAscending(boolean ascending) {
        if (!FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Production)) {
            Deprecation.LOG.warn("Method SheetState.setAscending() should not be called!");
        }
        if (this.sortedColumnList.isEmpty()) {
            this.sortedColumnList.add(null, ascending);
        } else if (this.sortedColumnList.getFirst().isAscending() != ascending) {
            this.sortedColumnList.getFirst().setAscending(ascending);
        }
    }

    public SortedColumnList getSortedColumnList() {
        return this.sortedColumnList;
    }

    public List<Integer> getColumnWidths() {
        return this.columnWidths;
    }

    public void setColumnWidths(List<Integer> columnWidths) {
        this.columnWidths = columnWidths;
    }

    public boolean isDefinedColumnWidths() {
        for (Integer columnWidth : this.columnWidths) {
            if (columnWidth >= 0) continue;
            return false;
        }
        return this.columnWidths.size() > 0;
    }

    public int getFirst() {
        return this.first;
    }

    public void setFirst(int first) {
        this.first = first;
    }

    @Deprecated(since="4.2.0", forRemoval=true)
    public void updateSortState(SortActionEvent sortEvent) {
        this.updateSortState(sortEvent.getColumn().getId());
    }

    public void updateSortState(String columnId) {
        this.sortedColumnList.updateSortState(columnId);
    }

    public void resetSortState() {
        this.sortedColumnList.clear();
    }

    @Override
    public ScrollPosition getScrollPosition() {
        return this.scrollPosition;
    }

    public void setScrollPosition(ScrollPosition scrollPosition) {
        this.scrollPosition = scrollPosition;
    }

    public LazyScrollPosition getLazyScrollPosition() {
        return this.lazyScrollPosition;
    }

    public void setLazyScrollPosition(LazyScrollPosition lazyScrollPosition) {
        this.lazyScrollPosition = lazyScrollPosition;
    }

    public ExpandedState getExpandedState() {
        if (this.expandedState == null) {
            this.expandedState = new ExpandedState(2);
        }
        return this.expandedState;
    }

    public void setExpandedState(ExpandedState expandedState) {
        this.expandedState = expandedState;
    }

    public SelectedState getSelectedState() {
        if (this.selectedState == null) {
            this.selectedState = new SelectedState();
        }
        return this.selectedState;
    }

    public void setSelectedState(SelectedState selectedState) {
        this.selectedState = selectedState;
    }

    @Deprecated(since="5.3.0", forRemoval=true)
    public boolean isToBeSorted() {
        return this.getToBeSortedLevel() > 0;
    }

    @Deprecated(since="5.3.0", forRemoval=true)
    public void setToBeSorted(boolean toBeSorted) {
        if (toBeSorted) {
            this.sortedColumnList.setToBeSortedLevel(Math.max(1, this.sortedColumnList.getToBeSortedLevel()));
        } else {
            this.sorted();
        }
    }

    public int getToBeSortedLevel() {
        return this.sortedColumnList.getToBeSortedLevel();
    }

    public void sorted() {
        this.sortedColumnList.sorted();
    }
}

