/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.util;

import org.apache.myfaces.extensions.validator.core.el.ValueBindingExpression;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.crossval.storage.CrossValidationStorage;
import org.apache.myfaces.extensions.validator.crossval.storage.CrossValidationStorageEntry;
import org.apache.myfaces.extensions.validator.crossval.storage.ProcessedInformationStorage;
import org.apache.myfaces.extensions.validator.crossval.storage.ProcessedInformationStorageEntry;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
public class CrossValidationUtils {
    public static CrossValidationStorage getOrInitCrossValidationStorage() {
        return (CrossValidationStorage)ExtValUtils.getStorage(CrossValidationStorage.class, (String)CrossValidationStorage.class.getName());
    }

    public static void resetCrossValidationStorage() {
        ExtValUtils.resetStorage(CrossValidationStorage.class, (String)CrossValidationStorage.class.getName());
    }

    public static ProcessedInformationStorage getOrInitProcessedInformationStorage() {
        return (ProcessedInformationStorage)ExtValUtils.getStorage(ProcessedInformationStorage.class, (String)ProcessedInformationStorage.class.getName());
    }

    public static void resetKeyToConvertedValueMapping() {
        ExtValUtils.resetStorage(ProcessedInformationStorage.class, (String)ProcessedInformationStorage.class.getName());
    }

    public static ProcessedInformationStorageEntry resolveValidationTargetEntry(ProcessedInformationStorage processedInformationStorage, String targetKey, CrossValidationStorageEntry crossValidationStorageEntry) {
        ProcessedInformationStorageEntry processedInformationEntry = processedInformationStorage.getEntry(targetKey);
        if (processedInformationEntry == null) {
            return null;
        }
        if (processedInformationEntry.getFurtherEntries() == null) {
            return processedInformationEntry;
        }
        PropertyDetails propertyDetails = (PropertyDetails)crossValidationStorageEntry.getMetaDataEntry().getProperty("property_details", PropertyDetails.class);
        Object targetBean = propertyDetails.getBaseObject();
        if (processedInformationEntry.getBean().equals(targetBean)) {
            return processedInformationEntry;
        }
        for (ProcessedInformationStorageEntry entry : processedInformationEntry.getFurtherEntries()) {
            if (!entry.getBean().equals(targetBean)) continue;
            return entry;
        }
        return null;
    }

    @ToDo(value=Priority.MEDIUM, description="support for map syntax")
    public static String convertValueBindingExpressionToProcessedInformationKey(ValueBindingExpression vbe) {
        return vbe.getExpressionString().replace("#{", "").replace("}", "");
    }
}

