/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval;

import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.validation.ConstraintViolation;
import javax.validation.groups.Default;
import javax.validation.metadata.ElementDescriptor;
import org.apache.myfaces.extensions.validator.beanval.BeanValidationModuleValidationInterceptorInternals;
import org.apache.myfaces.extensions.validator.beanval.util.BeanValidationUtils;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.core.property.PropertyInformation;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ConstraintSourceUtils;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
class MappedConstraintSourceBeanValidationModuleValidationInterceptorInternals {
    private Logger logger;
    private BeanValidationModuleValidationInterceptorInternals bviUtils;

    MappedConstraintSourceBeanValidationModuleValidationInterceptorInternals(Logger logger, BeanValidationModuleValidationInterceptorInternals bviUtils) {
        this.logger = logger;
        this.bviUtils = bviUtils;
    }

    void initComponentWithPropertyDetailsOfMappedConstraintSource(FacesContext facesContext, UIComponent uiComponent, PropertyDetails propertyDetails) {
        PropertyDetails constraintSourcePropertyDetails;
        Class[] foundGroups = this.bviUtils.resolveGroups(facesContext, uiComponent);
        if (foundGroups == null) {
            return;
        }
        if (foundGroups.length == 0) {
            foundGroups = new Class[]{Default.class};
        }
        if ((constraintSourcePropertyDetails = this.resolveMappedConstraintSourceFor(propertyDetails.getKey(), propertyDetails.getBaseObject().getClass(), propertyDetails.getProperty())) == null) {
            return;
        }
        ElementDescriptor elementDescriptor = BeanValidationUtils.getElementDescriptor((Class)constraintSourcePropertyDetails.getBaseObject(), constraintSourcePropertyDetails.getProperty());
        if (elementDescriptor == null) {
            return;
        }
        this.bviUtils.processElementDescriptor(facesContext, uiComponent, foundGroups, elementDescriptor);
    }

    Set<ConstraintViolation<Object>> validateMappedConstraintSource(FacesContext facesContext, UIComponent uiComponent, Object convertedObject, PropertyInformation propertyInformation, boolean cascadedValidation) {
        Class baseBeanClass = this.bviUtils.getBaseClassType(propertyInformation);
        String propertyName = this.bviUtils.getPropertyToValidate(propertyInformation);
        String originalKey = this.getKey(propertyInformation);
        PropertyDetails constraintSourcePropertyDetails = this.resolveMappedConstraintSourceFor(originalKey, baseBeanClass, propertyName);
        if (constraintSourcePropertyDetails == null) {
            return Collections.emptySet();
        }
        baseBeanClass = (Class)constraintSourcePropertyDetails.getBaseObject();
        propertyName = constraintSourcePropertyDetails.getProperty();
        Class[] groups = this.bviUtils.resolveGroups(facesContext, uiComponent);
        if (groups == null) {
            return null;
        }
        return BeanValidationUtils.validate(baseBeanClass, propertyName, convertedObject, groups, cascadedValidation);
    }

    private String getKey(PropertyInformation propertyInformation) {
        return ExtValUtils.getPropertyDetails((PropertyInformation)propertyInformation).getKey();
    }

    PropertyDetails resolveMappedConstraintSourceFor(String originalKey, Class baseBeanClass, String property) {
        return ConstraintSourceUtils.resolveMappedConstraintSourceFor((String)originalKey, (Class)baseBeanClass, (String)property);
    }
}

