/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.util;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.cdi.core.api.projectstage.ProjectStage;
import org.apache.myfaces.extensions.cdi.core.api.provider.BeanManagerProvider;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.ConversationGroup;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.ConversationScoped;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.ConversationSubGroup;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.ViewAccessScoped;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.WindowContext;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.WindowScoped;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.WindowContextConfig;
import org.apache.myfaces.extensions.cdi.core.impl.projectstage.ProjectStageProducer;
import org.apache.myfaces.extensions.cdi.core.impl.scope.conversation.spi.WindowContextManager;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.api.config.JsfModuleConfig;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.ViewAccessConversationExpirationEvaluatorRegistry;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.WindowContextIdHolderComponent;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContext;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContextManager;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.WindowHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.RequestCache;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.WeldCache;
import org.apache.myfaces.extensions.cdi.message.api.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public abstract class ConversationUtils {
    public static final String EXISTING_WINDOW_ID_SET_KEY = WindowContext.class.getName() + ":EXISTING_WINDOW_ID_LIST";
    private static final String OLD_VIEW_ID_KEY = "oldViewId";
    private static final String NEW_VIEW_ID_KEY = "newViewId";
    private static Map<Class, Class<? extends Annotation>> conversationGroupToScopeCache = new ConcurrentHashMap<Class, Class<? extends Annotation>>();
    private static final String REDIRECT_PERFORMED_KEY = WindowHandler.class.getName() + "redirect:KEY";

    private ConversationUtils() {
    }

    public static Class getConversationGroup(Bean<?> bean) {
        Class scopeType = bean.getScope();
        if (ViewAccessScoped.class.isAssignableFrom(scopeType)) {
            return bean.getBeanClass();
        }
        if (WindowScoped.class.isAssignableFrom(scopeType)) {
            return WindowScoped.class;
        }
        ConversationGroup conversationGroupAnnotation = ConversationUtils.findConversationGroupAnnotation(bean);
        if (conversationGroupAnnotation == null) {
            return bean.getBeanClass();
        }
        return conversationGroupAnnotation.value();
    }

    private static ConversationGroup findConversationGroupAnnotation(Bean<?> bean) {
        Set qualifiers = bean.getQualifiers();
        for (Annotation qualifier : qualifiers) {
            if (!ConversationGroup.class.isAssignableFrom(qualifier.annotationType())) continue;
            return (ConversationGroup)qualifier;
        }
        return null;
    }

    public static String resolveWindowContextId(WindowHandler windowHandler, boolean requestParameterSupported, boolean allowUnknownWindowIds) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        Map requestMap = externalContext.getRequestMap();
        String id = ConversationUtils.tryToFindWindowIdInRequestMap(requestMap);
        if ((id == null || id.length() == 0) && windowHandler != null) {
            id = windowHandler.restoreWindowId(facesContext.getExternalContext());
        }
        if (id == null || id.length() == 0) {
            id = ConversationUtils.tryToRestoreWindowIdFromRequestParameterMap(requestParameterSupported, requestParameterMap);
        }
        if (id != null && id.length() > 0 && (!ConversationUtils.cacheWindowId(externalContext, id, allowUnknownWindowIds) || "automatedEntryPoint".equals(id))) {
            id = null;
        }
        if (id != null && id.length() > 0) {
            return id;
        }
        if ("".equals(id)) {
            return null;
        }
        WindowContextIdHolderComponent windowContextIdHolder = ConversationUtils.getWindowContextIdHolderComponent(facesContext);
        if (windowContextIdHolder != null) {
            id = windowContextIdHolder.getWindowContextId();
            if (id != null && !ConversationUtils.cacheWindowId(externalContext, id, allowUnknownWindowIds)) {
                id = null;
            }
            if (id != null) {
                requestMap.put("windowId", windowContextIdHolder.getWindowContextId());
            }
        }
        return id;
    }

    private static String tryToRestoreWindowIdFromRequestParameterMap(boolean requestParameterSupported, Map<String, String> requestParameterMap) {
        String idViaGetRequest = null;
        if (requestParameterSupported) {
            idViaGetRequest = requestParameterMap.get("windowId");
        }
        return idViaGetRequest;
    }

    public static boolean cacheWindowId(ExternalContext externalContext, String id, boolean allowUnknownWindowIds) {
        Map sessionMap = externalContext.getSessionMap();
        HashSet existingWindowIdSet = (HashSet)sessionMap.get(EXISTING_WINDOW_ID_SET_KEY);
        if (existingWindowIdSet == null) {
            existingWindowIdSet = new HashSet();
            sessionMap.put(EXISTING_WINDOW_ID_SET_KEY, existingWindowIdSet);
        }
        if (!allowUnknownWindowIds && !existingWindowIdSet.contains(id)) {
            return false;
        }
        Map requestMap = externalContext.getRequestMap();
        requestMap.put("windowId", id);
        return true;
    }

    private static String tryToFindWindowIdInRequestMap(Map<String, Object> requestMap) {
        return (String)requestMap.get("windowId");
    }

    public static void storeCurrentViewIdAsOldViewId(FacesContext facesContext) {
        ConversationUtils.storeCurrentViewIdAsOldViewId(facesContext, ConversationUtils.getWindowContextManager());
    }

    public static void storeCurrentViewIdAsOldViewId(FacesContext facesContext, WindowContextManager windowContextManager) {
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        if (uiViewRoot != null) {
            String oldViewId = uiViewRoot.getViewId();
            windowContextManager.getCurrentWindowContext().setAttribute(OLD_VIEW_ID_KEY, (Object)oldViewId);
        }
    }

    public static void storeCurrentViewIdAsNewViewId(FacesContext facesContext) {
        ConversationUtils.storeCurrentViewIdAsNewViewId(facesContext, ConversationUtils.getWindowContextManager().getCurrentWindowContext());
    }

    public static void storeCurrentViewIdAsNewViewId(FacesContext facesContext, WindowContext windowContext) {
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        if (uiViewRoot != null) {
            String newViewId = uiViewRoot.getViewId();
            ConversationUtils.storeViewIdAsNewViewId(windowContext, newViewId);
        }
    }

    public static void storeViewIdAsNewViewId(WindowContext windowContext, String newViewId) {
        windowContext.setAttribute(NEW_VIEW_ID_KEY, (Object)newViewId);
    }

    public static String getOldViewId() {
        return (String)ConversationUtils.getWindowContextManager().getCurrentWindowContext().getAttribute(OLD_VIEW_ID_KEY, String.class);
    }

    public static String getNewViewId() {
        return (String)ConversationUtils.getWindowContextManager().getCurrentWindowContext().getAttribute(NEW_VIEW_ID_KEY, String.class);
    }

    public static WindowContextIdHolderComponent getWindowContextIdHolderComponent(FacesContext facesContext) {
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        if (uiViewRoot == null) {
            return null;
        }
        List uiComponents = uiViewRoot.getChildren();
        int size = uiComponents.size();
        for (int i = 0; i < size; ++i) {
            UIComponent uiComponent = (UIComponent)uiComponents.get(i);
            if (!(uiComponent instanceof WindowContextIdHolderComponent)) continue;
            return (WindowContextIdHolderComponent)uiComponent;
        }
        return null;
    }

    public static void addWindowContextIdHolderComponent() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        if (uiViewRoot == null) {
            return;
        }
        List uiComponents = uiViewRoot.getChildren();
        int size = uiComponents.size();
        for (int i = 0; i < size; ++i) {
            UIComponent uiComponent = (UIComponent)uiComponents.get(i);
            if (!(uiComponent instanceof WindowContextIdHolderComponent)) continue;
            return;
        }
        uiViewRoot.getChildren().add(ConversationUtils.createComponentWithCurrentWindowContextId());
    }

    private static WindowContextIdHolderComponent createComponentWithCurrentWindowContextId() {
        WindowContextManager conversationManager = (WindowContextManager)CodiUtils.getContextualReferenceByClass(WindowContextManager.class, (Annotation[])new Annotation[0]);
        return new WindowContextIdHolderComponent(conversationManager.getCurrentWindowContext().getId());
    }

    public static void sendRedirect(ExternalContext externalContext, String url, WindowHandler windowHandler) throws IOException {
        if (ConversationUtils.isFacesContextManuallyWrapped(externalContext) && ConversationUtils.isRedirectInterceptedAlready(externalContext) && !FacesContext.getCurrentInstance().getResponseComplete()) {
            externalContext.redirect(url);
            return;
        }
        if (ConversationUtils.isRedirectInterceptedAlready(externalContext) || FacesContext.getCurrentInstance().getResponseComplete()) {
            return;
        }
        ConversationUtils.redirectIntercepted(externalContext);
        ConversationUtils.storeCurrentViewIdAsOldViewId(FacesContext.getCurrentInstance());
        RequestCache.resetCache();
        ConversationUtils.saveFacesMessages(externalContext);
        if (windowHandler != null) {
            windowHandler.sendRedirect(externalContext, url, false);
        } else {
            externalContext.redirect(url);
        }
    }

    private static boolean isFacesContextManuallyWrapped(ExternalContext externalContext) {
        return Boolean.TRUE.equals(externalContext.getRequestMap().get("javax.faces.context.FacesContext:manuallyWrappedByCodi"));
    }

    private static void saveFacesMessages(ExternalContext externalContext) {
        JsfModuleConfig jsfModuleConfig = (JsfModuleConfig)CodiUtils.getContextualReferenceByClass(JsfModuleConfig.class, (Annotation[])new Annotation[0]);
        if (jsfModuleConfig != null && jsfModuleConfig.isAlwaysKeepMessages()) {
            Map requestMap = externalContext.getRequestMap();
            CopyOnWriteArrayList facesMessageEntryList = (CopyOnWriteArrayList)requestMap.get(Message.class.getName());
            if (facesMessageEntryList == null) {
                facesMessageEntryList = new CopyOnWriteArrayList();
            }
            ConversationUtils.getWindowContextManager().getCurrentWindowContext().setAttribute(Message.class.getName(), facesMessageEntryList, true);
        }
    }

    private static boolean isRedirectInterceptedAlready(ExternalContext externalContext) {
        return externalContext.getRequestMap().containsKey(REDIRECT_PERFORMED_KEY);
    }

    private static void redirectIntercepted(ExternalContext externalContext) {
        externalContext.getRequestMap().put(REDIRECT_PERFORMED_KEY, Boolean.TRUE);
    }

    public static WindowHandler getWindowHandler() {
        return (WindowHandler)CodiUtils.getContextualReferenceByClass(WindowHandler.class, (Annotation[])new Annotation[0]);
    }

    public static WindowContextManager getWindowContextManager() {
        return RequestCache.getWindowContextManager();
    }

    public static boolean removeExistingWindowId(ExternalContext externalContext, String windowContextId) {
        return ConversationUtils.getEditableWindowIdSet(externalContext).remove(windowContextId);
    }

    public static Set<String> getExistingWindowIdSet(ExternalContext externalContext) {
        Set<String> existingWindowIdSet = ConversationUtils.getEditableWindowIdSet(externalContext);
        return Collections.unmodifiableSet(existingWindowIdSet);
    }

    public static void storeCreatedWindowContextId(ExternalContext externalContext, String windowContextId) {
        ConversationUtils.getEditableWindowIdSet(externalContext).add(windowContextId);
    }

    private static Set<String> getEditableWindowIdSet(ExternalContext externalContext) {
        Map sessionMap = externalContext.getSessionMap();
        HashSet existingWindowIdSet = (HashSet)sessionMap.get(EXISTING_WINDOW_ID_SET_KEY);
        if (existingWindowIdSet == null) {
            existingWindowIdSet = new HashSet();
            sessionMap.put(EXISTING_WINDOW_ID_SET_KEY, existingWindowIdSet);
        }
        return existingWindowIdSet;
    }

    public static boolean cleanupInactiveWindowContexts(EditableWindowContextManager windowContextManager) {
        Collection<EditableWindowContext> windowContexts = windowContextManager.getWindowContexts();
        int count = windowContexts.size();
        for (EditableWindowContext windowContext : windowContexts) {
            if (!ConversationUtils.isEligibleForCleanup(windowContext)) continue;
            windowContextManager.closeWindowContext(windowContext);
        }
        return windowContexts.size() < count;
    }

    public static Class<? extends Annotation> convertToScope(BeanManager beanManager, Class conversationGroupKey, Annotation ... qualifiers) {
        Class scopeType = conversationGroupToScopeCache.get(conversationGroupKey);
        if (scopeType != null) {
            return scopeType;
        }
        if (WindowScoped.class.isAssignableFrom(conversationGroupKey)) {
            scopeType = WindowScoped.class;
        } else {
            Set beans = beanManager.getBeans((Type)conversationGroupKey, qualifiers);
            if (beans.size() == 1) {
                scopeType = ((Bean)beans.iterator().next()).getScope();
            } else {
                Bean<?> bean;
                if (!beanManager.getClass().getName().startsWith("org.apache.webbeans.") && (bean = WeldCache.getBean()) != null) {
                    scopeType = bean.getScope();
                }
                if (scopeType == null) {
                    scopeType = ConversationScoped.class;
                }
            }
        }
        conversationGroupToScopeCache.put(conversationGroupKey, scopeType);
        return scopeType;
    }

    private static boolean isEligibleForCleanup(EditableWindowContext editableWindowContext) {
        return !editableWindowContext.isActive() || editableWindowContext.getConversations().isEmpty();
    }

    public static boolean isWindowActive(EditableWindowContextManager windowContextManager, String windowId) {
        for (EditableWindowContext editableWindowContext : windowContextManager.getWindowContexts()) {
            if (!windowId.equals(editableWindowContext.getId()) || !editableWindowContext.isActive()) continue;
            return true;
        }
        return false;
    }

    public static void postRenderCleanup(FacesContext facesContext) {
        block4: {
            try {
                BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
                EditableWindowContextManager windowContextManager = (EditableWindowContextManager)CodiUtils.getContextualReferenceByClass((BeanManager)beanManager, EditableWindowContextManager.class, (Annotation[])new Annotation[0]);
                WindowContextConfig windowContextConfig = (WindowContextConfig)CodiUtils.getContextualReferenceByClass((BeanManager)beanManager, WindowContextConfig.class, (Annotation[])new Annotation[0]);
                ViewAccessConversationExpirationEvaluatorRegistry registry = (ViewAccessConversationExpirationEvaluatorRegistry)CodiUtils.getContextualReferenceByClass((BeanManager)beanManager, ViewAccessConversationExpirationEvaluatorRegistry.class, (Annotation[])new Annotation[0]);
                UIViewRoot uiViewRoot = facesContext.getViewRoot();
                if (uiViewRoot == null) {
                    return;
                }
                registry.broadcastRenderedViewId(uiViewRoot.getViewId());
                ConversationUtils.storeCurrentViewIdAsOldViewId(facesContext);
                if (windowContextConfig.isCloseEmptyWindowContextsEnabled()) {
                    ConversationUtils.cleanupInactiveWindowContexts(windowContextManager);
                }
            }
            catch (ContextNotActiveException e) {
                if (ProjectStageProducer.getInstance().getProjectStage() != ProjectStage.Development) break block4;
                e.printStackTrace();
            }
        }
        RequestCache.resetCache();
    }

    public static void tryToRestoreTheWindowIdEagerly(FacesContext facesContext, EditableWindowContextManager windowContextManager, WindowHandler windowHandler, WindowContextConfig windowContextConfig) {
        boolean active;
        String windowId;
        if (RequestCache.getCurrentWindowContext() == null && windowContextConfig.isEagerWindowContextDetectionEnabled() && (windowId = ConversationUtils.resolveWindowContextId(windowHandler, windowContextConfig.isUrlParameterSupported(), windowContextConfig.isUnknownWindowIdsAllowed())) != null && (active = windowContextManager.isWindowContextActive(windowId))) {
            RequestCache.setCurrentWindowContext(windowContextManager.getWindowContext(windowId));
            facesContext.getExternalContext().getRequestMap().put("windowId", windowId);
        }
    }

    public static Class<?> convertToSubGroup(Class<?> conversationGroupKey) {
        ConversationSubGroup conversationSubGroup = conversationGroupKey.getAnnotation(ConversationSubGroup.class);
        Class<?> result = conversationSubGroup.of();
        if (!ConversationSubGroup.class.equals((Object)result)) {
            return result;
        }
        result = conversationGroupKey.getSuperclass();
        if ((result == null || Object.class.getName().equals(result.getName())) && conversationGroupKey.getInterfaces().length == 1) {
            result = conversationGroupKey.getInterfaces()[0];
        }
        if (result != null && Object.class.getName().equals(result.getName())) {
            return null;
        }
        return result;
    }
}

