/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.convert;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.convert._MessageUtils;
import java.math.BigInteger;

public class BigIntegerConverter
implements Converter {
    public static final String CONVERTER_ID = "jakarta.faces.BigInteger";
    public static final String STRING_ID = "jakarta.faces.converter.STRING";
    public static final String BIGINTEGER_ID = "jakarta.faces.converter.BigIntegerConverter.BIGINTEGER";

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value != null && (value = value.trim()).length() > 0) {
            try {
                return new BigInteger(value.trim());
            }
            catch (NumberFormatException e) {
                throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, BIGINTEGER_ID, new Object[]{value, "2345", _MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
            }
        }
        return null;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return ((BigInteger)value).toString();
        }
        catch (Exception e) {
            throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, STRING_ID, new Object[]{value, _MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
        }
    }
}

