/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.bean;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.NoneScoped;
import javax.faces.bean.RequestScoped;
import javax.faces.view.ViewScoped;
import org.apache.myfaces.bean.ManagedBeanWrapper;
import org.apache.myfaces.bean.literal.ApplicationScopedLiteral;
import org.apache.myfaces.bean.literal.DependentScopeLiteral;
import org.apache.myfaces.bean.literal.RequestScopedLiteral;
import org.apache.myfaces.bean.literal.SessionScopedLiteral;
import org.apache.myfaces.cdi.view.ViewScopedLiteral;

public class ManagedBeanExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(ManagedBeanExtension.class.getName());
    private Map<Class<? extends Annotation>, Class<? extends Annotation>> mappings = new HashMap<Class<? extends Annotation>, Class<? extends Annotation>>();
    private Map<Class<? extends Annotation>, AnnotationLiteral> literals = new HashMap<Class<? extends Annotation>, AnnotationLiteral>();

    public ManagedBeanExtension() {
        this.mappings.put(javax.faces.bean.ApplicationScoped.class, ApplicationScoped.class);
        this.mappings.put(javax.faces.bean.SessionScoped.class, SessionScoped.class);
        this.mappings.put(RequestScoped.class, javax.enterprise.context.RequestScoped.class);
        this.mappings.put(NoneScoped.class, Dependent.class);
        this.mappings.put(javax.faces.bean.ViewScoped.class, ViewScoped.class);
        this.literals.put(ApplicationScoped.class, new ApplicationScopedLiteral());
        this.literals.put(SessionScoped.class, new SessionScopedLiteral());
        this.literals.put(javax.enterprise.context.RequestScoped.class, new RequestScopedLiteral());
        this.literals.put(Dependent.class, new DependentScopeLiteral());
        this.literals.put(ViewScoped.class, new ViewScopedLiteral());
    }

    protected void convertJsf2Scopes(@Observes ProcessAnnotatedType pat) {
        Class<? extends Annotation> oldScope;
        Class clazz = pat.getAnnotatedType().getJavaClass();
        ManagedBean managedBean = clazz.getAnnotation(ManagedBean.class);
        if (managedBean != null && (oldScope = this.resolveScope(pat)) != null) {
            Class<? extends Annotation> newScope = this.mappings.get(oldScope);
            LOGGER.info("@ManagedBean (" + clazz.getName() + ") was converted to a CDI bean with scope: " + oldScope.getName());
            pat.setAnnotatedType((AnnotatedType)new ManagedBeanWrapper(pat.getAnnotatedType(), managedBean, newScope, oldScope, this.literals.get(newScope)));
        }
    }

    private Class<? extends Annotation> resolveScope(ProcessAnnotatedType pat) {
        for (Class<? extends Annotation> oldScope : this.mappings.keySet()) {
            if (!pat.getAnnotatedType().getJavaClass().isAnnotationPresent(oldScope)) continue;
            return oldScope;
        }
        return null;
    }
}

