/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle.clientwindow;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.lifecycle.clientwindow.UrlClientWindow;
import org.apache.myfaces.util.lang.StringUtils;
import org.apache.myfaces.util.token.TokenGenerator;

public class UrlRedirectClientWindow
extends UrlClientWindow {
    public UrlRedirectClientWindow(TokenGenerator tokenGenerator) {
        super(tokenGenerator);
    }

    @Override
    public void decode(FacesContext context) {
        String requestWindowId = context.getExternalContext().getRequestParameterMap().get("javax.faces.ClientWindow");
        if (requestWindowId == null) {
            requestWindowId = context.getExternalContext().getRequestParameterMap().get("jfwid");
        }
        if (requestWindowId == null) {
            requestWindowId = this.tokenGenerator.getNextToken();
            this.setId(requestWindowId);
            try {
                String redirectUrl = this.constructInitialRedirectUrl(context.getExternalContext());
                context.getExternalContext().redirect(redirectUrl);
            }
            catch (IOException e) {
                throw new FacesException("Could not send initial redirect!", e);
            }
            context.responseComplete();
        }
        this.setId(requestWindowId);
    }

    protected String constructInitialRedirectUrl(ExternalContext externalContext) {
        String url = externalContext.getRequestContextPath() + externalContext.getRequestServletPath();
        if (externalContext.getRequestPathInfo() != null) {
            url = url + externalContext.getRequestPathInfo();
        }
        url = UrlRedirectClientWindow.addRequestParameters(externalContext, url);
        url = externalContext.encodeRedirectURL(url, null);
        return url;
    }

    public static String addRequestParameters(ExternalContext externalContext, String url) {
        if (externalContext.getRequestParameterValuesMap().isEmpty()) {
            return url;
        }
        StringBuilder finalUrl = new StringBuilder(url);
        boolean existingParameters = url.contains("?");
        for (Map.Entry<String, String[]> entry : externalContext.getRequestParameterValuesMap().entrySet()) {
            for (String value : entry.getValue()) {
                if (url.contains(entry.getKey() + "=" + value) || url.contains(entry.getKey() + "=" + UrlRedirectClientWindow.encodeURLParameterValue(value, externalContext)) || StringUtils.isEmpty(entry.getKey()) && StringUtils.isEmpty(value)) continue;
                if (!existingParameters) {
                    finalUrl.append("?");
                    existingParameters = true;
                } else {
                    finalUrl.append("&");
                }
                finalUrl.append(UrlRedirectClientWindow.encodeURLParameterValue(entry.getKey(), externalContext));
                finalUrl.append("=");
                finalUrl.append(UrlRedirectClientWindow.encodeURLParameterValue(value, externalContext));
            }
        }
        return finalUrl.toString();
    }

    public static String encodeURLParameterValue(String value, ExternalContext externalContext) {
        try {
            return URLEncoder.encode(value, externalContext.getResponseCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Encoding type=" + externalContext.getResponseCharacterEncoding() + " not supported", e);
        }
    }
}

