/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher.internal.sources;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.codehaus.plexus.components.secdispatcher.MasterSource;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.SecDispatcherException;

public abstract class MasterSourceSupport
implements MasterSource {
    private final Predicate<String> matcher;
    private final Function<String, String> transformer;

    public MasterSourceSupport(Predicate<String> matcher, Function<String, String> transformer) {
        this.matcher = Objects.requireNonNull(matcher);
        this.transformer = Objects.requireNonNull(transformer);
    }

    @Override
    public String handle(String masterSource) throws SecDispatcherException {
        if (this.matcher.test(masterSource)) {
            return this.doHandle(this.transformer.apply(masterSource));
        }
        return null;
    }

    protected abstract String doHandle(String var1) throws SecDispatcherException;

    @Override
    public SecDispatcher.ValidationResponse validateConfiguration(String masterSource) {
        if (this.matcher.test(masterSource)) {
            return this.doValidateConfiguration(this.transformer.apply(masterSource));
        }
        return null;
    }

    protected abstract SecDispatcher.ValidationResponse doValidateConfiguration(String var1);
}

