/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.testng.TestNGCommandLineArgs;
import org.testng.internal.AnnotationTypeEnum;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGAntTask
extends Task {
    protected CommandlineJava m_javaCommand;
    protected List<FileSet> m_xmlFilesets = new ArrayList<FileSet>();
    protected List<FileSet> m_classFilesets = new ArrayList<FileSet>();
    protected Path m_sourceDirPath;
    protected File m_outputDir;
    protected File m_testjar;
    protected File m_workingDir;
    private Integer m_timeout;
    protected Boolean m_isJUnit;
    private List<String> m_listeners = new ArrayList<String>();
    protected Environment m_environment = new Environment();
    protected String m_mainClass = (class$org$testng$TestNG == null ? (class$org$testng$TestNG = TestNGAntTask.class$("org.testng.TestNG")) : class$org$testng$TestNG).getName();
    protected String m_target;
    protected boolean m_dump;
    private boolean m_dumpEnv;
    private boolean m_dumpSys;
    protected boolean m_assertEnabled = true;
    protected boolean m_haltOnFailure;
    protected String m_onHaltTarget;
    protected String m_failurePropertyName;
    protected boolean m_haltOnSkipped;
    protected String m_skippedPropertyName;
    protected boolean m_haltOnFSP;
    protected String m_fspPropertyName;
    protected String m_includedGroups;
    protected String m_excludedGroups;
    protected String m_parallelMode;
    protected String m_threadCount;
    public String m_useDefaultListeners;
    private String m_suiteName = "Ant suite";
    private String m_testName = "Ant test";
    private Integer m_verbose = null;
    static /* synthetic */ Class class$org$testng$TestNG;

    public void setParallel(String parallel) {
        this.m_parallelMode = parallel;
    }

    public void setThreadCount(String threadCount) {
        this.m_threadCount = threadCount;
    }

    public void setUseDefaultListeners(String f) {
        this.m_useDefaultListeners = f;
    }

    public void setHaltonfailure(boolean value) {
        this.m_haltOnFailure = value;
    }

    public void setOnHaltTarget(String targetName) {
        this.m_onHaltTarget = targetName;
    }

    public void setFailureProperty(String propertyName) {
        this.m_failurePropertyName = propertyName;
    }

    public void setHaltonskipped(boolean value) {
        this.m_haltOnSkipped = value;
    }

    public void setSkippedProperty(String propertyName) {
        this.m_skippedPropertyName = propertyName;
    }

    public void setHaltonFSP(boolean value) {
        this.m_haltOnFSP = value;
    }

    public void setFSPProperty(String propertyName) {
        this.m_fspPropertyName = propertyName;
    }

    public void setDumpCommand(boolean verbose) {
        this.m_dump = verbose;
    }

    public void setDumpEnv(boolean verbose) {
        this.m_dumpEnv = verbose;
    }

    public void setDumpSys(boolean verbose) {
        this.m_dumpSys = verbose;
    }

    public void setEnableAssert(boolean flag) {
        this.m_assertEnabled = flag;
    }

    public void setWorkingDir(File workingDir) {
        this.m_workingDir = workingDir;
    }

    public void setJvm(String jvm) {
        this.getJavaCommand().setVm(jvm);
    }

    public void setTimeout(Integer value) {
        this.m_timeout = value;
    }

    public Commandline.Argument createJvmarg() {
        return this.getJavaCommand().createVmArgument();
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.getJavaCommand().addSysproperty(sysp);
    }

    public void addEnv(Environment.Variable var) {
        this.m_environment.addVariable(var);
    }

    public Path createClasspath() {
        return this.getJavaCommand().createClasspath(this.getProject()).createPath();
    }

    public Path createBootclasspath() {
        return this.getJavaCommand().createBootclasspath(this.getProject()).createPath();
    }

    public void setClasspath(Path s) {
        this.createClasspath().append(s);
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void addXmlfileset(FileSet fs) {
        this.m_xmlFilesets.add(fs);
    }

    public void setXmlfilesetRef(Reference ref) {
        this.m_xmlFilesets.add(this.createFileSet(ref));
    }

    public void addClassfileset(FileSet fs) {
        this.m_classFilesets.add(this.appendClassSelector(fs));
    }

    public void setClassfilesetRef(Reference ref) {
        this.m_classFilesets.add(this.appendClassSelector(this.createFileSet(ref)));
    }

    public void setSourcedir(Path srcDir) {
        if (this.m_sourceDirPath == null) {
            this.m_sourceDirPath = srcDir;
        } else {
            this.m_sourceDirPath.append(srcDir);
        }
    }

    public Path createSourceDir() {
        if (this.m_sourceDirPath == null) {
            this.m_sourceDirPath = new Path(this.getProject());
        }
        return this.m_sourceDirPath.createPath();
    }

    public void setSourceDirRef(Reference r) {
        this.createSourceDir().setRefid(r);
    }

    public void setSuiteRunnerClass(String s) {
        this.m_mainClass = s;
    }

    public void setSuiteName(String s) {
        this.m_suiteName = s;
    }

    public void setTestName(String s) {
        this.m_testName = s;
    }

    public void setJUnit(boolean value) {
        this.m_isJUnit = new Boolean(value);
    }

    public void setAnnotations(String defaultAnnotations) {
        this.m_target = defaultAnnotations;
    }

    @Deprecated
    public void setTarget(String target) {
        this.m_target = target;
        this.log("The usage of -target option is deprecated. Please use -annotations instead", 1);
    }

    public void setOutputDir(File dir2) {
        this.m_outputDir = dir2;
    }

    public void setTestJar(File s) {
        this.m_testjar = s;
    }

    public void setGroups(String groups) {
        this.m_includedGroups = groups;
    }

    public void setExcludedGroups(String groups) {
        this.m_excludedGroups = groups;
    }

    public void setVerbose(Integer verbose) {
        this.m_verbose = verbose;
    }

    public void setReporter(String listener) {
        this.m_listeners.add(listener);
    }

    public void setListener(String listener) {
        this.m_listeners.add(listener);
    }

    public void setListeners(String listeners) {
        StringTokenizer st = new StringTokenizer(listeners, " ,");
        while (st.hasMoreTokens()) {
            this.m_listeners.add(st.nextToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.validateOptions();
        CommandlineJava cmd = this.getJavaCommand();
        cmd.setClassname(this.m_mainClass);
        ArrayList<String> argv = new ArrayList<String>();
        if (null != this.m_isJUnit && this.m_isJUnit.booleanValue()) {
            argv.add("-junit");
        }
        if (null != this.m_verbose) {
            argv.add("-log");
            argv.add(this.m_verbose.toString());
        }
        if (this.m_assertEnabled) {
            cmd.createVmArgument().setValue("-ea");
        }
        if (this.m_useDefaultListeners != null) {
            String useDefaultListeners = "false";
            if ("yes".equalsIgnoreCase(this.m_useDefaultListeners) || "true".equalsIgnoreCase(this.m_useDefaultListeners)) {
                useDefaultListeners = "true";
            }
            argv.add("-usedefaultlisteners");
            argv.add(useDefaultListeners);
        }
        if (null != this.m_outputDir) {
            if (!this.m_outputDir.exists()) {
                this.m_outputDir.mkdirs();
            }
            if (this.m_outputDir.isDirectory()) {
                argv.add("-d");
                argv.add(this.m_outputDir.getAbsolutePath());
            } else {
                throw new BuildException(new StringBuffer().append("Output directory is not a directory: ").append(this.m_outputDir).toString());
            }
        }
        if (null != this.m_target) {
            argv.add("-annotations");
            argv.add(this.m_target);
        }
        if (null != this.m_testjar && this.m_testjar.isFile()) {
            argv.add("-testjar");
            argv.add(this.m_testjar.getAbsolutePath());
        }
        if (null != this.m_sourceDirPath) {
            String srcPath = this.createPathString(this.m_sourceDirPath, ";");
            argv.add("-sourcedir");
            argv.add(srcPath);
        }
        if (null != this.m_includedGroups && !"".equals(this.m_includedGroups)) {
            argv.add("-groups");
            argv.add(this.m_includedGroups);
        }
        if (null != this.m_excludedGroups && !"".equals(this.m_excludedGroups)) {
            argv.add("-excludegroups");
            argv.add(this.m_excludedGroups);
        }
        if (this.m_classFilesets.size() > 0) {
            argv.add("-testclass");
            for (String file : this.fileset(this.m_classFilesets)) {
                argv.add(file);
            }
        }
        if (this.m_listeners != null) {
            for (String listener : this.m_listeners) {
                argv.add("-listener");
                argv.add(listener);
            }
        }
        if (this.m_parallelMode != null) {
            argv.add("-parallel");
            argv.add(this.m_parallelMode);
        }
        if (this.m_threadCount != null) {
            argv.add("-threadcount");
            argv.add(this.m_threadCount);
        }
        if (!"".equals(this.m_suiteName)) {
            argv.add("-suitename");
            argv.add(this.m_suiteName);
        }
        if (!"".equals(this.m_testName)) {
            argv.add("-testname");
            argv.add(this.m_testName);
        }
        if (this.m_xmlFilesets.size() > 0) {
            for (String file : this.fileset(this.m_xmlFilesets)) {
                argv.add(file);
            }
        }
        String fileName = "";
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        try {
            File f = File.createTempFile("testng", "");
            fileName = f.getAbsolutePath();
            if (!this.m_dump) {
                f.deleteOnExit();
            }
            fw = new FileWriter(f);
            bw = new BufferedWriter(fw);
            for (String arg : argv) {
                bw.write(TestNGAntTask.doubleQuote(arg));
                bw.write(" ");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.printDebugInfo(fileName);
        this.createClasspath().setLocation(this.findJar());
        cmd.createArgument().setValue(new StringBuffer().append("@").append(fileName).toString());
        ExecuteWatchdog watchdog = this.createWatchdog();
        boolean wasKilled = false;
        int exitValue = this.executeAsForked(cmd, watchdog);
        if (null != watchdog) {
            wasKilled = watchdog.killedProcess();
        }
        this.actOnResult(exitValue, wasKilled);
    }

    private void printDebugInfo(String fileName) {
        String[] vars;
        if (this.m_dumpSys) {
            System.out.println("* SYSTEM PROPERTIES *");
            Properties props = System.getProperties();
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                System.out.println(new StringBuffer().append(key).append(": ").append(props.getProperty(key)).toString());
            }
            System.out.println("");
        }
        if (this.m_dumpEnv && null != (vars = this.m_environment.getVariables()) && vars.length > 0) {
            System.out.println("* ENVIRONMENT *");
            for (String v : vars) {
                System.out.println(v);
            }
            System.out.println("");
        }
        if (this.m_dump) {
            this.dumpCommand(fileName);
        }
    }

    private void ppp(String string) {
        System.out.println(new StringBuffer().append("[TestNGAntTask] ").append(string).toString());
    }

    protected void actOnResult(int exitValue, boolean wasKilled) {
        boolean failed;
        if (exitValue == -1) {
            this.executeHaltTarget(exitValue);
            throw new BuildException("an error occured when running TestNG tests");
        }
        if ((exitValue & 8) == 8) {
            if (this.m_haltOnFailure) {
                this.executeHaltTarget(exitValue);
                throw new BuildException("No tests were run");
            }
            if (null != this.m_failurePropertyName) {
                this.getProject().setNewProperty(this.m_failurePropertyName, "true");
            }
            this.log("TestNG haven't found any tests to be run", 4);
        }
        boolean bl = failed = (exitValue & 1) == 1 || wasKilled;
        if (failed) {
            String msg;
            String string = msg = wasKilled ? "The tests timed out and were killed." : "The tests failed.";
            if (this.m_haltOnFailure) {
                this.executeHaltTarget(exitValue);
                throw new BuildException(msg);
            }
            if (null != this.m_failurePropertyName) {
                this.getProject().setNewProperty(this.m_failurePropertyName, "true");
            }
            this.log(msg, 4);
        }
        if ((exitValue & 2) == 2) {
            if (this.m_haltOnSkipped) {
                this.executeHaltTarget(exitValue);
                throw new BuildException("There are TestNG SKIPPED tests");
            }
            if (null != this.m_skippedPropertyName) {
                this.getProject().setNewProperty(this.m_skippedPropertyName, "true");
            }
            this.log("There are TestNG SKIPPED tests", 4);
        }
        if ((exitValue & 4) == 4) {
            if (this.m_haltOnFSP) {
                this.executeHaltTarget(exitValue);
                throw new BuildException("There are TestNG FAILED WITHIN SUCCESS PERCENTAGE tests");
            }
            if (null != this.m_fspPropertyName) {
                this.getProject().setNewProperty(this.m_fspPropertyName, "true");
            }
            this.log("There are TestNG FAILED WITHIN SUCCESS PERCENTAGE tests", 4);
        }
    }

    private void executeHaltTarget(int exitValue) {
        if (this.m_onHaltTarget != null) {
            if (this.m_outputDir != null) {
                this.getProject().setProperty("testng.outputdir", this.m_outputDir.getAbsolutePath());
            }
            this.getProject().setProperty("testng.returncode", String.valueOf(exitValue));
            Target t = (Target)this.getProject().getTargets().get(this.m_onHaltTarget);
            if (t != null) {
                t.execute();
            }
        }
    }

    protected int executeAsForked(CommandlineJava cmd, ExecuteWatchdog watchdog) {
        int retVal;
        String[] environment;
        Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), watchdog);
        execute.setCommandline(cmd.getCommandline());
        execute.setAntRun(this.getProject());
        if (this.m_workingDir != null) {
            if (this.m_workingDir.exists() && this.m_workingDir.isDirectory()) {
                execute.setWorkingDirectory(this.m_workingDir);
            } else {
                this.log(new StringBuffer().append("Ignoring invalid working directory : ").append(this.m_workingDir).toString(), 1);
            }
        }
        if (null != (environment = this.m_environment.getVariables())) {
            for (String envEntry : environment) {
                this.log(new StringBuffer().append("Setting environment variable: ").append(envEntry).toString(), 3);
            }
        }
        execute.setEnvironment(environment);
        this.log(cmd.describeCommand(), 3);
        try {
            retVal = execute.execute();
        }
        catch (IOException e) {
            throw new BuildException("Process fork failed.", (Throwable)e, this.getLocation());
        }
        return retVal;
    }

    protected CommandlineJava getJavaCommand() {
        if (null == this.m_javaCommand) {
            this.m_javaCommand = new CommandlineJava();
        }
        return this.m_javaCommand;
    }

    protected ExecuteWatchdog createWatchdog() {
        if (this.m_timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.m_timeout.longValue());
    }

    protected void validateOptions() throws BuildException {
        if (!(this.m_xmlFilesets.size() != 0 || this.m_classFilesets.size() != 0 || null != this.m_testjar && this.m_testjar.isFile())) {
            throw new BuildException("No suite or classes or jar is specified.");
        }
        if (null != this.m_includedGroups && this.m_classFilesets.size() == 0) {
            throw new BuildException("No classfileset specified while using groups");
        }
        if (this.m_target != null) {
            try {
                this.m_target = AnnotationTypeEnum.valueOf(this.m_target).getName();
            }
            catch (RuntimeException pEx) {
                throw new BuildException(new StringBuffer().append("Illegal default annotations: ").append(this.m_target).toString(), (Throwable)pEx);
            }
        }
        if (null == this.m_sourceDirPath) {
            throw new BuildException("No sourceDir is specified.");
        }
        if (this.m_onHaltTarget != null && !this.getProject().getTargets().containsKey(this.m_onHaltTarget)) {
            throw new BuildException(new StringBuffer().append("Target ").append(this.m_onHaltTarget).append(" not found in this project").toString());
        }
    }

    private FileSet createFileSet(Reference ref) {
        FileSet fs = new FileSet();
        fs.setRefid(ref);
        fs.setProject(this.getProject());
        return fs;
    }

    private FileSet appendClassSelector(FileSet fs) {
        FilenameSelector selector = new FilenameSelector();
        selector.setName("**/*.class");
        selector.setProject(this.getProject());
        fs.appendSelector((FileSelector)selector);
        return fs;
    }

    private File findJar() {
        Class<?> thisClass = ((Object)((Object)this)).getClass();
        String resource = new StringBuffer().append(thisClass.getName().replace('.', '/')).append(".class").toString();
        URL url = thisClass.getClassLoader().getResource(resource);
        if (null != url) {
            String u = url.toString();
            if (u.startsWith("jar:file:")) {
                int pling = u.indexOf("!");
                String jarName = u.substring(4, pling);
                return new File(this.fromURI(jarName));
            }
            if (u.startsWith("file:")) {
                int tail = u.indexOf(resource);
                String dirName = u.substring(0, tail);
                return new File(this.fromURI(dirName));
            }
        }
        return null;
    }

    private String fromURI(String uri) {
        String file;
        int queryPos;
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException murle) {
            // empty catch block
        }
        if (null == url || !"file".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Can only handle valid file: URIs");
        }
        StringBuffer buf = new StringBuffer(url.getHost());
        if (buf.length() > 0) {
            buf.insert(0, File.separatorChar).insert(0, File.separatorChar);
        }
        buf.append((queryPos = (file = url.getFile()).indexOf(63)) < 0 ? file : file.substring(0, queryPos));
        uri = buf.toString().replace('/', File.separatorChar);
        if (File.pathSeparatorChar == ';' && uri.startsWith("\\") && uri.length() > 2 && Character.isLetter(uri.charAt(1)) && uri.lastIndexOf(58) > -1) {
            uri = uri.substring(1);
        }
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(uri);
        char c = iter.first();
        while (c != '\uffff') {
            if (c == '%') {
                char c1 = iter.next();
                if (c1 != '\uffff') {
                    int i1 = Character.digit(c1, 16);
                    char c2 = iter.next();
                    if (c2 != '\uffff') {
                        int i2 = Character.digit(c2, 16);
                        sb.append((char)((i1 << 4) + i2));
                    }
                }
            } else {
                sb.append(c);
            }
            c = iter.next();
        }
        return sb.toString();
    }

    private List<String> fileset(List<FileSet> filesets) throws BuildException {
        ArrayList<String> files = new ArrayList<String>();
        for (FileSet fileset : filesets) {
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            for (String file : ds.getIncludedFiles()) {
                files.add(new StringBuffer().append("\"").append(ds.getBasedir()).append(File.separator).append(file).append("\"").toString());
            }
        }
        return files;
    }

    private static String doubleQuote(String pCommandLineArg) {
        if (!(pCommandLineArg.indexOf(" ") == -1 || pCommandLineArg.startsWith("\"") && pCommandLineArg.endsWith("\""))) {
            return new StringBuffer().append("\"").append(pCommandLineArg).append("\"").toString();
        }
        return pCommandLineArg;
    }

    private String createPathString(Path path, String sep) {
        if (path == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < path.list().length; ++i) {
            File file = this.getProject().resolveFile(path.list()[i]);
            if (!file.exists()) {
                this.log(new StringBuffer().append("Classpath entry not found: ").append(file).toString(), 1);
            }
            buf.append(file.getAbsolutePath()).append(sep);
        }
        if (path.list().length > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    private void dumpCommand(String fileName) {
        this.ppp(new StringBuffer().append("TESTNG PASSED @").append(fileName).append(" WHICH CONTAINS:").toString());
        List<String> lines = TestNGCommandLineArgs.readFile(fileName);
        for (String line : lines) {
            this.ppp(line);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

