/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.provider.AbridgedMolodensky;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.transform.AbridgedMolodenskyTransform2D;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.MolodenskyFormula;
import org.apache.sis.referencing.operation.transform.MolodenskyTransform2D;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class MolodenskyTransform
extends MolodenskyFormula {
    private static final long serialVersionUID = 7206439437113286122L;
    private static ParameterDescriptorGroup DESCRIPTOR;
    private final MolodenskyTransform inverse;

    protected MolodenskyTransform(Ellipsoid ellipsoid, boolean bl, Ellipsoid ellipsoid2, boolean bl2, double d, double d2, double d3, boolean bl3) {
        super(ellipsoid, bl, ellipsoid2, bl2, d, d2, d3, null, bl3, bl3 ? AbridgedMolodensky.PARAMETERS : Molodensky.PARAMETERS);
        this.inverse = !bl && !bl2 ? (bl3 && d == 0.0 && d2 == 0.0 && d3 == 0.0 ? new AbridgedMolodenskyTransform2D(this, ellipsoid, ellipsoid2) : new MolodenskyTransform2D(this, ellipsoid, ellipsoid2)) : new MolodenskyTransform(this, ellipsoid, ellipsoid2);
    }

    MolodenskyTransform(MolodenskyTransform molodenskyTransform, Ellipsoid ellipsoid, Ellipsoid ellipsoid2) {
        super(molodenskyTransform, ellipsoid, ellipsoid2, molodenskyTransform.context.getDescriptor());
        this.inverse = molodenskyTransform;
    }

    @Override
    final void completeParameters(Parameters parameters, double d, Unit<?> unit, double d2) {
        if (Double.isNaN(d2)) {
            d2 = this.context.doubleValue(Molodensky.FLATTENING_DIFFERENCE);
        }
        super.completeParameters(parameters, d, unit, d2);
        parameters.getOrCreate(Molodensky.TX).setValue(this.tX, unit);
        parameters.getOrCreate(Molodensky.TY).setValue(this.tY, unit);
        parameters.getOrCreate(Molodensky.TZ).setValue(this.tZ, unit);
        parameters.getOrCreate(Molodensky.AXIS_LENGTH_DIFFERENCE).setValue(this.\u0394a, unit);
        parameters.getOrCreate(Molodensky.FLATTENING_DIFFERENCE).setValue(d2, Units.UNITY);
        if (parameters != this.context) {
            parameters.parameter("abridged").setValue(this.isAbridged);
        }
    }

    public static MathTransform createGeodeticTransformation(MathTransformFactory mathTransformFactory, Ellipsoid ellipsoid, boolean bl, Ellipsoid ellipsoid2, boolean bl2, double d, double d2, double d3, boolean bl3) throws FactoryException {
        MolodenskyTransform molodenskyTransform = !bl && !bl2 ? (bl3 && d == 0.0 && d2 == 0.0 && d3 == 0.0 ? new AbridgedMolodenskyTransform2D(ellipsoid, ellipsoid2) : new MolodenskyTransform2D(ellipsoid, ellipsoid2, d, d2, d3, bl3)) : new MolodenskyTransform(ellipsoid, bl, ellipsoid2, bl2, d, d2, d3, bl3);
        molodenskyTransform.inverse.context.completeTransform(mathTransformFactory, null);
        return molodenskyTransform.context.completeTransform(mathTransformFactory, molodenskyTransform);
    }

    @Override
    public boolean isIdentity() {
        return this.tX == 0.0 && this.tY == 0.0 && this.tZ == 0.0 && this.\u0394a == 0.0 && this.\u0394fmod == 0.0 && this.getSourceDimensions() == this.getTargetDimensions();
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        return this.transform(dArray[n], dArray[n + 1], this.isSource3D ? dArray[n + 2] : 0.0, dArray2, n2, this.tX, this.tY, this.tZ, null, bl);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double[] dArray3 = null;
        if (dArray == dArray2) {
            int n7 = this.isSource3D ? 3 : 2;
            int n8 = this.isTarget3D ? 3 : 2;
            switch (IterationStrategy.suggest(n, n7, n2, n8, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n7;
                    n2 += (n3 - 1) * n8;
                    n4 = -2 * n7;
                    n5 = -2 * n8;
                    break;
                }
                default: {
                    int n9 = n + n3 * n7;
                    dArray = Arrays.copyOfRange(dArray, n, n9);
                    n = 0;
                    break;
                }
                case BUFFER_TARGET: {
                    dArray3 = dArray2;
                    dArray2 = new double[n3 * n8];
                    n6 = n2;
                    n2 = 0;
                }
            }
        }
        while (--n3 >= 0) {
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = this.isSource3D ? dArray[n++] : 0.0;
            double d4 = Math.sin(d);
            double d5 = Math.cos(d);
            double d6 = Math.sin(d2);
            double d7 = Math.cos(d2);
            double d8 = d6 * d6;
            double d9 = 1.0 - this.eccentricitySquared * d8;
            double d10 = Math.sqrt(d9);
            double d11 = this.semiMajor * (1.0 - this.eccentricitySquared) / (d9 *= d10);
            double d12 = this.semiMajor / d10;
            double d13 = this.\u0394fmod * 2.0;
            if (!this.isAbridged) {
                d11 += d3;
                d12 += d3;
                d13 = d13 * (0.5 / d10 + 0.5 / d9) + this.\u0394a * this.eccentricitySquared / d10;
            }
            double d14 = this.tY * d4 + this.tX * d5;
            dArray2[n2++] = d + 1.0000000000039175 * (this.tY * d5 - this.tX * d4) / (d12 * d7);
            dArray2[n2++] = d2 + 1.0000000000039175 * ((d13 * d7 - d14) * d6 + this.tZ * d7) / d11;
            if (this.isTarget3D) {
                d13 = this.\u0394fmod * d8;
                double d15 = this.\u0394a;
                if (!this.isAbridged) {
                    d13 /= d10;
                    d15 *= d10;
                }
                dArray2[n2++] = d3 + d14 * d7 + this.tZ * d6 + d13 - d15;
            }
            n += n4;
            n2 += n5;
        }
        if (dArray3 != null) {
            System.arraycopy(dArray2, 0, dArray3, n6, dArray2.length);
        }
    }

    @Override
    public MathTransform inverse() {
        return this.inverse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        Class<MolodenskyTransform> clazz = MolodenskyTransform.class;
        synchronized (MolodenskyTransform.class) {
            if (DESCRIPTOR == null) {
                DESCRIPTOR = Molodensky.internal();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DESCRIPTOR;
        }
    }
}

