/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.transformation.forcedmetadata;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.core.interfaces.CharacterInput;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.TempFileCharacterInput;

public class FieldDataFactory {
    protected final RepositoryDocument sourceDocument;
    protected final Map<String, CharacterInput[]> metadataReaders = new HashMap<String, CharacterInput[]>();

    public FieldDataFactory(RepositoryDocument sourceDocument) {
        this.sourceDocument = sourceDocument;
    }

    public void close() throws ManifoldCFException {
        for (String key : this.metadataReaders.keySet()) {
            CharacterInput[] rt;
            for (CharacterInput r : rt = this.metadataReaders.get(key)) {
                r.discard();
            }
        }
    }

    public Object[] getField(String fieldName) throws IOException, ManifoldCFException {
        CharacterInput[] inputs = this.metadataReaders.get(fieldName);
        if (inputs == null) {
            Object[] fieldValues = this.sourceDocument.getField(fieldName);
            if (fieldValues == null) {
                return fieldValues;
            }
            if (fieldValues instanceof Reader[]) {
                CharacterInput[] newValues = new CharacterInput[fieldValues.length];
                try {
                    for (int i = 0; i < newValues.length; ++i) {
                        newValues[i] = new TempFileCharacterInput((Reader)fieldValues[i]);
                    }
                    this.metadataReaders.put(fieldName, newValues);
                    inputs = newValues;
                }
                catch (Throwable e) {
                    for (CharacterInput r : newValues) {
                        if (r == null) continue;
                        r.discard();
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw new RuntimeException("Unknown exception type: " + e.getClass().getName() + ": " + e.getMessage(), e);
                }
            } else {
                return fieldValues;
            }
        }
        Object[] newReaders = new Reader[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i].doneWithStream();
            newReaders[i] = inputs[i].getStream();
        }
        return newReaders;
    }

    public String[] getFieldAsStrings(String fieldName) throws IOException, ManifoldCFException {
        CharacterInput[] cilist = this.metadataReaders.get(fieldName);
        if (cilist == null) {
            return this.sourceDocument.getFieldAsStrings(fieldName);
        }
        char[] buffer = new char[65536];
        String[] rval = new String[cilist.length];
        for (int i = 0; i < rval.length; ++i) {
            int amt;
            CharacterInput ci = cilist[i];
            ci.doneWithStream();
            Reader r = ci.getStream();
            StringBuilder newValue = new StringBuilder();
            while ((amt = r.read(buffer)) != -1) {
                newValue.append(buffer, 0, amt);
            }
            rval[i] = newValue.toString();
        }
        this.sourceDocument.addField(fieldName, rval);
        this.metadataReaders.remove(fieldName);
        for (CharacterInput ci : cilist) {
            ci.discard();
        }
        return rval;
    }
}

