/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.compiler.expressions.AbstractColorBlendFunction;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;

abstract class AbstractSimpleColorBlendFunction
extends AbstractColorBlendFunction {
    AbstractSimpleColorBlendFunction() {
    }

    @Override
    protected Expression evaluate(ColorExpression color1, ColorExpression color2, ProblemsHandler problemsHandler, HiddenTokenAwareTree token) {
        double cbRed = color1.getRed() / 255.0;
        double csRed = color2.getRed() / 255.0;
        double resultRed = this.evaluateNormalized(cbRed, csRed);
        double cbGreen = color1.getGreen() / 255.0;
        double csGreen = color2.getGreen() / 255.0;
        double resultGreen = this.evaluateNormalized(cbGreen, csGreen);
        double cbBlue = color1.getBlue() / 255.0;
        double csBlue = color2.getBlue() / 255.0;
        double resultBlue = this.evaluateNormalized(cbBlue, csBlue);
        if (!color1.hasAlpha() && !color2.hasAlpha()) {
            return AbstractSimpleColorBlendFunction.rgb(resultRed * 255.0, resultGreen * 255.0, resultBlue * 255.0, token);
        }
        double ab = color1.getAlpha();
        double as = color2.getAlpha();
        double resultAlpha = as + ab * (1.0 - as);
        resultRed = this.addAlpha(cbRed, ab, csRed, as, resultRed, resultAlpha);
        resultGreen = this.addAlpha(cbGreen, ab, csGreen, as, resultGreen, resultAlpha);
        resultBlue = this.addAlpha(cbBlue, ab, csBlue, as, resultBlue, resultAlpha);
        return AbstractSimpleColorBlendFunction.rgba(resultRed * 255.0, resultGreen * 255.0, resultBlue * 255.0, resultAlpha, token);
    }

    private double addAlpha(double cb, double ab, double cs, double as, double cr, double ar) {
        return (as * cs + ab * (cb - as * (cb + cs - cr))) / ar;
    }

    protected abstract double evaluateNormalized(double var1, double var3);
}

