/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.alfresco;

import java.rmi.RemoteException;
import org.alfresco.webservice.repository.QueryResult;
import org.alfresco.webservice.repository.RepositoryFault;
import org.alfresco.webservice.types.NamedValue;
import org.alfresco.webservice.types.Reference;
import org.alfresco.webservice.types.ResultSet;
import org.alfresco.webservice.types.ResultSetRow;
import org.alfresco.webservice.util.AuthenticationDetails;
import org.alfresco.webservice.util.AuthenticationUtils;
import org.alfresco.webservice.util.WebServiceFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.alfresco.Constants;
import org.apache.manifoldcf.crawler.system.Logging;

public class ContentModelUtils {
    public static boolean isDocument(NamedValue[] properties) {
        for (NamedValue property : properties) {
            if (!property.getName().equals(Constants.PROP_CONTENT)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFolder(String endpoint, String username, String password, int socketTimeout, AuthenticationDetails session, Reference node) throws ManifoldCFException {
        QueryResult queryResult = null;
        try {
            ResultSetRow[] rows;
            ResultSet rs;
            WebServiceFactory.setEndpointAddress((String)endpoint);
            WebServiceFactory.setTimeoutMilliseconds((int)socketTimeout);
            AuthenticationUtils.startSession((String)username, (String)password);
            session = AuthenticationUtils.getAuthenticationDetails();
            queryResult = WebServiceFactory.getRepositoryService().queryChildren(node);
            if (queryResult != null && (rs = queryResult.getResultSet()) != null && (rows = rs.getRows()) != null && rows.length > 0) {
                boolean bl = true;
                return bl;
            }
            AuthenticationUtils.endSession();
        }
        catch (RepositoryFault e) {
            Logging.connectors.warn((Object)("Alfresco: Repository Error during the queryChildren: " + e.getMessage()), (Throwable)e);
            ContentModelUtils.handleRepositoryFaultException(e);
        }
        catch (RemoteException e) {
            Logging.connectors.warn((Object)("Alfresco: Remote Error during the queryChildren: " + e.getMessage()), (Throwable)e);
            ContentModelUtils.handleRemoteException(e);
        }
        finally {
            session = null;
        }
        return false;
    }

    public static void handleRepositoryFaultException(RepositoryFault e) throws ManifoldCFException {
        throw new ManifoldCFException("Alfresco: Error during getting children: " + e.getMessage(), (Throwable)e);
    }

    public static void handleRemoteException(RemoteException e) throws ManifoldCFException {
        throw new ManifoldCFException("Alfresco: Error during getting children: " + e.getMessage(), (Throwable)e);
    }
}

