/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.global;

import java.io.IOException;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.global.InternalGlobal;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class GlobalAggregator
extends SingleBucketAggregator {
    public GlobalAggregator(String name, AggregatorFactories subFactories, AggregationContext aggregationContext) {
        super(name, subFactories, aggregationContext, null);
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L) : "global aggregator can only be a top level aggregator";
        this.collectBucket(doc, owningBucketOrdinal);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        assert (owningBucketOrdinal == 0L) : "global aggregator can only be a top level aggregator";
        return new InternalGlobal(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        throw new UnsupportedOperationException("global aggregations cannot serve as sub-aggregations, hence should never be called on #buildEmptyAggregations");
    }

    public static class Factory
    extends AggregatorFactory {
        public Factory(String name) {
            super(name, InternalGlobal.TYPE.name());
        }

        @Override
        public Aggregator create(AggregationContext context, Aggregator parent, long expectedBucketsCount) {
            if (parent != null) {
                throw new AggregationExecutionException("Aggregation [" + parent.name() + "] cannot have a global " + "sub-aggregation [" + this.name + "]. Global aggregations can only be defined as top level aggregations");
            }
            return new GlobalAggregator(this.name, this.factories, context);
        }
    }
}

