/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.embedded;

import java.security.Principal;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.embedded.SimplePrincipal;

public class SimpleSecurityDomain
implements SecurityDomain {
    private ConcurrentHashMap<String, String> users = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Set<String>> roles = new ConcurrentHashMap();

    public void addRole(String user, String role) {
        Set<String> users = this.roles.get(role);
        if (users == null) {
            users = new CopyOnWriteArraySet<String>();
            this.roles.putIfAbsent(role, users);
            users = this.roles.get(role);
        }
        users.add(user);
    }

    public void addUser(String username, String password, String[] roles) {
        this.users.put(username, password);
        for (String role : roles) {
            this.addRole(username, role);
        }
    }

    public void addRoles(String role, String[] users) {
        for (String user : users) {
            this.addRole(user, role);
        }
    }

    @Override
    public Principal authenticate(String username, String password) throws SecurityException {
        String passwd = this.users.get(username);
        if (passwd == null) {
            throw new SecurityException("User is not registered: " + username);
        }
        if (!passwd.equals(password)) {
            throw new SecurityException("Wrong password for: " + username);
        }
        return new SimplePrincipal(username);
    }

    @Override
    public boolean isUserInRole(Principal username, String role) {
        Set<String> users = this.roles.get(role);
        if (users == null) {
            return false;
        }
        boolean result = users.contains(username.getName());
        return result;
    }
}

