/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.IAgentManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnection;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnector;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorPool;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnection;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnector;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectorManager;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectorPool;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorPoolFactory;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorManagerFactory;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorPoolFactory;
import org.apache.manifoldcf.agents.outputconnection.OutputConnection;
import org.apache.manifoldcf.agents.transformationconnection.TransformationConnection;
import org.apache.manifoldcf.authorities.authgroups.AuthorityGroup;
import org.apache.manifoldcf.authorities.authority.AuthorityConnection;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectionManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorPoolFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorityGroupManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationDomainManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnection;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectionManager;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnector;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectorManager;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectorPool;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityGroup;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityGroupManager;
import org.apache.manifoldcf.authorities.interfaces.IAuthorizationDomainManager;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnection;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnectionManager;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnector;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnectorManager;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnectorPool;
import org.apache.manifoldcf.authorities.interfaces.MappingConnectionManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.MappingConnectorManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.MappingConnectorPoolFactory;
import org.apache.manifoldcf.authorities.mapping.MappingConnection;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.interfaces.BinManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.BucketDescription;
import org.apache.manifoldcf.crawler.interfaces.ConnectorManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.Connectors;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.DocumentSpecification;
import org.apache.manifoldcf.crawler.interfaces.EnumeratedValues;
import org.apache.manifoldcf.crawler.interfaces.FilterCriteria;
import org.apache.manifoldcf.crawler.interfaces.IBinManager;
import org.apache.manifoldcf.crawler.interfaces.IConnectorManager;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnection;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnector;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnectorManager;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnectorPool;
import org.apache.manifoldcf.crawler.interfaces.IPriorityCalculator;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectorPool;
import org.apache.manifoldcf.crawler.interfaces.IReprioritizationTracker;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.JobStatus;
import org.apache.manifoldcf.crawler.interfaces.NotificationConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.NotificationConnectorManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.NotificationConnectorPoolFactory;
import org.apache.manifoldcf.crawler.interfaces.RegExpCriteria;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorPoolFactory;
import org.apache.manifoldcf.crawler.interfaces.ReprioritizationTrackerFactory;
import org.apache.manifoldcf.crawler.interfaces.ScheduleRecord;
import org.apache.manifoldcf.crawler.interfaces.SortOrder;
import org.apache.manifoldcf.crawler.interfaces.StatusFilterCriteria;
import org.apache.manifoldcf.crawler.jobs.JobDescription;
import org.apache.manifoldcf.crawler.notification.NotificationConnection;
import org.apache.manifoldcf.crawler.repository.RepositoryConnection;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.PriorityCalculator;

public class ManifoldCF
extends org.apache.manifoldcf.agents.system.ManifoldCF {
    public static final String _rcsid = "@(#)$Id: ManifoldCF.java 996524 2010-09-13 13:38:01Z kwright $";
    protected static boolean crawlerInitialized = false;
    protected static final String workerThreadCountProperty = "org.apache.manifoldcf.crawler.threads";
    protected static final String deleteThreadCountProperty = "org.apache.manifoldcf.crawler.deletethreads";
    protected static final String cleanupThreadCountProperty = "org.apache.manifoldcf.crawler.cleanupthreads";
    protected static final String expireThreadCountProperty = "org.apache.manifoldcf.crawler.expirethreads";
    protected static final String lowWaterFactorProperty = "org.apache.manifoldcf.crawler.lowwaterfactor";
    protected static final String stuffAmtFactorProperty = "org.apache.manifoldcf.crawler.stuffamountfactor";
    protected static final String connectorsConfigurationFileProperty = "org.apache.manifoldcf.connectorsconfigurationfile";
    protected static final String databaseSuperuserNameProperty = "org.apache.manifoldcf.dbsuperusername";
    protected static final String databaseSuperuserPasswordProperty = "org.apache.manifoldcf.dbsuperuserpassword";
    protected static final String saltProperty = "org.apache.manifoldcf.salt";
    protected static final String NODE_AUTHORIZATIONDOMAIN = "authorizationdomain";
    protected static final String NODE_OUTPUTCONNECTOR = "outputconnector";
    protected static final String NODE_TRANSFORMATIONCONNECTOR = "transformationconnector";
    protected static final String NODE_MAPPINGCONNECTOR = "mappingconnector";
    protected static final String NODE_AUTHORITYCONNECTOR = "authorityconnector";
    protected static final String NODE_NOTIFICATIONCONNECTOR = "notificationconnector";
    protected static final String NODE_REPOSITORYCONNECTOR = "repositoryconnector";
    protected static final String ATTRIBUTE_NAME = "name";
    protected static final String ATTRIBUTE_CLASS = "class";
    protected static final String ATTRIBUTE_DOMAIN = "domain";
    private static final int IV_LENGTH = 16;
    protected static final String API_JOBNODE = "job";
    protected static final String API_JOBSTATUSNODE = "jobstatus";
    protected static final String API_AUTHORIZATIONDOMAINNODE = "authorizationdomain";
    protected static final String API_AUTHORITYGROUPNODE = "authoritygroup";
    protected static final String API_REPOSITORYCONNECTORNODE = "repositoryconnector";
    protected static final String API_NOTIFICATIONCONNECTORNODE = "notificationconnector";
    protected static final String API_OUTPUTCONNECTORNODE = "outputconnector";
    protected static final String API_TRANSFORMATIONCONNECTORNODE = "transformationconnector";
    protected static final String API_AUTHORITYCONNECTORNODE = "authorityconnector";
    protected static final String API_MAPPINGCONNECTORNODE = "mappingconnector";
    protected static final String API_REPOSITORYCONNECTIONNODE = "repositoryconnection";
    protected static final String API_NOTIFICATIONCONNECTIONNODE = "notificationconnection";
    protected static final String API_OUTPUTCONNECTIONNODE = "outputconnection";
    protected static final String API_TRANSFORMATIONCONNECTIONNODE = "transformationconnection";
    protected static final String API_AUTHORITYCONNECTIONNODE = "authorityconnection";
    protected static final String API_MAPPINGCONNECTIONNODE = "mappingconnection";
    protected static final String API_CHECKRESULTNODE = "check_result";
    protected static final String API_JOBIDNODE = "job_id";
    protected static final String API_CONNECTIONNAMENODE = "connection_name";
    protected static final String API_ROWNODE = "row";
    protected static final String API_COLUMNNODE = "column";
    protected static final String API_NAMENODE = "name";
    protected static final String API_VALUENODE = "value";
    protected static final String API_ACTIVITYNODE = "activity";
    protected static final String CONNECTORNODE_DESCRIPTION = "description";
    protected static final String CONNECTORNODE_CLASSNAME = "class_name";
    protected static final String AUTHORIZATIONDOMAINNODE_DESCRIPTION = "description";
    protected static final String AUTHORIZATIONDOMAINNODE_DOMAINNAME = "domain_name";
    public static final int READRESULT_NOTFOUND = 0;
    public static final int READRESULT_FOUND = 1;
    protected static final Map<String, Integer> docState = new HashMap<String, Integer>();
    protected static final Map<String, Integer> docStatus;
    public static final int POSTRESULT_NOTFOUND = 0;
    public static final int POSTRESULT_FOUND = 1;
    public static final int POSTRESULT_CREATED = 2;
    public static final int WRITERESULT_NOTFOUND = 0;
    public static final int WRITERESULT_FOUND = 1;
    public static final int WRITERESULT_CREATED = 2;
    public static final int DELETERESULT_NOTFOUND = 0;
    public static final int DELETERESULT_FOUND = 1;
    protected static final String JOBNODE_ID = "id";
    protected static final String JOBNODE_DESCRIPTION = "description";
    protected static final String JOBNODE_CONNECTIONNAME = "repository_connection";
    protected static final String JOBNODE_DOCUMENTSPECIFICATION = "document_specification";
    protected static final String JOBNODE_STARTMODE = "start_mode";
    protected static final String JOBNODE_RUNMODE = "run_mode";
    protected static final String JOBNODE_HOPCOUNTMODE = "hopcount_mode";
    protected static final String JOBNODE_PRIORITY = "priority";
    protected static final String JOBNODE_RECRAWLINTERVAL = "recrawl_interval";
    protected static final String JOBNODE_EXPIRATIONINTERVAL = "expiration_interval";
    protected static final String JOBNODE_RESEEDINTERVAL = "reseed_interval";
    protected static final String JOBNODE_HOPCOUNT = "hopcount";
    protected static final String JOBNODE_SCHEDULE = "schedule";
    protected static final String JOBNODE_LINKTYPE = "link_type";
    protected static final String JOBNODE_COUNT = "count";
    protected static final String JOBNODE_REQUESTMINIMUM = "requestminimum";
    protected static final String JOBNODE_TIMEZONE = "timezone";
    protected static final String JOBNODE_DURATION = "duration";
    protected static final String JOBNODE_DAYOFWEEK = "dayofweek";
    protected static final String JOBNODE_MONTHOFYEAR = "monthofyear";
    protected static final String JOBNODE_DAYOFMONTH = "dayofmonth";
    protected static final String JOBNODE_YEAR = "year";
    protected static final String JOBNODE_HOUROFDAY = "hourofday";
    protected static final String JOBNODE_MINUTESOFHOUR = "minutesofhour";
    protected static final String JOBNODE_ENUMVALUE = "value";
    protected static final String JOBNODE_FORCEDPARAM = "forcedparam";
    protected static final String JOBNODE_PARAMNAME = "paramname";
    protected static final String JOBNODE_PARAMVALUE = "paramvalue";
    protected static final String JOBNODE_PIPELINESTAGE = "pipelinestage";
    protected static final String JOBNODE_STAGEID = "stage_id";
    protected static final String JOBNODE_STAGEPREREQUISITE = "stage_prerequisite";
    protected static final String JOBNODE_STAGEISOUTPUT = "stage_isoutput";
    protected static final String JOBNODE_STAGECONNECTIONNAME = "stage_connectionname";
    protected static final String JOBNODE_STAGEDESCRIPTION = "stage_description";
    protected static final String JOBNODE_STAGESPECIFICATION = "stage_specification";
    protected static final String JOBNODE_NOTIFICATIONSTAGE = "notificationstage";
    protected static final String JOBSTATUSNODE_JOBID = "job_id";
    protected static final String JOBSTATUSNODE_STATUS = "status";
    protected static final String JOBSTATUSNODE_ERRORTEXT = "errortext";
    protected static final String JOBSTATUSNODE_STARTTIME = "start_time";
    protected static final String JOBSTATUSNODE_ENDTIME = "end_time";
    protected static final String JOBSTATUSNODE_DOCUMENTSINQUEUE = "documents_in_queue";
    protected static final String JOBSTATUSNODE_DOCUMENTSOUTSTANDING = "documents_outstanding";
    protected static final String JOBSTATUSNODE_DOCUMENTSPROCESSED = "documents_processed";
    protected static final String JOBSTATUSNODE_QUEUEEXACT = "queue_exact";
    protected static final String JOBSTATUSNODE_OUTSTANDINGEXACT = "outstanding_exact";
    protected static final String JOBSTATUSNODE_PROCESSEDEXACT = "processed_exact";
    protected static final String AUTHGROUPNODE_ISNEW = "isnew";
    protected static final String AUTHGROUPNODE_NAME = "name";
    protected static final String AUTHGROUPNODE_DESCRIPTION = "description";
    protected static final String CONNECTIONNODE_ISNEW = "isnew";
    protected static final String CONNECTIONNODE_NAME = "name";
    protected static final String CONNECTIONNODE_CLASSNAME = "class_name";
    protected static final String CONNECTIONNODE_MAXCONNECTIONS = "max_connections";
    protected static final String CONNECTIONNODE_DESCRIPTION = "description";
    protected static final String CONNECTIONNODE_PREREQUISITE = "prerequisite";
    protected static final String CONNECTIONNODE_CONFIGURATION = "configuration";
    protected static final String CONNECTIONNODE_ACLAUTHORITY = "acl_authority";
    protected static final String CONNECTIONNODE_THROTTLE = "throttle";
    protected static final String CONNECTIONNODE_MATCH = "match";
    protected static final String CONNECTIONNODE_MATCHDESCRIPTION = "match_description";
    protected static final String CONNECTIONNODE_RATE = "rate";
    protected static final String CONNECTIONNODE_AUTHDOMAIN = "authdomain";
    protected static final String CONNECTIONNODE_AUTHGROUP = "authgroup";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeEnvironment(IThreadContext tc) throws ManifoldCFException {
        Integer n = initializeFlagLock;
        synchronized (n) {
            org.apache.manifoldcf.agents.system.ManifoldCF.initializeEnvironment((IThreadContext)tc);
            org.apache.manifoldcf.authorities.system.ManifoldCF.localInitialize(tc);
            ManifoldCF.localInitialize(tc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpEnvironment(IThreadContext tc) {
        Integer n = initializeFlagLock;
        synchronized (n) {
            org.apache.manifoldcf.authorities.system.ManifoldCF.localCleanup(tc);
            ManifoldCF.localCleanup(tc);
            org.apache.manifoldcf.agents.system.ManifoldCF.cleanUpEnvironment((IThreadContext)tc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void localInitialize(IThreadContext tc) throws ManifoldCFException {
        Integer n = initializeFlagLock;
        synchronized (n) {
            if (crawlerInitialized) {
                return;
            }
            Logging.initializeLoggers();
            Logging.setLogLevels((IThreadContext)tc);
            crawlerInitialized = true;
        }
    }

    public static void localCleanup(IThreadContext tc) {
        block5: {
            block4: {
                try {
                    RepositoryConnectorPoolFactory.make(tc).closeAllConnectors();
                }
                catch (ManifoldCFException e) {
                    if (Logging.root == null) break block4;
                    Logging.root.warn((Object)("Exception tossed on repository connector pool cleanup: " + e.getMessage()), (Throwable)e);
                }
            }
            try {
                NotificationConnectorPoolFactory.make(tc).closeAllConnectors();
            }
            catch (ManifoldCFException e) {
                if (Logging.root == null) break block5;
                Logging.root.warn((Object)("Exception tossed on notification connector pool cleanup: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void createSystemDatabase(IThreadContext threadContext) throws ManifoldCFException {
        String superuserName = LockManagerFactory.getStringProperty((IThreadContext)threadContext, (String)databaseSuperuserNameProperty, (String)"");
        String superuserPassword = LockManagerFactory.getPossiblyObfuscatedStringProperty((IThreadContext)threadContext, (String)databaseSuperuserPasswordProperty, (String)"");
        ManifoldCF.createSystemDatabase((IThreadContext)threadContext, (String)superuserName, (String)superuserPassword);
    }

    public static void registerThisAgent(IThreadContext tc) throws ManifoldCFException {
        IAgentManager agentMgr = AgentManagerFactory.make((IThreadContext)tc);
        agentMgr.registerAgent("org.apache.manifoldcf.crawler.system.CrawlerAgent");
    }

    public static void reregisterAllConnectors(IThreadContext tc) throws ManifoldCFException {
        File connectorConfigFile = ManifoldCF.getFileProperty((String)connectorsConfigurationFileProperty);
        Connectors c = ManifoldCF.readConnectorDeclarations(connectorConfigFile);
        ManifoldCF.unregisterAllConnectors(tc, c);
        ManifoldCF.registerConnectors(tc, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connectors readConnectorDeclarations(File connectorConfigFile) throws ManifoldCFException {
        Connectors c = null;
        if (connectorConfigFile != null) {
            try (FileInputStream is = new FileInputStream(connectorConfigFile);){
                c = new Connectors(is);
            }
            catch (FileNotFoundException e) {
                throw new ManifoldCFException("Couldn't find connector configuration file: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new ManifoldCFException("Error reading connector configuration file: " + e.getMessage(), (Throwable)e);
            }
        }
        return c;
    }

    public static void unregisterAllConnectors(IThreadContext tc) throws ManifoldCFException {
        ManifoldCF.unregisterAllConnectors(tc, null);
    }

    public static void unregisterAllConnectors(IThreadContext tc, Connectors c) throws ManifoldCFException {
        String[] connectionNames;
        String description;
        String className;
        IResultRow row;
        String className2;
        String[] connectionNames2;
        String description2;
        String className3;
        IResultRow row2;
        String description3;
        HashMap<String, String> desiredOutputConnectors = new HashMap<String, String>();
        HashMap<String, String> desiredTransformationConnectors = new HashMap<String, String>();
        HashMap<String, String> desiredMappingConnectors = new HashMap<String, String>();
        HashMap<String, String> desiredAuthorityConnectors = new HashMap<String, String>();
        HashMap<String, String> desiredNotificationConnectors = new HashMap<String, String>();
        HashMap<String, String> desiredRepositoryConnectors = new HashMap<String, String>();
        HashMap<String, String> desiredDomains = new HashMap<String, String>();
        if (c != null) {
            for (int i = 0; i < c.getChildCount(); ++i) {
                String className4;
                String name;
                ConfigurationNode cn = c.findChild(i);
                if (cn.getType().equals("authorizationdomain")) {
                    String domainName = cn.getAttributeValue(ATTRIBUTE_DOMAIN);
                    String name2 = cn.getAttributeValue("name");
                    desiredDomains.put(domainName, name2);
                    continue;
                }
                if (cn.getType().equals("outputconnector")) {
                    name = cn.getAttributeValue("name");
                    className4 = cn.getAttributeValue(ATTRIBUTE_CLASS);
                    desiredOutputConnectors.put(className4, name);
                    continue;
                }
                if (cn.getType().equals("transformationconnector")) {
                    name = cn.getAttributeValue("name");
                    className4 = cn.getAttributeValue(ATTRIBUTE_CLASS);
                    desiredTransformationConnectors.put(className4, name);
                    continue;
                }
                if (cn.getType().equals("mappingconnector")) {
                    name = cn.getAttributeValue("name");
                    className4 = cn.getAttributeValue(ATTRIBUTE_CLASS);
                    desiredMappingConnectors.put(className4, name);
                    continue;
                }
                if (cn.getType().equals("authorityconnector")) {
                    name = cn.getAttributeValue("name");
                    className4 = cn.getAttributeValue(ATTRIBUTE_CLASS);
                    desiredAuthorityConnectors.put(className4, name);
                    continue;
                }
                if (cn.getType().equals("notificationconnector")) {
                    name = cn.getAttributeValue("name");
                    className4 = cn.getAttributeValue(ATTRIBUTE_CLASS);
                    desiredNotificationConnectors.put(className4, name);
                    continue;
                }
                if (!cn.getType().equals("repositoryconnector")) continue;
                name = cn.getAttributeValue("name");
                className4 = cn.getAttributeValue(ATTRIBUTE_CLASS);
                desiredRepositoryConnectors.put(className4, name);
            }
        }
        IDBInterface database = DBInterfaceFactory.make((IThreadContext)tc, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        Object mgr = AuthorizationDomainManagerFactory.make(tc);
        IResultSet domains = mgr.getDomains();
        for (int i = 0; i < domains.getRowCount(); ++i) {
            IResultRow row3 = domains.getRow(i);
            String domainName = (String)row3.getValue("domainname");
            description3 = (String)row3.getValue("description");
            if (desiredDomains.get(domainName) != null && ((String)desiredDomains.get(domainName)).equals(description3)) continue;
            mgr.unregisterDomain(domainName);
        }
        System.err.println("Successfully unregistered all domains");
        mgr = OutputConnectorManagerFactory.make((IThreadContext)tc);
        IOutputConnectionManager connManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
        IResultSet classNames = mgr.getConnectors();
        int i = 0;
        while (i < classNames.getRowCount()) {
            row2 = classNames.getRow(i++);
            className3 = (String)row2.getValue("classname");
            description2 = (String)row2.getValue("description");
            if (desiredOutputConnectors.get(className3) != null && ((String)desiredOutputConnectors.get(className3)).equals(description2)) continue;
            database.beginTransaction();
            try {
                connectionNames2 = connManager.findConnectionsForConnector(className3);
                AgentManagerFactory.noteOutputConnectorDeregistration((IThreadContext)tc, (String[])connectionNames2);
                mgr.unregisterConnector(className3);
            }
            catch (ManifoldCFException e) {
                database.signalRollback();
                throw e;
            }
            catch (Error e) {
                database.signalRollback();
                throw e;
            }
            finally {
                database.endTransaction();
            }
        }
        System.err.println("Successfully unregistered all output connectors");
        mgr = TransformationConnectorManagerFactory.make((IThreadContext)tc);
        connManager = TransformationConnectionManagerFactory.make((IThreadContext)tc);
        classNames = mgr.getConnectors();
        i = 0;
        while (i < classNames.getRowCount()) {
            row2 = classNames.getRow(i++);
            className3 = (String)row2.getValue("classname");
            description2 = (String)row2.getValue("description");
            if (desiredTransformationConnectors.get(className3) != null && ((String)desiredTransformationConnectors.get(className3)).equals(description2)) continue;
            database.beginTransaction();
            try {
                connectionNames2 = connManager.findConnectionsForConnector(className3);
                AgentManagerFactory.noteTransformationConnectorDeregistration((IThreadContext)tc, (String[])connectionNames2);
                mgr.unregisterConnector(className3);
            }
            catch (ManifoldCFException e) {
                database.signalRollback();
                throw e;
            }
            catch (Error e) {
                database.signalRollback();
                throw e;
            }
            finally {
                database.endTransaction();
            }
        }
        System.err.println("Successfully unregistered all transformation connectors");
        mgr = MappingConnectorManagerFactory.make(tc);
        IResultSet classNames2 = mgr.getConnectors();
        int i2 = 0;
        while (i2 < classNames2.getRowCount()) {
            IResultRow row4 = classNames2.getRow(i2++);
            className2 = (String)row4.getValue("classname");
            description3 = (String)row4.getValue("description");
            if (desiredMappingConnectors.get(className2) != null && ((String)desiredMappingConnectors.get(className2)).equals(description3)) continue;
            mgr.unregisterConnector(className2);
        }
        System.err.println("Successfully unregistered all mapping connectors");
        mgr = AuthorityConnectorManagerFactory.make(tc);
        classNames2 = mgr.getConnectors();
        i2 = 0;
        while (i2 < classNames2.getRowCount()) {
            IResultRow row5 = classNames2.getRow(i2++);
            className2 = (String)row5.getValue("classname");
            description3 = (String)row5.getValue("description");
            if (desiredAuthorityConnectors.get(className2) != null && ((String)desiredAuthorityConnectors.get(className2)).equals(description3)) continue;
            mgr.unregisterConnector(className2);
        }
        System.err.println("Successfully unregistered all authority connectors");
        mgr = NotificationConnectorManagerFactory.make(tc);
        IJobManager jobManager = JobManagerFactory.make(tc);
        Object connManager2 = NotificationConnectionManagerFactory.make(tc);
        IResultSet classNames3 = mgr.getConnectors();
        int i3 = 0;
        while (i3 < classNames3.getRowCount()) {
            row = classNames3.getRow(i3++);
            className = (String)row.getValue("classname");
            description = (String)row.getValue("description");
            if (desiredNotificationConnectors.get(className) != null && ((String)desiredNotificationConnectors.get(className)).equals(description)) continue;
            database.beginTransaction();
            try {
                connectionNames = connManager2.findConnectionsForConnector(className);
                jobManager.noteNotificationConnectorDeregistration(connectionNames);
                mgr.unregisterConnector(className);
            }
            catch (ManifoldCFException e) {
                database.signalRollback();
                throw e;
            }
            catch (Error e) {
                database.signalRollback();
                throw e;
            }
            finally {
                database.endTransaction();
            }
        }
        mgr = ConnectorManagerFactory.make(tc);
        jobManager = JobManagerFactory.make(tc);
        connManager2 = RepositoryConnectionManagerFactory.make(tc);
        classNames3 = mgr.getConnectors();
        i3 = 0;
        while (i3 < classNames3.getRowCount()) {
            row = classNames3.getRow(i3++);
            className = (String)row.getValue("classname");
            description = (String)row.getValue("description");
            if (desiredRepositoryConnectors.get(className) != null && ((String)desiredRepositoryConnectors.get(className)).equals(description)) continue;
            database.beginTransaction();
            try {
                connectionNames = connManager2.findConnectionsForConnector(className);
                jobManager.noteConnectorDeregistration(connectionNames);
                mgr.unregisterConnector(className);
            }
            catch (ManifoldCFException e) {
                database.signalRollback();
                throw e;
            }
            catch (Error e) {
                database.signalRollback();
                throw e;
            }
            finally {
                database.endTransaction();
            }
        }
        System.err.println("Successfully unregistered all repository connectors");
    }

    public static void registerConnectors(IThreadContext tc, Connectors c) throws ManifoldCFException {
        if (c != null) {
            IDBInterface database = DBInterfaceFactory.make((IThreadContext)tc, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
            int i = 0;
            while (i < c.getChildCount()) {
                String[] connectionNames;
                Object connManager;
                IJobManager jobManager;
                String[] connectionNames2;
                IOutputConnectionManager connManager2;
                String className;
                String name;
                Object mgr;
                ConfigurationNode cn;
                if ((cn = c.findChild(i++)).getType().equals("authorizationdomain")) {
                    String domainName = cn.getAttributeValue(ATTRIBUTE_DOMAIN);
                    String name2 = cn.getAttributeValue("name");
                    mgr = AuthorizationDomainManagerFactory.make(tc);
                    mgr.registerDomain(name2, domainName);
                    continue;
                }
                if (cn.getType().equals("outputconnector")) {
                    name = cn.getAttributeValue("name");
                    className = cn.getAttributeValue(ATTRIBUTE_CLASS);
                    mgr = OutputConnectorManagerFactory.make((IThreadContext)tc);
                    connManager2 = OutputConnectionManagerFactory.make((IThreadContext)tc);
                    database.beginTransaction();
                    try {
                        mgr.registerConnector(name, className);
                        connectionNames2 = connManager2.findConnectionsForConnector(className);
                        AgentManagerFactory.noteOutputConnectorRegistration((IThreadContext)tc, (String[])connectionNames2);
                    }
                    catch (ManifoldCFException e) {
                        database.signalRollback();
                        throw e;
                    }
                    catch (Error e) {
                        database.signalRollback();
                        throw e;
                    }
                    finally {
                        database.endTransaction();
                    }
                    System.err.println("Successfully registered output connector '" + className + "'");
                    continue;
                }
                if (cn.getType().equals("transformationconnector")) {
                    name = cn.getAttributeValue("name");
                    className = cn.getAttributeValue(ATTRIBUTE_CLASS);
                    mgr = TransformationConnectorManagerFactory.make((IThreadContext)tc);
                    connManager2 = TransformationConnectionManagerFactory.make((IThreadContext)tc);
                    database.beginTransaction();
                    try {
                        mgr.registerConnector(name, className);
                        connectionNames2 = connManager2.findConnectionsForConnector(className);
                        AgentManagerFactory.noteTransformationConnectorRegistration((IThreadContext)tc, (String[])connectionNames2);
                    }
                    catch (ManifoldCFException e) {
                        database.signalRollback();
                        throw e;
                    }
                    catch (Error e) {
                        database.signalRollback();
                        throw e;
                    }
                    finally {
                        database.endTransaction();
                    }
                    System.err.println("Successfully registered transformation connector '" + className + "'");
                    continue;
                }
                if (cn.getType().equals("authorityconnector")) {
                    name = cn.getAttributeValue("name");
                    className = cn.getAttributeValue(ATTRIBUTE_CLASS);
                    mgr = AuthorityConnectorManagerFactory.make(tc);
                    mgr.registerConnector(name, className);
                    System.err.println("Successfully registered authority connector '" + className + "'");
                    continue;
                }
                if (cn.getType().equals("mappingconnector")) {
                    name = cn.getAttributeValue("name");
                    className = cn.getAttributeValue(ATTRIBUTE_CLASS);
                    mgr = MappingConnectorManagerFactory.make(tc);
                    mgr.registerConnector(name, className);
                    System.err.println("Successfully registered mapping connector '" + className + "'");
                    continue;
                }
                if (cn.getType().equals("notificationconnector")) {
                    name = cn.getAttributeValue("name");
                    className = cn.getAttributeValue(ATTRIBUTE_CLASS);
                    mgr = NotificationConnectorManagerFactory.make(tc);
                    jobManager = JobManagerFactory.make(tc);
                    connManager = NotificationConnectionManagerFactory.make(tc);
                    database.beginTransaction();
                    try {
                        mgr.registerConnector(name, className);
                        connectionNames = connManager.findConnectionsForConnector(className);
                        jobManager.noteNotificationConnectorRegistration(connectionNames);
                    }
                    catch (ManifoldCFException e) {
                        database.signalRollback();
                        throw e;
                    }
                    catch (Error e) {
                        database.signalRollback();
                        throw e;
                    }
                    finally {
                        database.endTransaction();
                    }
                    System.err.println("Successfully registered notification connector '" + className + "'");
                    continue;
                }
                if (cn.getType().equals("repositoryconnector")) {
                    name = cn.getAttributeValue("name");
                    className = cn.getAttributeValue(ATTRIBUTE_CLASS);
                    mgr = ConnectorManagerFactory.make(tc);
                    jobManager = JobManagerFactory.make(tc);
                    connManager = RepositoryConnectionManagerFactory.make(tc);
                    database.beginTransaction();
                    try {
                        mgr.registerConnector(name, className);
                        connectionNames = connManager.findConnectionsForConnector(className);
                        jobManager.noteConnectorRegistration(connectionNames);
                    }
                    catch (ManifoldCFException e) {
                        database.signalRollback();
                        throw e;
                    }
                    catch (Error e) {
                        database.signalRollback();
                        throw e;
                    }
                    finally {
                        database.endTransaction();
                    }
                    System.err.println("Successfully registered repository connector '" + className + "'");
                    continue;
                }
                throw new ManifoldCFException("Unrecognized connectors node type '" + cn.getType() + "'");
            }
        }
    }

    public static void installSystemTables(IThreadContext threadcontext) throws ManifoldCFException {
        IConnectorManager repConnMgr = ConnectorManagerFactory.make(threadcontext);
        IRepositoryConnectionManager repCon = RepositoryConnectionManagerFactory.make(threadcontext);
        INotificationConnectorManager notConnMgr = NotificationConnectorManagerFactory.make(threadcontext);
        INotificationConnectionManager notCon = NotificationConnectionManagerFactory.make(threadcontext);
        IJobManager jobManager = JobManagerFactory.make(threadcontext);
        IBinManager binManager = BinManagerFactory.make(threadcontext);
        org.apache.manifoldcf.authorities.system.ManifoldCF.installSystemTables(threadcontext);
        repConnMgr.install();
        repCon.install();
        notConnMgr.install();
        notCon.install();
        jobManager.install();
        binManager.install();
    }

    public static void deinstallSystemTables(IThreadContext threadcontext) throws ManifoldCFException {
        IConnectorManager repConnMgr = ConnectorManagerFactory.make(threadcontext);
        IRepositoryConnectionManager repCon = RepositoryConnectionManagerFactory.make(threadcontext);
        INotificationConnectorManager notConnMgr = NotificationConnectorManagerFactory.make(threadcontext);
        INotificationConnectionManager notCon = NotificationConnectionManagerFactory.make(threadcontext);
        IJobManager jobManager = JobManagerFactory.make(threadcontext);
        IBinManager binManager = BinManagerFactory.make(threadcontext);
        binManager.deinstall();
        jobManager.deinstall();
        notCon.deinstall();
        notConnMgr.deinstall();
        repCon.deinstall();
        repConnMgr.deinstall();
        org.apache.manifoldcf.authorities.system.ManifoldCF.deinstallSystemTables(threadcontext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportConfiguration(IThreadContext threadContext, String exportFilename, String passCode) throws ManifoldCFException {
        IDBInterface database = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        IOutputConnectionManager outputManager = OutputConnectionManagerFactory.make((IThreadContext)threadContext);
        ITransformationConnectionManager transManager = TransformationConnectionManagerFactory.make((IThreadContext)threadContext);
        IAuthorityGroupManager groupManager = AuthorityGroupManagerFactory.make(threadContext);
        IRepositoryConnectionManager connManager = RepositoryConnectionManagerFactory.make(threadContext);
        INotificationConnectionManager notificationConnManager = NotificationConnectionManagerFactory.make(threadContext);
        IMappingConnectionManager mappingManager = MappingConnectionManagerFactory.make(threadContext);
        IAuthorityConnectionManager authManager = AuthorityConnectionManagerFactory.make(threadContext);
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        File outputFile = new File(exportFilename);
        try (FileOutputStream os = new FileOutputStream(outputFile);){
            ZipOutputStream zos = null;
            CipherOutputStream cos = null;
            if (passCode != null && passCode.length() > 0) {
                SecureRandom random = new SecureRandom();
                byte[] iv = new byte[16];
                random.nextBytes(iv);
                ((OutputStream)os).write(iv);
                os.flush();
                Cipher cipher = null;
                try {
                    cipher = ManifoldCF.getCipher(threadContext, 1, passCode, iv);
                }
                catch (GeneralSecurityException gse) {
                    throw new ManifoldCFException("Could not encrypt configuratiom file: " + gse.getMessage());
                }
                cos = new CipherOutputStream(os, cipher);
                zos = new ZipOutputStream(cos);
            } else {
                zos = new ZipOutputStream(os);
            }
            try {
                database.beginTransaction();
                try {
                    ZipEntry transEntry = new ZipEntry("transformations");
                    zos.putNextEntry(transEntry);
                    transManager.exportConfiguration((OutputStream)zos);
                    zos.closeEntry();
                    ZipEntry outputEntry = new ZipEntry("outputs");
                    zos.putNextEntry(outputEntry);
                    outputManager.exportConfiguration((OutputStream)zos);
                    zos.closeEntry();
                    ZipEntry groupEntry = new ZipEntry("groups");
                    zos.putNextEntry(groupEntry);
                    groupManager.exportConfiguration(zos);
                    zos.closeEntry();
                    ZipEntry mappingEntry = new ZipEntry("mappings");
                    zos.putNextEntry(mappingEntry);
                    mappingManager.exportConfiguration(zos);
                    zos.closeEntry();
                    ZipEntry authEntry = new ZipEntry("authorities");
                    zos.putNextEntry(authEntry);
                    authManager.exportConfiguration(zos);
                    zos.closeEntry();
                    ZipEntry connEntry = new ZipEntry("connections");
                    zos.putNextEntry(connEntry);
                    connManager.exportConfiguration(zos);
                    zos.closeEntry();
                    ZipEntry notConnEntry = new ZipEntry("notifications");
                    zos.putNextEntry(notConnEntry);
                    notificationConnManager.exportConfiguration(zos);
                    zos.closeEntry();
                    ZipEntry jobsEntry = new ZipEntry("jobs");
                    zos.putNextEntry(jobsEntry);
                    jobManager.exportConfiguration(zos);
                    zos.closeEntry();
                }
                catch (ManifoldCFException e) {
                    database.signalRollback();
                    throw e;
                }
                catch (Error e) {
                    database.signalRollback();
                    throw e;
                }
                finally {
                    database.endTransaction();
                }
            }
            finally {
                zos.close();
                if (cos != null) {
                    cos.close();
                }
            }
        }
        catch (IOException e) {
            outputFile.delete();
            throw new ManifoldCFException("Error creating configuration file: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importConfiguration(IThreadContext threadContext, String importFilename, String passCode) throws ManifoldCFException {
        IDBInterface database = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        IOutputConnectionManager outputManager = OutputConnectionManagerFactory.make((IThreadContext)threadContext);
        ITransformationConnectionManager transManager = TransformationConnectionManagerFactory.make((IThreadContext)threadContext);
        IAuthorityGroupManager groupManager = AuthorityGroupManagerFactory.make(threadContext);
        IRepositoryConnectionManager connManager = RepositoryConnectionManagerFactory.make(threadContext);
        INotificationConnectionManager notificationConnManager = NotificationConnectionManagerFactory.make(threadContext);
        IMappingConnectionManager mappingManager = MappingConnectionManagerFactory.make(threadContext);
        IAuthorityConnectionManager authManager = AuthorityConnectionManagerFactory.make(threadContext);
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        File inputFile = new File(importFilename);
        try (FileInputStream is = new FileInputStream(inputFile);){
            ZipInputStream zis = null;
            CipherInputStream cis = null;
            if (passCode != null && passCode.length() > 0) {
                byte[] iv = new byte[16];
                ((InputStream)is).read(iv);
                Cipher cipher = null;
                try {
                    cipher = ManifoldCF.getCipher(threadContext, 2, passCode, iv);
                }
                catch (GeneralSecurityException gse) {
                    throw new ManifoldCFException("Could not decrypt configuratiom file: " + gse.getMessage());
                }
                cis = new CipherInputStream(is, cipher);
                zis = new ZipInputStream(cis);
            } else {
                zis = new ZipInputStream(is);
            }
            try {
                database.beginTransaction();
                try {
                    ZipEntry z;
                    int entries = 0;
                    while ((z = zis.getNextEntry()) != null) {
                        ++entries;
                        String name = z.getName();
                        if (name.equals("transformations")) {
                            transManager.importConfiguration((InputStream)zis);
                        } else if (name.equals("outputs")) {
                            outputManager.importConfiguration((InputStream)zis);
                        } else if (name.equals("groups")) {
                            groupManager.importConfiguration(zis);
                        } else if (name.equals("mappings")) {
                            mappingManager.importConfiguration(zis);
                        } else if (name.equals("authorities")) {
                            authManager.importConfiguration(zis);
                        } else if (name.equals("connections")) {
                            connManager.importConfiguration(zis);
                        } else if (name.equals("notifications")) {
                            notificationConnManager.importConfiguration(zis);
                        } else if (name.equals("jobs")) {
                            jobManager.importConfiguration(zis);
                        } else {
                            throw new ManifoldCFException("Configuration file has an entry named '" + name + "' that I do not recognize");
                        }
                        zis.closeEntry();
                    }
                    if (entries == 0 && passCode != null && passCode.length() > 0) {
                        throw new ManifoldCFException("Cannot read configuration file. Please check your passcode and/or SALT value.");
                    }
                }
                catch (ManifoldCFException e) {
                    database.signalRollback();
                    throw e;
                }
                catch (Error e) {
                    database.signalRollback();
                    throw e;
                }
                finally {
                    database.endTransaction();
                }
            }
            finally {
                zis.close();
                if (cis != null) {
                    cis.close();
                }
            }
        }
        catch (IOException e) {
            throw new ManifoldCFException("Error reading configuration file: " + e.getMessage(), (Throwable)e);
        }
    }

    public static int getMaxWorkerThreads(IThreadContext threadContext) throws ManifoldCFException {
        return LockManagerFactory.getIntProperty((IThreadContext)threadContext, (String)workerThreadCountProperty, (int)100);
    }

    public static int getMaxDeleteThreads(IThreadContext threadContext) throws ManifoldCFException {
        return LockManagerFactory.getIntProperty((IThreadContext)threadContext, (String)deleteThreadCountProperty, (int)10);
    }

    public static int getMaxExpireThreads(IThreadContext threadContext) throws ManifoldCFException {
        return LockManagerFactory.getIntProperty((IThreadContext)threadContext, (String)expireThreadCountProperty, (int)10);
    }

    public static int getMaxCleanupThreads(IThreadContext threadContext) throws ManifoldCFException {
        return LockManagerFactory.getIntProperty((IThreadContext)threadContext, (String)cleanupThreadCountProperty, (int)10);
    }

    public static void requeueDocumentsDueToCarrydown(IJobManager jobManager, DocumentDescription[] requeueCandidates, IRepositoryConnector connector, IRepositoryConnection connection, IReprioritizationTracker rt, long currentTime) throws ManifoldCFException {
        IPriorityCalculator[] docPriorities = new IPriorityCalculator[requeueCandidates.length];
        String[][] binNames = new String[requeueCandidates.length][];
        for (int q = 0; q < requeueCandidates.length; ++q) {
            DocumentDescription dd = requeueCandidates[q];
            String[] bins = ManifoldCF.calculateBins(connector, dd.getDocumentIdentifier());
            binNames[q] = bins;
            docPriorities[q] = new PriorityCalculator(rt, connection, bins, dd.getDocumentIdentifier());
        }
        jobManager.carrydownChangeDocumentMultiple(requeueCandidates, docPriorities);
    }

    public static String colonStuff(String input) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char x;
            if ((x = input.charAt(i++)) == ':' || x == '\\') {
                sb.append('\\');
            }
            sb.append(x);
        }
        return sb.toString();
    }

    public static String createGlobalString(String simpleString) {
        return ":" + simpleString;
    }

    public static String createConnectionSpecificString(String connectionName, String simpleString) {
        return "C " + ManifoldCF.colonStuff(connectionName) + ":" + simpleString;
    }

    public static String createJobSpecificString(Long jobID, String simpleString) {
        return "J " + jobID.toString() + ":" + simpleString;
    }

    public static String[] calculateBins(IRepositoryConnector connector, String documentIdentifier) {
        return connector.getBinNames(documentIdentifier);
    }

    public static void resetAllDocumentPriorities(IThreadContext threadContext, String processID) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        IReprioritizationTracker rt = ReprioritizationTrackerFactory.make(threadContext);
        String reproID = IDFactory.make((IThreadContext)threadContext);
        rt.startReprioritization(processID, reproID);
        jobManager.clearAllDocumentPriorities();
        rt.doneReprioritization(reproID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocumentPriorities(IThreadContext threadContext, DocumentDescription[] descs, Map<String, IRepositoryConnection> connectionMap, Map<Long, IJobDescription> jobDescriptionMap) throws ManifoldCFException {
        IRepositoryConnectorPool repositoryConnectorPool = RepositoryConnectorPoolFactory.make(threadContext);
        IRepositoryConnectionManager mgr = RepositoryConnectionManagerFactory.make(threadContext);
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        IReprioritizationTracker rt = ReprioritizationTrackerFactory.make(threadContext);
        if (Logging.scheduling.isDebugEnabled()) {
            Logging.scheduling.debug((Object)("Reprioritizing " + Integer.toString(descs.length) + " documents"));
        }
        IPriorityCalculator[] priorities = new IPriorityCalculator[descs.length];
        rt.clearPreloadRequests();
        HashSet<String> connectionNames = new HashSet<String>();
        for (int i = 0; i < descs.length; ++i) {
            DocumentDescription dd = descs[i];
            IJobDescription job = jobDescriptionMap.get(dd.getJobID());
            if (job == null) {
                job = jobManager.load(dd.getJobID(), true);
                jobDescriptionMap.put(dd.getJobID(), job);
            }
            connectionNames.add(job.getConnectionName());
        }
        String[] orderingKeys = new String[connectionNames.size()];
        IRepositoryConnection[] connections = new IRepositoryConnection[connectionNames.size()];
        int z = 0;
        Iterator i$ = connectionNames.iterator();
        while (i$.hasNext()) {
            String connectionName;
            orderingKeys[z] = connectionName = (String)i$.next();
            IRepositoryConnection connection = connectionMap.get(connectionName);
            if (connection == null) {
                connection = mgr.load(connectionName);
                connectionMap.put(connectionName, connection);
            }
            connections[z] = connection;
            ++z;
        }
        IRepositoryConnector[] connectors = repositoryConnectorPool.grabMultiple(orderingKeys, connections);
        try {
            HashMap<String, IRepositoryConnector> connectorMap = new HashMap<String, IRepositoryConnector>();
            for (z = 0; z < orderingKeys.length; ++z) {
                connectorMap.put(orderingKeys[z], connectors[z]);
            }
            double minimumDepth = rt.getMinimumDepth();
            for (int i = 0; i < descs.length; ++i) {
                DocumentDescription dd = descs[i];
                IJobDescription job = jobDescriptionMap.get(dd.getJobID());
                String connectionName = job.getConnectionName();
                IRepositoryConnector connector = (IRepositoryConnector)connectorMap.get(connectionName);
                IRepositoryConnection connection = connectionMap.get(connectionName);
                String[] binNames = connector == null ? new String[]{""} : connector.getBinNames(descs[i].getDocumentIdentifier());
                PriorityCalculator p = new PriorityCalculator(rt, minimumDepth, connection, binNames, descs[i].getDocumentIdentifier());
                priorities[i] = p;
                p.makePreloadRequest();
            }
        }
        finally {
            repositoryConnectorPool.releaseMultiple(connections, connectors);
        }
        rt.preloadBinValues();
        jobManager.writeDocumentPriorities(descs, priorities);
        rt.clearPreloadedValues();
    }

    public static String[] getActivitiesList(IThreadContext threadContext, String connectionName) throws ManifoldCFException {
        IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(threadContext);
        IRepositoryConnection thisConnection = connectionManager.load(connectionName);
        if (thisConnection == null) {
            return null;
        }
        String[] outputActivityList = OutputConnectionManagerFactory.getAllOutputActivities((IThreadContext)threadContext);
        String[] transformationActivityList = TransformationConnectionManagerFactory.getAllTransformationActivities((IThreadContext)threadContext);
        String[] connectorActivityList = RepositoryConnectorFactory.getActivitiesList(threadContext, thisConnection.getClassName());
        String[] globalActivityList = IRepositoryConnectionManager.activitySet;
        Object[] activityList = new String[transformationActivityList.length + outputActivityList.length + (connectorActivityList == null ? 0 : connectorActivityList.length) + globalActivityList.length];
        int k2 = 0;
        if (transformationActivityList != null) {
            for (String transformationActivity : transformationActivityList) {
                activityList[k2++] = transformationActivity;
            }
        }
        if (outputActivityList != null) {
            for (String outputActivity : outputActivityList) {
                activityList[k2++] = outputActivity;
            }
        }
        if (connectorActivityList != null) {
            for (String connectorActivity : connectorActivityList) {
                activityList[k2++] = connectorActivity;
            }
        }
        for (String globalActivity : globalActivityList) {
            activityList[k2++] = globalActivity;
        }
        Arrays.sort(activityList);
        return activityList;
    }

    private static Cipher getCipher(IThreadContext threadContext, int mode, String passCode, byte[] iv) throws GeneralSecurityException, ManifoldCFException {
        String saltValue = LockManagerFactory.getProperty((IThreadContext)threadContext, (String)saltProperty);
        if (saltValue == null || saltValue.length() == 0) {
            throw new ManifoldCFException("Missing required SALT value");
        }
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec keySpec = new PBEKeySpec(passCode.toCharArray(), saltValue.getBytes(), 1024, 128);
        SecretKey secretKey = factory.generateSecret(keySpec);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec key = new SecretKeySpec(secretKey.getEncoded(), "AES");
        IvParameterSpec parameterSpec = new IvParameterSpec(iv);
        cipher.init(mode, (Key)key, parameterSpec);
        return cipher;
    }

    public static String decodeAPIPathElement(String startingPathElement) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < startingPathElement.length()) {
            char x;
            if ((x = startingPathElement.charAt(i++)) == '.') {
                if (i == startingPathElement.length()) {
                    throw new ManifoldCFException("Element decoding failed; illegal '.' character in '" + startingPathElement + "'");
                }
                if ((x = startingPathElement.charAt(i++)) == '.') {
                    sb.append(x);
                    continue;
                }
                if (x == '+') {
                    sb.append('/');
                    continue;
                }
                throw new ManifoldCFException("Element decoding failed; illegal post-'.' character in '" + startingPathElement + "'");
            }
            sb.append(x);
        }
        return sb.toString();
    }

    protected static int apiReadJobs(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            IJobManager jobManager = JobManagerFactory.make(tc);
            IJobDescription[] jobs = jobManager.getAllJobs();
            int i = 0;
            while (i < jobs.length) {
                ConfigurationNode jobNode = new ConfigurationNode(API_JOBNODE);
                ManifoldCF.formatJobDescription(jobNode, jobs[i++]);
                output.addChild(output.getChildCount(), jobNode);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadJob(IThreadContext tc, Configuration output, Long jobID) throws ManifoldCFException {
        try {
            IJobManager jobManager = JobManagerFactory.make(tc);
            IJobDescription job = jobManager.load(jobID);
            if (job == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)"Job does not exist.");
                return 0;
            }
            ConfigurationNode jobNode = new ConfigurationNode(API_JOBNODE);
            ManifoldCF.formatJobDescription(jobNode, job);
            output.addChild(output.getChildCount(), jobNode);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int apiReadOutputConnectionStatus(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            String results;
            IOutputConnectorPool outputConnectorPool = OutputConnectorPoolFactory.make((IThreadContext)tc);
            IOutputConnectionManager connectionManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
            IOutputConnection connection = connectionManager.load(connectionName);
            if (connection == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)("Connection '" + connectionName + "' does not exist"));
                return 0;
            }
            IOutputConnector connector = outputConnectorPool.grab(connection);
            try {
                results = connector.check();
            }
            catch (ManifoldCFException e) {
                results = e.getMessage();
            }
            finally {
                outputConnectorPool.release(connection, connector);
            }
            ConfigurationNode response = new ConfigurationNode(API_CHECKRESULTNODE);
            response.setValue(results);
            output.addChild(output.getChildCount(), response);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int apiReadTransformationConnectionStatus(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            String results;
            ITransformationConnectorPool transformationConnectorPool = TransformationConnectorPoolFactory.make((IThreadContext)tc);
            ITransformationConnectionManager connectionManager = TransformationConnectionManagerFactory.make((IThreadContext)tc);
            ITransformationConnection connection = connectionManager.load(connectionName);
            if (connection == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)("Connection '" + connectionName + "' does not exist"));
                return 0;
            }
            ITransformationConnector connector = transformationConnectorPool.grab(connection);
            try {
                results = connector.check();
            }
            catch (ManifoldCFException e) {
                results = e.getMessage();
            }
            finally {
                transformationConnectorPool.release(connection, connector);
            }
            ConfigurationNode response = new ConfigurationNode(API_CHECKRESULTNODE);
            response.setValue(results);
            output.addChild(output.getChildCount(), response);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int apiReadAuthorityConnectionStatus(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            String results;
            IAuthorityConnectorPool authorityConnectorPool = AuthorityConnectorPoolFactory.make(tc);
            IAuthorityConnectionManager connectionManager = AuthorityConnectionManagerFactory.make(tc);
            IAuthorityConnection connection = connectionManager.load(connectionName);
            if (connection == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)("Connection '" + connectionName + "' does not exist"));
                return 0;
            }
            IAuthorityConnector connector = authorityConnectorPool.grab(connection);
            try {
                results = connector.check();
            }
            catch (ManifoldCFException e) {
                results = e.getMessage();
            }
            finally {
                authorityConnectorPool.release(connection, connector);
            }
            ConfigurationNode response = new ConfigurationNode(API_CHECKRESULTNODE);
            response.setValue(results);
            output.addChild(output.getChildCount(), response);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int apiReadMappingConnectionStatus(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            String results;
            IMappingConnectorPool mappingConnectorPool = MappingConnectorPoolFactory.make(tc);
            IMappingConnectionManager connectionManager = MappingConnectionManagerFactory.make(tc);
            IMappingConnection connection = connectionManager.load(connectionName);
            if (connection == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)("Connection '" + connectionName + "' does not exist"));
                return 0;
            }
            IMappingConnector connector = mappingConnectorPool.grab(connection);
            try {
                results = connector.check();
            }
            catch (ManifoldCFException e) {
                results = e.getMessage();
            }
            finally {
                mappingConnectorPool.release(connection, connector);
            }
            ConfigurationNode response = new ConfigurationNode(API_CHECKRESULTNODE);
            response.setValue(results);
            output.addChild(output.getChildCount(), response);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int apiReadRepositoryConnectionStatus(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            String results;
            IRepositoryConnectorPool repositoryConnectorPool = RepositoryConnectorPoolFactory.make(tc);
            IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(tc);
            IRepositoryConnection connection = connectionManager.load(connectionName);
            if (connection == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)("Connection '" + connectionName + "' does not exist"));
                return 0;
            }
            IRepositoryConnector connector = repositoryConnectorPool.grab(connection);
            try {
                results = connector.check();
            }
            catch (ManifoldCFException e) {
                results = e.getMessage();
            }
            finally {
                repositoryConnectorPool.release(connection, connector);
            }
            ConfigurationNode response = new ConfigurationNode(API_CHECKRESULTNODE);
            response.setValue(results);
            output.addChild(output.getChildCount(), response);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int apiReadNotificationConnectionStatus(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            String results;
            INotificationConnectorPool notificationConnectorPool = NotificationConnectorPoolFactory.make(tc);
            INotificationConnectionManager connectionManager = NotificationConnectionManagerFactory.make(tc);
            INotificationConnection connection = connectionManager.load(connectionName);
            if (connection == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)("Connection '" + connectionName + "' does not exist"));
                return 0;
            }
            INotificationConnector connector = notificationConnectorPool.grab(connection);
            try {
                results = connector.check();
            }
            catch (ManifoldCFException e) {
                results = e.getMessage();
            }
            finally {
                notificationConnectorPool.release(connection, connector);
            }
            ConfigurationNode response = new ConfigurationNode(API_CHECKRESULTNODE);
            response.setValue(results);
            output.addChild(output.getChildCount(), response);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int apiReadOutputConnectionInfo(IThreadContext tc, Configuration output, String connectionName, String command) throws ManifoldCFException {
        int n;
        IOutputConnectorPool outputConnectorPool = OutputConnectorPoolFactory.make((IThreadContext)tc);
        IOutputConnectionManager connectionManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
        IOutputConnection connection = connectionManager.load(connectionName);
        if (connection == null) {
            ManifoldCF.createErrorNode((Configuration)output, (String)("Connection '" + connectionName + "' does not exist"));
            return 0;
        }
        IOutputConnector connector = outputConnectorPool.grab(connection);
        try {
            n = connector.requestInfo(output, command) ? 1 : 0;
        }
        catch (Throwable throwable) {
            try {
                outputConnectorPool.release(connection, connector);
                throw throwable;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
        }
        outputConnectorPool.release(connection, connector);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int apiReadTransformationConnectionInfo(IThreadContext tc, Configuration output, String connectionName, String command) throws ManifoldCFException {
        int n;
        ITransformationConnectorPool transformationConnectorPool = TransformationConnectorPoolFactory.make((IThreadContext)tc);
        ITransformationConnectionManager connectionManager = TransformationConnectionManagerFactory.make((IThreadContext)tc);
        ITransformationConnection connection = connectionManager.load(connectionName);
        if (connection == null) {
            ManifoldCF.createErrorNode((Configuration)output, (String)("Connection '" + connectionName + "' does not exist"));
            return 0;
        }
        ITransformationConnector connector = transformationConnectorPool.grab(connection);
        try {
            n = connector.requestInfo(output, command) ? 1 : 0;
        }
        catch (Throwable throwable) {
            try {
                transformationConnectorPool.release(connection, connector);
                throw throwable;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
        }
        transformationConnectorPool.release(connection, connector);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int apiReadRepositoryConnectionInfo(IThreadContext tc, Configuration output, String connectionName, String command) throws ManifoldCFException {
        int n;
        IRepositoryConnectorPool repositoryConnectorPool = RepositoryConnectorPoolFactory.make(tc);
        IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(tc);
        IRepositoryConnection connection = connectionManager.load(connectionName);
        if (connection == null) {
            ManifoldCF.createErrorNode((Configuration)output, (String)("Connection '" + connectionName + "' does not exist"));
            return 0;
        }
        IRepositoryConnector connector = repositoryConnectorPool.grab(connection);
        try {
            n = connector.requestInfo(output, command) ? 1 : 0;
        }
        catch (Throwable throwable) {
            try {
                repositoryConnectorPool.release(connection, connector);
                throw throwable;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
        }
        repositoryConnectorPool.release(connection, connector);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int apiReadNotificationConnectionInfo(IThreadContext tc, Configuration output, String connectionName, String command) throws ManifoldCFException {
        int n;
        INotificationConnectorPool notificationConnectorPool = NotificationConnectorPoolFactory.make(tc);
        INotificationConnectionManager connectionManager = NotificationConnectionManagerFactory.make(tc);
        INotificationConnection connection = connectionManager.load(connectionName);
        if (connection == null) {
            ManifoldCF.createErrorNode((Configuration)output, (String)("Connection '" + connectionName + "' does not exist"));
            return 0;
        }
        INotificationConnector connector = notificationConnectorPool.grab(connection);
        try {
            n = connector.requestInfo(output, command) ? 1 : 0;
        }
        catch (Throwable throwable) {
            try {
                notificationConnectorPool.release(connection, connector);
                throw throwable;
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
        }
        notificationConnectorPool.release(connection, connector);
        return n;
    }

    protected static int apiReadJobStatuses(IThreadContext tc, Configuration output, Map<String, List<String>> queryParameters) throws ManifoldCFException {
        int maxCount;
        List<String> maxCountList;
        if (queryParameters == null) {
            queryParameters = new HashMap<String, List<String>>();
        }
        if ((maxCountList = queryParameters.get("maxcount")) == null || maxCountList.size() == 0) {
            maxCount = Integer.MAX_VALUE;
        } else {
            if (maxCountList.size() > 1) {
                throw new ManifoldCFException("Multiple values for maxcount parameter");
            }
            maxCount = new Integer(maxCountList.get(0));
        }
        try {
            IJobManager jobManager = JobManagerFactory.make(tc);
            JobStatus[] jobStatuses = jobManager.getAllStatus(true, maxCount);
            int i = 0;
            while (i < jobStatuses.length) {
                ConfigurationNode jobStatusNode = new ConfigurationNode(API_JOBSTATUSNODE);
                ManifoldCF.formatJobStatus(jobStatusNode, jobStatuses[i++]);
                output.addChild(output.getChildCount(), jobStatusNode);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadJobStatusesNoCounts(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            IJobManager jobManager = JobManagerFactory.make(tc);
            JobStatus[] jobStatuses = jobManager.getAllStatus(false);
            int i = 0;
            while (i < jobStatuses.length) {
                ConfigurationNode jobStatusNode = new ConfigurationNode(API_JOBSTATUSNODE);
                ManifoldCF.formatJobStatus(jobStatusNode, jobStatuses[i++]);
                output.addChild(output.getChildCount(), jobStatusNode);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadJobStatus(IThreadContext tc, Configuration output, Long jobID, Map<String, List<String>> queryParameters) throws ManifoldCFException {
        int maxCount;
        List<String> maxCountList;
        if (queryParameters == null) {
            queryParameters = new HashMap<String, List<String>>();
        }
        if ((maxCountList = queryParameters.get("maxcount")) == null || maxCountList.size() == 0) {
            maxCount = Integer.MAX_VALUE;
        } else {
            if (maxCountList.size() > 1) {
                throw new ManifoldCFException("Multiple values for maxcount parameter");
            }
            maxCount = new Integer(maxCountList.get(0));
        }
        try {
            IJobManager jobManager = JobManagerFactory.make(tc);
            JobStatus status = jobManager.getStatus(jobID, true, maxCount);
            if (status != null) {
                ConfigurationNode jobStatusNode = new ConfigurationNode(API_JOBSTATUSNODE);
                ManifoldCF.formatJobStatus(jobStatusNode, status);
                output.addChild(output.getChildCount(), jobStatusNode);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadJobStatusNoCounts(IThreadContext tc, Configuration output, Long jobID) throws ManifoldCFException {
        try {
            IJobManager jobManager = JobManagerFactory.make(tc);
            JobStatus status = jobManager.getStatus(jobID, false);
            if (status != null) {
                ConfigurationNode jobStatusNode = new ConfigurationNode(API_JOBSTATUSNODE);
                ManifoldCF.formatJobStatus(jobStatusNode, status);
                output.addChild(output.getChildCount(), jobStatusNode);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadAuthorityGroups(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            IAuthorityGroupManager groupManager = AuthorityGroupManagerFactory.make(tc);
            IAuthorityGroup[] groups = groupManager.getAllGroups();
            int i = 0;
            while (i < groups.length) {
                ConfigurationNode groupNode = new ConfigurationNode(API_AUTHORITYGROUPNODE);
                ManifoldCF.formatAuthorityGroup(groupNode, groups[i++]);
                output.addChild(output.getChildCount(), groupNode);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadAuthorityGroup(IThreadContext tc, Configuration output, String groupName) throws ManifoldCFException {
        try {
            IAuthorityGroupManager groupManager = AuthorityGroupManagerFactory.make(tc);
            IAuthorityGroup group = groupManager.load(groupName);
            if (group == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)("Authority group '" + groupName + "' does not exist."));
                return 0;
            }
            ConfigurationNode groupNode = new ConfigurationNode(API_AUTHORITYGROUPNODE);
            ManifoldCF.formatAuthorityGroup(groupNode, group);
            output.addChild(output.getChildCount(), groupNode);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadOutputConnections(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            IOutputConnectionManager connManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
            IOutputConnection[] connections = connManager.getAllConnections();
            int i = 0;
            while (i < connections.length) {
                ConfigurationNode connectionNode = new ConfigurationNode(API_OUTPUTCONNECTIONNODE);
                ManifoldCF.formatOutputConnection(connectionNode, connections[i++]);
                output.addChild(output.getChildCount(), connectionNode);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadOutputConnection(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            IOutputConnectionManager connectionManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
            IOutputConnection connection = connectionManager.load(connectionName);
            if (connection == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)("Connection '" + connectionName + "' does not exist."));
                return 0;
            }
            ConfigurationNode connectionNode = new ConfigurationNode(API_OUTPUTCONNECTIONNODE);
            ManifoldCF.formatOutputConnection(connectionNode, connection);
            output.addChild(output.getChildCount(), connectionNode);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadTransformationConnections(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            ITransformationConnectionManager connManager = TransformationConnectionManagerFactory.make((IThreadContext)tc);
            ITransformationConnection[] connections = connManager.getAllConnections();
            int i = 0;
            while (i < connections.length) {
                ConfigurationNode connectionNode = new ConfigurationNode(API_TRANSFORMATIONCONNECTIONNODE);
                ManifoldCF.formatTransformationConnection(connectionNode, connections[i++]);
                output.addChild(output.getChildCount(), connectionNode);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadTransformationConnection(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            ITransformationConnectionManager connectionManager = TransformationConnectionManagerFactory.make((IThreadContext)tc);
            ITransformationConnection connection = connectionManager.load(connectionName);
            if (connection == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)("Connection '" + connectionName + "' does not exist."));
                return 0;
            }
            ConfigurationNode connectionNode = new ConfigurationNode(API_TRANSFORMATIONCONNECTIONNODE);
            ManifoldCF.formatTransformationConnection(connectionNode, connection);
            output.addChild(output.getChildCount(), connectionNode);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadAuthorityConnections(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            IAuthorityConnectionManager connManager = AuthorityConnectionManagerFactory.make(tc);
            IAuthorityConnection[] connections = connManager.getAllConnections();
            int i = 0;
            while (i < connections.length) {
                ConfigurationNode connectionNode = new ConfigurationNode(API_AUTHORITYCONNECTIONNODE);
                ManifoldCF.formatAuthorityConnection(connectionNode, connections[i++]);
                output.addChild(output.getChildCount(), connectionNode);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadMappingConnections(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            IMappingConnectionManager connManager = MappingConnectionManagerFactory.make(tc);
            IMappingConnection[] connections = connManager.getAllConnections();
            int i = 0;
            while (i < connections.length) {
                ConfigurationNode connectionNode = new ConfigurationNode(API_MAPPINGCONNECTIONNODE);
                ManifoldCF.formatMappingConnection(connectionNode, connections[i++]);
                output.addChild(output.getChildCount(), connectionNode);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadAuthorityConnection(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            IAuthorityConnectionManager connectionManager = AuthorityConnectionManagerFactory.make(tc);
            IAuthorityConnection connection = connectionManager.load(connectionName);
            if (connection == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)("Authority connection '" + connectionName + "' does not exist."));
                return 0;
            }
            ConfigurationNode connectionNode = new ConfigurationNode(API_AUTHORITYCONNECTIONNODE);
            ManifoldCF.formatAuthorityConnection(connectionNode, connection);
            output.addChild(output.getChildCount(), connectionNode);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadMappingConnection(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            IMappingConnectionManager connectionManager = MappingConnectionManagerFactory.make(tc);
            IMappingConnection connection = connectionManager.load(connectionName);
            if (connection == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)("Mapping connection '" + connectionName + "' does not exist."));
                return 0;
            }
            ConfigurationNode connectionNode = new ConfigurationNode(API_MAPPINGCONNECTIONNODE);
            ManifoldCF.formatMappingConnection(connectionNode, connection);
            output.addChild(output.getChildCount(), connectionNode);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadRepositoryConnections(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            IRepositoryConnectionManager connManager = RepositoryConnectionManagerFactory.make(tc);
            IRepositoryConnection[] connections = connManager.getAllConnections();
            int i = 0;
            while (i < connections.length) {
                ConfigurationNode connectionNode = new ConfigurationNode(API_REPOSITORYCONNECTIONNODE);
                ManifoldCF.formatRepositoryConnection(connectionNode, connections[i++]);
                output.addChild(output.getChildCount(), connectionNode);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadRepositoryConnection(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(tc);
            IRepositoryConnection connection = connectionManager.load(connectionName);
            if (connection == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)("Repository connection '" + connectionName + "' does not exist"));
                return 0;
            }
            ConfigurationNode connectionNode = new ConfigurationNode(API_REPOSITORYCONNECTIONNODE);
            ManifoldCF.formatRepositoryConnection(connectionNode, connection);
            output.addChild(output.getChildCount(), connectionNode);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadNotificationConnections(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            INotificationConnectionManager connManager = NotificationConnectionManagerFactory.make(tc);
            INotificationConnection[] connections = connManager.getAllConnections();
            int i = 0;
            while (i < connections.length) {
                ConfigurationNode connectionNode = new ConfigurationNode(API_NOTIFICATIONCONNECTIONNODE);
                ManifoldCF.formatNotificationConnection(connectionNode, connections[i++]);
                output.addChild(output.getChildCount(), connectionNode);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadNotificationConnection(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            INotificationConnectionManager connectionManager = NotificationConnectionManagerFactory.make(tc);
            INotificationConnection connection = connectionManager.load(connectionName);
            if (connection == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)("Notification connection '" + connectionName + "' does not exist"));
                return 0;
            }
            ConfigurationNode connectionNode = new ConfigurationNode(API_NOTIFICATIONCONNECTIONNODE);
            ManifoldCF.formatNotificationConnection(connectionNode, connection);
            output.addChild(output.getChildCount(), connectionNode);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadOutputConnectors(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            IOutputConnectorManager manager = OutputConnectorManagerFactory.make((IThreadContext)tc);
            IResultSet resultSet = manager.getConnectors();
            int j = 0;
            while (j < resultSet.getRowCount()) {
                ConfigurationNode node;
                IResultRow row = resultSet.getRow(j++);
                ConfigurationNode child = new ConfigurationNode("outputconnector");
                String description = (String)row.getValue("description");
                String className = (String)row.getValue("classname");
                if (description != null) {
                    node = new ConfigurationNode("description");
                    node.setValue(description);
                    child.addChild(child.getChildCount(), node);
                }
                node = new ConfigurationNode("class_name");
                node.setValue(className);
                child.addChild(child.getChildCount(), node);
                output.addChild(output.getChildCount(), child);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadTransformationConnectors(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            ITransformationConnectorManager manager = TransformationConnectorManagerFactory.make((IThreadContext)tc);
            IResultSet resultSet = manager.getConnectors();
            int j = 0;
            while (j < resultSet.getRowCount()) {
                ConfigurationNode node;
                IResultRow row = resultSet.getRow(j++);
                ConfigurationNode child = new ConfigurationNode("transformationconnector");
                String description = (String)row.getValue("description");
                String className = (String)row.getValue("classname");
                if (description != null) {
                    node = new ConfigurationNode("description");
                    node.setValue(description);
                    child.addChild(child.getChildCount(), node);
                }
                node = new ConfigurationNode("class_name");
                node.setValue(className);
                child.addChild(child.getChildCount(), node);
                output.addChild(output.getChildCount(), child);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadAuthorityConnectors(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            IAuthorityConnectorManager manager = AuthorityConnectorManagerFactory.make(tc);
            IResultSet resultSet = manager.getConnectors();
            int j = 0;
            while (j < resultSet.getRowCount()) {
                ConfigurationNode node;
                IResultRow row = resultSet.getRow(j++);
                ConfigurationNode child = new ConfigurationNode("authorityconnector");
                String description = (String)row.getValue("description");
                String className = (String)row.getValue("classname");
                if (description != null) {
                    node = new ConfigurationNode("description");
                    node.setValue(description);
                    child.addChild(child.getChildCount(), node);
                }
                node = new ConfigurationNode("class_name");
                node.setValue(className);
                child.addChild(child.getChildCount(), node);
                output.addChild(output.getChildCount(), child);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadMappingConnectors(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            IMappingConnectorManager manager = MappingConnectorManagerFactory.make(tc);
            IResultSet resultSet = manager.getConnectors();
            int j = 0;
            while (j < resultSet.getRowCount()) {
                ConfigurationNode node;
                IResultRow row = resultSet.getRow(j++);
                ConfigurationNode child = new ConfigurationNode("mappingconnector");
                String description = (String)row.getValue("description");
                String className = (String)row.getValue("classname");
                if (description != null) {
                    node = new ConfigurationNode("description");
                    node.setValue(description);
                    child.addChild(child.getChildCount(), node);
                }
                node = new ConfigurationNode("class_name");
                node.setValue(className);
                child.addChild(child.getChildCount(), node);
                output.addChild(output.getChildCount(), child);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadAuthorizationDomains(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            IAuthorizationDomainManager manager = AuthorizationDomainManagerFactory.make(tc);
            IResultSet resultSet = manager.getDomains();
            int j = 0;
            while (j < resultSet.getRowCount()) {
                ConfigurationNode node;
                IResultRow row = resultSet.getRow(j++);
                ConfigurationNode child = new ConfigurationNode("authorizationdomain");
                String description = (String)row.getValue("description");
                String domainName = (String)row.getValue("domainname");
                if (description != null) {
                    node = new ConfigurationNode("description");
                    node.setValue(description);
                    child.addChild(child.getChildCount(), node);
                }
                node = new ConfigurationNode(AUTHORIZATIONDOMAINNODE_DOMAINNAME);
                node.setValue(domainName);
                child.addChild(child.getChildCount(), node);
                output.addChild(output.getChildCount(), child);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadRepositoryConnectors(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            IConnectorManager manager = ConnectorManagerFactory.make(tc);
            IResultSet resultSet = manager.getConnectors();
            int j = 0;
            while (j < resultSet.getRowCount()) {
                ConfigurationNode node;
                IResultRow row = resultSet.getRow(j++);
                ConfigurationNode child = new ConfigurationNode("repositoryconnector");
                String description = (String)row.getValue("description");
                String className = (String)row.getValue("classname");
                if (description != null) {
                    node = new ConfigurationNode("description");
                    node.setValue(description);
                    child.addChild(child.getChildCount(), node);
                }
                node = new ConfigurationNode("class_name");
                node.setValue(className);
                child.addChild(child.getChildCount(), node);
                output.addChild(output.getChildCount(), child);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadNotificationConnectors(IThreadContext tc, Configuration output) throws ManifoldCFException {
        try {
            IConnectorManager manager = ConnectorManagerFactory.make(tc);
            IResultSet resultSet = manager.getConnectors();
            int j = 0;
            while (j < resultSet.getRowCount()) {
                ConfigurationNode node;
                IResultRow row = resultSet.getRow(j++);
                ConfigurationNode child = new ConfigurationNode("notificationconnector");
                String description = (String)row.getValue("description");
                String className = (String)row.getValue("classname");
                if (description != null) {
                    node = new ConfigurationNode("description");
                    node.setValue(description);
                    child.addChild(child.getChildCount(), node);
                }
                node = new ConfigurationNode("class_name");
                node.setValue(className);
                child.addChild(child.getChildCount(), node);
                output.addChild(output.getChildCount(), child);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadRepositoryConnectionQueue(IThreadContext tc, Configuration output, String connectionName, Map<String, List<String>> queryParameters) throws ManifoldCFException {
        String[] resultColumns;
        IResultSet result;
        String reportType;
        int rowCount;
        int startRow;
        List<String> startRowList;
        int[] matchStatuses;
        int[] matchStates;
        RegExpCriteria idMatch;
        boolean isInsensitiveIdMatch;
        long now;
        Long[] jobs;
        List<String> jobList;
        if (queryParameters == null) {
            queryParameters = new HashMap<String, List<String>>();
        }
        if ((jobList = queryParameters.get(API_JOBNODE)) == null) {
            jobs = new Long[]{};
        } else {
            jobs = new Long[jobList.size()];
            for (int i = 0; i < jobs.length; ++i) {
                jobs[i] = new Long(jobList.get(i));
            }
        }
        List<String> nowList = queryParameters.get("now");
        if (nowList == null || nowList.size() == 0) {
            now = System.currentTimeMillis();
        } else {
            if (nowList.size() > 1) {
                throw new ManifoldCFException("Multiple values for now parameter");
            }
            now = new Long(nowList.get(0));
        }
        List<String> idMatchList = queryParameters.get("idmatch");
        List<String> idMatchInsensitiveList = queryParameters.get("idmatch_insensitive");
        if (idMatchList != null && idMatchInsensitiveList != null) {
            throw new ManifoldCFException("Either use idmatch or idmatch_insensitive, not both.");
        }
        if (idMatchInsensitiveList != null) {
            idMatchList = idMatchInsensitiveList;
            isInsensitiveIdMatch = true;
        } else {
            isInsensitiveIdMatch = false;
        }
        if (idMatchList == null || idMatchList.size() == 0) {
            idMatch = null;
        } else {
            if (idMatchList.size() > 1) {
                throw new ManifoldCFException("Multiple id match regexps specified.");
            }
            idMatch = new RegExpCriteria(idMatchList.get(0), isInsensitiveIdMatch);
        }
        List<String> stateMatchList = queryParameters.get("statematch");
        if (stateMatchList == null) {
            matchStates = new int[]{};
        } else {
            matchStates = new int[stateMatchList.size()];
            for (int i = 0; i < matchStates.length; ++i) {
                Integer value = docState.get(stateMatchList.get(i));
                if (value == null) {
                    throw new ManifoldCFException("Unrecognized state value: '" + stateMatchList.get(i) + "'");
                }
                matchStates[i] = value;
            }
        }
        List<String> statusMatchList = queryParameters.get("statusmatch");
        if (statusMatchList == null) {
            matchStatuses = new int[]{};
        } else {
            matchStatuses = new int[statusMatchList.size()];
            for (int i = 0; i < matchStatuses.length; ++i) {
                Integer value = docStatus.get(statusMatchList.get(i));
                if (value == null) {
                    throw new ManifoldCFException("Unrecognized status value: '" + statusMatchList.get(i) + "'");
                }
                matchStatuses[i] = value;
            }
        }
        StatusFilterCriteria filterCriteria = new StatusFilterCriteria(jobs, now, idMatch, matchStates, matchStatuses);
        SortOrder sortOrder = new SortOrder();
        List<String> sortColumnsList = queryParameters.get("sortcolumn");
        List<String> sortColumnsDirList = queryParameters.get("sortcolumn_direction");
        if (sortColumnsList != null || sortColumnsDirList != null) {
            if (sortColumnsList == null || sortColumnsDirList == null || sortColumnsList.size() != sortColumnsDirList.size()) {
                throw new ManifoldCFException("sortcolumn and sortcolumn_direction must have the same cardinality.");
            }
            for (int i = 0; i < sortColumnsList.size(); ++i) {
                int dirInt;
                String column = sortColumnsList.get(i);
                String dir = sortColumnsDirList.get(i);
                if (dir.equals("ascending")) {
                    dirInt = 0;
                } else if (dir.equals("descending")) {
                    dirInt = 1;
                } else {
                    throw new ManifoldCFException("sortcolumn_direction must be 'ascending' or 'descending'.");
                }
                sortOrder.addCriteria(column, dirInt);
            }
        }
        if ((startRowList = queryParameters.get("startrow")) == null || startRowList.size() == 0) {
            startRow = 0;
        } else {
            if (startRowList.size() > 1) {
                throw new ManifoldCFException("Multiple start rows specified.");
            }
            startRow = new Integer(startRowList.get(0));
        }
        List<String> rowCountList = queryParameters.get("rowcount");
        if (rowCountList == null || rowCountList.size() == 0) {
            rowCount = 20;
        } else {
            if (rowCountList.size() > 1) {
                throw new ManifoldCFException("Multiple row counts specified.");
            }
            rowCount = new Integer(rowCountList.get(0));
        }
        List<String> reportTypeList = queryParameters.get("report");
        if (reportTypeList == null || reportTypeList.size() == 0) {
            reportType = "document";
        } else {
            if (reportTypeList.size() > 1) {
                throw new ManifoldCFException("Multiple report types specified.");
            }
            reportType = reportTypeList.get(0);
        }
        IJobManager jobManager = JobManagerFactory.make(tc);
        if (reportType.equals("document")) {
            try {
                result = jobManager.genDocumentStatus(connectionName, filterCriteria, sortOrder, startRow, rowCount);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
            resultColumns = new String[]{"identifier", API_JOBNODE, "state", JOBSTATUSNODE_STATUS, "scheduled", "action", "retrycount", "retrylimit"};
        } else if (reportType.equals(JOBSTATUSNODE_STATUS)) {
            BucketDescription idBucket;
            boolean isInsensitiveIdBucket;
            List<String> idBucketList = queryParameters.get("idbucket");
            List<String> idBucketInsensitiveList = queryParameters.get("idbucket_insensitive");
            if (idBucketList != null && idBucketInsensitiveList != null) {
                throw new ManifoldCFException("Either use idbucket or idbucket_insensitive, not both.");
            }
            if (idBucketInsensitiveList != null) {
                idBucketList = idBucketInsensitiveList;
                isInsensitiveIdBucket = true;
            } else {
                isInsensitiveIdBucket = false;
            }
            if (idBucketList == null || idBucketList.size() == 0) {
                idBucket = new BucketDescription("()", false);
            } else {
                if (idBucketList.size() > 1) {
                    throw new ManifoldCFException("Multiple idbucket regexps specified.");
                }
                idBucket = new BucketDescription(idBucketList.get(0), isInsensitiveIdBucket);
            }
            try {
                result = jobManager.genQueueStatus(connectionName, filterCriteria, sortOrder, idBucket, startRow, rowCount);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
            resultColumns = new String[]{"idbucket", "inactive", "processing", "expiring", "deleting", "processready", "expireready", "processwaiting", "expirewaiting", "waitingforever", "hopcountexceeded"};
        } else {
            throw new ManifoldCFException("Unknown report type '" + reportType + "'.");
        }
        ManifoldCF.createResultsetNode(output, result, resultColumns);
        return 1;
    }

    protected static int apiReadRepositoryConnectionJobs(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            IJobManager jobManager = JobManagerFactory.make(tc);
            IJobDescription[] jobs = jobManager.findJobsForConnection(connectionName);
            if (jobs == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)("Unknown connection '" + connectionName + "'"));
                return 0;
            }
            int i = 0;
            while (i < jobs.length) {
                ConfigurationNode jobNode = new ConfigurationNode(API_JOBNODE);
                ManifoldCF.formatJobDescription(jobNode, jobs[i++]);
                output.addChild(output.getChildCount(), jobNode);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiReadRepositoryConnectionHistory(IThreadContext tc, Configuration output, String connectionName, Map<String, List<String>> queryParameters) throws ManifoldCFException {
        String[] resultColumns;
        IResultSet result;
        String reportType;
        int rowCount;
        int startRow;
        List<String> startRowList;
        RegExpCriteria resultCodeMatch;
        boolean isInsensitiveResultCodeMatch;
        RegExpCriteria entityMatch;
        boolean isInsensitiveEntityMatch;
        Long endTime;
        Long startTime;
        List<String> startTimeList;
        if (queryParameters == null) {
            queryParameters = new HashMap<String, List<String>>();
        }
        if ((startTimeList = queryParameters.get("starttime")) == null || startTimeList.size() == 0) {
            startTime = null;
        } else {
            if (startTimeList.size() > 1) {
                throw new ManifoldCFException("Multiple start times specified.");
            }
            startTime = new Long(startTimeList.get(0));
        }
        List<String> endTimeList = queryParameters.get("endtime");
        if (endTimeList == null || endTimeList.size() == 0) {
            endTime = null;
        } else {
            if (endTimeList.size() > 1) {
                throw new ManifoldCFException("Multiple end times specified.");
            }
            endTime = new Long(endTimeList.get(0));
        }
        List<String> activityList = queryParameters.get(API_ACTIVITYNODE);
        String[] activities = activityList == null ? new String[]{} : activityList.toArray(new String[0]);
        List<String> entityMatchList = queryParameters.get("entitymatch");
        List<String> entityMatchInsensitiveList = queryParameters.get("entitymatch_insensitive");
        if (entityMatchList != null && entityMatchInsensitiveList != null) {
            throw new ManifoldCFException("Either use entitymatch or entitymatch_insensitive, not both.");
        }
        if (entityMatchInsensitiveList != null) {
            entityMatchList = entityMatchInsensitiveList;
            isInsensitiveEntityMatch = true;
        } else {
            isInsensitiveEntityMatch = false;
        }
        if (entityMatchList == null || entityMatchList.size() == 0) {
            entityMatch = null;
        } else {
            if (entityMatchList.size() > 1) {
                throw new ManifoldCFException("Multiple entity match regexps specified.");
            }
            entityMatch = new RegExpCriteria(entityMatchList.get(0), isInsensitiveEntityMatch);
        }
        List<String> resultCodeMatchList = queryParameters.get("resultcodematch");
        List<String> resultCodeMatchInsensitiveList = queryParameters.get("resultcodematch_insensitive");
        if (resultCodeMatchList != null && resultCodeMatchInsensitiveList != null) {
            throw new ManifoldCFException("Either use resultcodematch or resultcodematch_insensitive, not both.");
        }
        if (entityMatchInsensitiveList != null) {
            resultCodeMatchList = resultCodeMatchInsensitiveList;
            isInsensitiveResultCodeMatch = true;
        } else {
            isInsensitiveResultCodeMatch = false;
        }
        if (resultCodeMatchList == null || resultCodeMatchList.size() == 0) {
            resultCodeMatch = null;
        } else {
            if (resultCodeMatchList.size() > 1) {
                throw new ManifoldCFException("Multiple resultcode match regexps specified.");
            }
            resultCodeMatch = new RegExpCriteria(resultCodeMatchList.get(0), isInsensitiveResultCodeMatch);
        }
        FilterCriteria filterCriteria = new FilterCriteria(activities, startTime, endTime, entityMatch, resultCodeMatch);
        SortOrder sortOrder = new SortOrder();
        List<String> sortColumnsList = queryParameters.get("sortcolumn");
        List<String> sortColumnsDirList = queryParameters.get("sortcolumn_direction");
        if (sortColumnsList != null || sortColumnsDirList != null) {
            if (sortColumnsList == null || sortColumnsDirList == null || sortColumnsList.size() != sortColumnsDirList.size()) {
                throw new ManifoldCFException("sortcolumn and sortcolumn_direction must have the same cardinality.");
            }
            for (int i = 0; i < sortColumnsList.size(); ++i) {
                int dirInt;
                String column = sortColumnsList.get(i);
                String dir = sortColumnsDirList.get(i);
                if (dir.equals("ascending")) {
                    dirInt = 0;
                } else if (dir.equals("descending")) {
                    dirInt = 1;
                } else {
                    throw new ManifoldCFException("sortcolumn_direction must be 'ascending' or 'descending'.");
                }
                sortOrder.addCriteria(column, dirInt);
            }
        }
        if ((startRowList = queryParameters.get("startrow")) == null || startRowList.size() == 0) {
            startRow = 0;
        } else {
            if (startRowList.size() > 1) {
                throw new ManifoldCFException("Multiple start rows specified.");
            }
            startRow = new Integer(startRowList.get(0));
        }
        List<String> rowCountList = queryParameters.get("rowcount");
        if (rowCountList == null || rowCountList.size() == 0) {
            rowCount = 20;
        } else {
            if (rowCountList.size() > 1) {
                throw new ManifoldCFException("Multiple row counts specified.");
            }
            rowCount = new Integer(rowCountList.get(0));
        }
        List<String> reportTypeList = queryParameters.get("report");
        if (reportTypeList == null || reportTypeList.size() == 0) {
            reportType = "simple";
        } else {
            if (reportTypeList.size() > 1) {
                throw new ManifoldCFException("Multiple report types specified.");
            }
            reportType = reportTypeList.get(0);
        }
        IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(tc);
        if (reportType.equals("simple")) {
            try {
                result = connectionManager.genHistorySimple(connectionName, filterCriteria, sortOrder, startRow, rowCount);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
            resultColumns = new String[]{"starttime", "resultcode", "resultdesc", "identifier", API_ACTIVITYNODE, "bytes", "elapsedtime"};
        } else if (reportType.equals("maxactivity")) {
            long interval;
            BucketDescription idBucket;
            boolean isInsensitiveIdBucket;
            long maxInterval = connectionManager.getMaxRows();
            long actualRows = connectionManager.countHistoryRows(connectionName, filterCriteria);
            if (actualRows > maxInterval) {
                throw new ManifoldCFException("Too many history rows specified for maxactivity report - actual is " + actualRows + ", max is " + maxInterval + ".");
            }
            List<String> idBucketList = queryParameters.get("idbucket");
            List<String> idBucketInsensitiveList = queryParameters.get("idbucket_insensitive");
            if (idBucketList != null && idBucketInsensitiveList != null) {
                throw new ManifoldCFException("Either use idbucket or idbucket_insensitive, not both.");
            }
            if (idBucketInsensitiveList != null) {
                idBucketList = idBucketInsensitiveList;
                isInsensitiveIdBucket = true;
            } else {
                isInsensitiveIdBucket = false;
            }
            if (idBucketList == null || idBucketList.size() == 0) {
                idBucket = new BucketDescription("()", false);
            } else {
                if (idBucketList.size() > 1) {
                    throw new ManifoldCFException("Multiple idbucket regexps specified.");
                }
                idBucket = new BucketDescription(idBucketList.get(0), isInsensitiveIdBucket);
            }
            List<String> intervalList = queryParameters.get("interval");
            if (intervalList == null || intervalList.size() == 0) {
                interval = 300000L;
            } else {
                if (intervalList.size() > 1) {
                    throw new ManifoldCFException("Multiple intervals specified.");
                }
                interval = new Long(intervalList.get(0));
            }
            try {
                result = connectionManager.genHistoryActivityCount(connectionName, filterCriteria, sortOrder, idBucket, interval, startRow, rowCount);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
            resultColumns = new String[]{"starttime", "endtime", "activitycount", "idbucket"};
        } else if (reportType.equals("maxbandwidth")) {
            long interval;
            BucketDescription idBucket;
            boolean isInsensitiveIdBucket;
            long maxInterval = connectionManager.getMaxRows();
            long actualRows = connectionManager.countHistoryRows(connectionName, filterCriteria);
            if (actualRows > maxInterval) {
                throw new ManifoldCFException("Too many history rows specified for maxbandwidth report - actual is " + actualRows + ", max is " + maxInterval + ".");
            }
            List<String> idBucketList = queryParameters.get("idbucket");
            List<String> idBucketInsensitiveList = queryParameters.get("idbucket_insensitive");
            if (idBucketList != null && idBucketInsensitiveList != null) {
                throw new ManifoldCFException("Either use idbucket or idbucket_insensitive, not both.");
            }
            if (idBucketInsensitiveList != null) {
                idBucketList = idBucketInsensitiveList;
                isInsensitiveIdBucket = true;
            } else {
                isInsensitiveIdBucket = false;
            }
            if (idBucketList == null || idBucketList.size() == 0) {
                idBucket = new BucketDescription("()", false);
            } else {
                if (idBucketList.size() > 1) {
                    throw new ManifoldCFException("Multiple idbucket regexps specified.");
                }
                idBucket = new BucketDescription(idBucketList.get(0), isInsensitiveIdBucket);
            }
            List<String> intervalList = queryParameters.get("interval");
            if (intervalList == null || intervalList.size() == 0) {
                interval = 300000L;
            } else {
                if (intervalList.size() > 1) {
                    throw new ManifoldCFException("Multiple intervals specified.");
                }
                interval = new Long(intervalList.get(0));
            }
            try {
                result = connectionManager.genHistoryByteCount(connectionName, filterCriteria, sortOrder, idBucket, interval, startRow, rowCount);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
            resultColumns = new String[]{"starttime", "endtime", "bytecount", "idbucket"};
        } else if (reportType.equals("result")) {
            BucketDescription resultCodeBucket;
            boolean isInsensitiveResultCodeBucket;
            BucketDescription idBucket;
            boolean isInsensitiveIdBucket;
            List<String> idBucketList = queryParameters.get("idbucket");
            List<String> idBucketInsensitiveList = queryParameters.get("idbucket_insensitive");
            if (idBucketList != null && idBucketInsensitiveList != null) {
                throw new ManifoldCFException("Either use idbucket or idbucket_insensitive, not both.");
            }
            if (idBucketInsensitiveList != null) {
                idBucketList = idBucketInsensitiveList;
                isInsensitiveIdBucket = true;
            } else {
                isInsensitiveIdBucket = false;
            }
            if (idBucketList == null || idBucketList.size() == 0) {
                idBucket = new BucketDescription("()", false);
            } else {
                if (idBucketList.size() > 1) {
                    throw new ManifoldCFException("Multiple idbucket regexps specified.");
                }
                idBucket = new BucketDescription(idBucketList.get(0), isInsensitiveIdBucket);
            }
            List<String> resultCodeBucketList = queryParameters.get("resultcodebucket");
            List<String> resultCodeBucketInsensitiveList = queryParameters.get("resultcodebucket_insensitive");
            if (resultCodeBucketList != null && resultCodeBucketInsensitiveList != null) {
                throw new ManifoldCFException("Either use resultcodebucket or resultcodebucket_insensitive, not both.");
            }
            if (resultCodeBucketInsensitiveList != null) {
                resultCodeBucketList = resultCodeBucketInsensitiveList;
                isInsensitiveResultCodeBucket = true;
            } else {
                isInsensitiveResultCodeBucket = false;
            }
            if (resultCodeBucketList == null || resultCodeBucketList.size() == 0) {
                resultCodeBucket = new BucketDescription("(.*)", false);
            } else {
                if (resultCodeBucketList.size() > 1) {
                    throw new ManifoldCFException("Multiple resultcodebucket regexps specified.");
                }
                resultCodeBucket = new BucketDescription(resultCodeBucketList.get(0), isInsensitiveResultCodeBucket);
            }
            try {
                result = connectionManager.genHistoryResultCodes(connectionName, filterCriteria, sortOrder, resultCodeBucket, idBucket, startRow, rowCount);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
                return 1;
            }
            resultColumns = new String[]{"idbucket", "resultcodebucket", "eventcount"};
        } else {
            throw new ManifoldCFException("Unknown report type '" + reportType + "'.");
        }
        ManifoldCF.createResultsetNode(output, result, resultColumns);
        return 1;
    }

    protected static void createResultsetNode(Configuration output, IResultSet result, String[] resultColumns) throws ManifoldCFException {
        for (int i = 0; i < result.getRowCount(); ++i) {
            IResultRow row = result.getRow(i);
            ConfigurationNode rowValue = new ConfigurationNode(API_ROWNODE);
            for (String columnName : resultColumns) {
                ConfigurationNode columnValue = new ConfigurationNode(API_COLUMNNODE);
                Object value = row.getValue(columnName);
                String valueToUse = value == null ? "" : value.toString();
                ConfigurationNode nameNode = new ConfigurationNode("name");
                nameNode.setValue(columnName);
                columnValue.addChild(columnValue.getChildCount(), nameNode);
                ConfigurationNode valueNode = new ConfigurationNode("value");
                valueNode.setValue(valueToUse);
                columnValue.addChild(columnValue.getChildCount(), valueNode);
                rowValue.addChild(rowValue.getChildCount(), columnValue);
            }
            output.addChild(output.getChildCount(), rowValue);
        }
    }

    protected static int apiReadRepositoryConnectionActivities(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            String[] activities = ManifoldCF.getActivitiesList(tc, connectionName);
            if (activities == null) {
                ManifoldCF.createErrorNode((Configuration)output, (String)("Connection '" + connectionName + "' does not exist."));
                return 0;
            }
            for (String activity : activities) {
                ConfigurationNode node = new ConfigurationNode(API_ACTIVITYNODE);
                node.setValue(activity);
                output.addChild(output.getChildCount(), node);
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    public static int executeReadCommand(IThreadContext tc, Configuration output, String path, Map<String, List<String>> queryParameters) throws ManifoldCFException {
        if (path.equals("jobs")) {
            return ManifoldCF.apiReadJobs(tc, output);
        }
        if (path.startsWith("jobs/")) {
            Long jobID = new Long(path.substring("jobs/".length()));
            return ManifoldCF.apiReadJob(tc, output, jobID);
        }
        if (path.startsWith("repositoryconnectionactivities/")) {
            int firstSeparator = "repositoryconnectionactivities/".length();
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring(firstSeparator));
            return ManifoldCF.apiReadRepositoryConnectionActivities(tc, output, connectionName);
        }
        if (path.startsWith("repositoryconnectionhistory/")) {
            int firstSeparator = "repositoryconnectionhistory/".length();
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring(firstSeparator));
            return ManifoldCF.apiReadRepositoryConnectionHistory(tc, output, connectionName, queryParameters);
        }
        if (path.startsWith("repositoryconnectionqueue/")) {
            int firstSeparator = "repositoryconnectionqueue/".length();
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring(firstSeparator));
            return ManifoldCF.apiReadRepositoryConnectionQueue(tc, output, connectionName, queryParameters);
        }
        if (path.startsWith("repositoryconnectionjobs/")) {
            int firstSeparator = "repositoryconnectionjobs/".length();
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring(firstSeparator));
            return ManifoldCF.apiReadRepositoryConnectionJobs(tc, output, connectionName);
        }
        if (path.startsWith("status/")) {
            int firstSeparator = "status/".length();
            int secondSeparator = path.indexOf("/", firstSeparator);
            if (secondSeparator == -1) {
                ManifoldCF.createErrorNode((Configuration)output, (String)"Need connection name.");
                return 0;
            }
            String connectionType = path.substring(firstSeparator, secondSeparator);
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring(secondSeparator + 1));
            if (connectionType.equals("outputconnections")) {
                return ManifoldCF.apiReadOutputConnectionStatus(tc, output, connectionName);
            }
            if (connectionType.equals("transformationconnections")) {
                return ManifoldCF.apiReadTransformationConnectionStatus(tc, output, connectionName);
            }
            if (connectionType.equals("mappingconnections")) {
                return ManifoldCF.apiReadMappingConnectionStatus(tc, output, connectionName);
            }
            if (connectionType.equals("authorityconnections")) {
                return ManifoldCF.apiReadAuthorityConnectionStatus(tc, output, connectionName);
            }
            if (connectionType.equals("repositoryconnections")) {
                return ManifoldCF.apiReadRepositoryConnectionStatus(tc, output, connectionName);
            }
            if (connectionType.equals("notificationconnections")) {
                return ManifoldCF.apiReadNotificationConnectionStatus(tc, output, connectionName);
            }
            ManifoldCF.createErrorNode((Configuration)output, (String)("Unknown connection type '" + connectionType + "'."));
            return 0;
        }
        if (path.startsWith("info/")) {
            int firstSeparator = "info/".length();
            int secondSeparator = path.indexOf("/", firstSeparator);
            if (secondSeparator == -1) {
                ManifoldCF.createErrorNode((Configuration)output, (String)"Need connection type and connection name.");
                return 0;
            }
            int thirdSeparator = path.indexOf("/", secondSeparator + 1);
            if (thirdSeparator == -1) {
                ManifoldCF.createErrorNode((Configuration)output, (String)"Need connection name.");
                return 0;
            }
            String connectionType = path.substring(firstSeparator, secondSeparator);
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring(secondSeparator + 1, thirdSeparator));
            String command = path.substring(thirdSeparator + 1);
            if (connectionType.equals("outputconnections")) {
                return ManifoldCF.apiReadOutputConnectionInfo(tc, output, connectionName, command);
            }
            if (connectionType.equals("transformationconnections")) {
                return ManifoldCF.apiReadTransformationConnectionInfo(tc, output, connectionName, command);
            }
            if (connectionType.equals("repositoryconnections")) {
                return ManifoldCF.apiReadRepositoryConnectionInfo(tc, output, connectionName, command);
            }
            if (connectionType.equals("notificationconnections")) {
                return ManifoldCF.apiReadNotificationConnectionInfo(tc, output, connectionName, command);
            }
            ManifoldCF.createErrorNode((Configuration)output, (String)("Unknown connection type '" + connectionType + "'."));
            return 0;
        }
        if (path.equals("jobstatuses")) {
            return ManifoldCF.apiReadJobStatuses(tc, output, queryParameters);
        }
        if (path.startsWith("jobstatuses/")) {
            Long jobID = new Long(path.substring("jobstatuses/".length()));
            return ManifoldCF.apiReadJobStatus(tc, output, jobID, queryParameters);
        }
        if (path.equals("jobstatusesnocounts")) {
            return ManifoldCF.apiReadJobStatusesNoCounts(tc, output);
        }
        if (path.startsWith("jobstatusesnocounts/")) {
            Long jobID = new Long(path.substring("jobstatusesnocounts/".length()));
            return ManifoldCF.apiReadJobStatusNoCounts(tc, output, jobID);
        }
        if (path.equals("authoritygroups")) {
            return ManifoldCF.apiReadAuthorityGroups(tc, output);
        }
        if (path.startsWith("authoritygroups/")) {
            String groupName = ManifoldCF.decodeAPIPathElement(path.substring("authoritygroups/".length()));
            return ManifoldCF.apiReadAuthorityGroup(tc, output, groupName);
        }
        if (path.equals("outputconnections")) {
            return ManifoldCF.apiReadOutputConnections(tc, output);
        }
        if (path.startsWith("outputconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("outputconnections/".length()));
            return ManifoldCF.apiReadOutputConnection(tc, output, connectionName);
        }
        if (path.equals("transformationconnections")) {
            return ManifoldCF.apiReadTransformationConnections(tc, output);
        }
        if (path.startsWith("transformationconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("transformationconnections/".length()));
            return ManifoldCF.apiReadTransformationConnection(tc, output, connectionName);
        }
        if (path.equals("mappingconnections")) {
            return ManifoldCF.apiReadMappingConnections(tc, output);
        }
        if (path.startsWith("mappingconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("mappingconnections/".length()));
            return ManifoldCF.apiReadMappingConnection(tc, output, connectionName);
        }
        if (path.equals("authorityconnections")) {
            return ManifoldCF.apiReadAuthorityConnections(tc, output);
        }
        if (path.startsWith("authorityconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("authorityconnections/".length()));
            return ManifoldCF.apiReadAuthorityConnection(tc, output, connectionName);
        }
        if (path.equals("repositoryconnections")) {
            return ManifoldCF.apiReadRepositoryConnections(tc, output);
        }
        if (path.startsWith("repositoryconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("repositoryconnections/".length()));
            return ManifoldCF.apiReadRepositoryConnection(tc, output, connectionName);
        }
        if (path.equals("notificationconnections")) {
            return ManifoldCF.apiReadNotificationConnections(tc, output);
        }
        if (path.startsWith("notificationconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("notificationconnections/".length()));
            return ManifoldCF.apiReadNotificationConnection(tc, output, connectionName);
        }
        if (path.equals("outputconnectors")) {
            return ManifoldCF.apiReadOutputConnectors(tc, output);
        }
        if (path.equals("transformationconnectors")) {
            return ManifoldCF.apiReadTransformationConnectors(tc, output);
        }
        if (path.equals("mappingconnectors")) {
            return ManifoldCF.apiReadMappingConnectors(tc, output);
        }
        if (path.equals("authorityconnectors")) {
            return ManifoldCF.apiReadAuthorityConnectors(tc, output);
        }
        if (path.equals("repositoryconnectors")) {
            return ManifoldCF.apiReadRepositoryConnectors(tc, output);
        }
        if (path.equals("notificationconnectors")) {
            return ManifoldCF.apiReadNotificationConnectors(tc, output);
        }
        if (path.equals("authorizationdomains")) {
            return ManifoldCF.apiReadAuthorizationDomains(tc, output);
        }
        ManifoldCF.createErrorNode((Configuration)output, (String)"Unrecognized resource.");
        return 0;
    }

    protected static int apiPostJob(IThreadContext tc, Configuration output, Configuration input) throws ManifoldCFException {
        ConfigurationNode jobNode = ManifoldCF.findConfigurationNode((Configuration)input, (String)API_JOBNODE);
        if (jobNode == null) {
            throw new ManifoldCFException("Input must have 'job' field");
        }
        JobDescription job = new JobDescription();
        ManifoldCF.processJobDescription(job, jobNode);
        if (job.getID() != null) {
            throw new ManifoldCFException("Input job cannot supply an ID field for create");
        }
        try {
            Long jobID = new Long(IDFactory.make((IThreadContext)tc));
            job.setID(jobID);
            job.setIsNew(true);
            IJobManager jobManager = JobManagerFactory.make(tc);
            jobManager.save(job);
            ConfigurationNode idNode = new ConfigurationNode("job_id");
            idNode.setValue(jobID.toString());
            output.addChild(output.getChildCount(), idNode);
            return 2;
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            return 1;
        }
    }

    public static int executePostCommand(IThreadContext tc, Configuration output, String path, Configuration input) throws ManifoldCFException {
        if (path.equals("jobs")) {
            return ManifoldCF.apiPostJob(tc, output, input);
        }
        ManifoldCF.createErrorNode((Configuration)output, (String)"Unrecognized resource.");
        return 0;
    }

    protected static int apiWriteStartJob(IThreadContext tc, Configuration output, Long jobID, boolean requestMinimum) throws ManifoldCFException {
        try {
            IJobManager jobManager = JobManagerFactory.make(tc);
            jobManager.manualStart(jobID, requestMinimum);
            return 2;
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            return 1;
        }
    }

    protected static int apiWriteAbortJob(IThreadContext tc, Configuration output, Long jobID) throws ManifoldCFException {
        try {
            IJobManager jobManager = JobManagerFactory.make(tc);
            jobManager.manualAbort(jobID);
            return 2;
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            return 1;
        }
    }

    protected static int apiWriteRestartJob(IThreadContext tc, Configuration output, Long jobID, boolean requestMinimum) throws ManifoldCFException {
        try {
            IJobManager jobManager = JobManagerFactory.make(tc);
            jobManager.manualAbortRestart(jobID, requestMinimum);
            return 2;
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            return 1;
        }
    }

    protected static int apiWritePauseJob(IThreadContext tc, Configuration output, Long jobID) throws ManifoldCFException {
        try {
            IJobManager jobManager = JobManagerFactory.make(tc);
            jobManager.pauseJob(jobID);
            return 2;
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            return 1;
        }
    }

    protected static int apiWriteResumeJob(IThreadContext tc, Configuration output, Long jobID) throws ManifoldCFException {
        try {
            IJobManager jobManager = JobManagerFactory.make(tc);
            jobManager.restartJob(jobID);
            return 2;
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            return 1;
        }
    }

    protected static int apiWriteReseedJob(IThreadContext tc, Configuration output, Long jobID) throws ManifoldCFException {
        try {
            IJobManager jobManager = JobManagerFactory.make(tc);
            jobManager.clearJobSeedingState(jobID);
            return 2;
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            return 1;
        }
    }

    protected static int apiWriteJob(IThreadContext tc, Configuration output, Configuration input, Long jobID) throws ManifoldCFException {
        ConfigurationNode jobNode = ManifoldCF.findConfigurationNode((Configuration)input, (String)API_JOBNODE);
        if (jobNode == null) {
            throw new ManifoldCFException("Input must have 'job' field");
        }
        JobDescription job = new JobDescription();
        ManifoldCF.processJobDescription(job, jobNode);
        try {
            if (job.getID() == null) {
                job.setID(jobID);
            } else if (!job.getID().equals(jobID)) {
                throw new ManifoldCFException("Job identifier must agree within object and within path");
            }
            job.setIsNew(false);
            IJobManager jobManager = JobManagerFactory.make(tc);
            jobManager.save(job);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiWriteAuthorityGroup(IThreadContext tc, Configuration output, Configuration input, String groupName) throws ManifoldCFException {
        ConfigurationNode groupNode = ManifoldCF.findConfigurationNode((Configuration)input, (String)API_AUTHORITYGROUPNODE);
        if (groupNode == null) {
            throw new ManifoldCFException("Input argument must have 'authoritygroup' field");
        }
        AuthorityGroup authorityGroup = new AuthorityGroup();
        ManifoldCF.processAuthorityGroup(authorityGroup, groupNode);
        if (authorityGroup.getName() == null) {
            authorityGroup.setName(groupName);
        } else if (!authorityGroup.getName().equals(groupName)) {
            throw new ManifoldCFException("Authority group name in path and in object must agree");
        }
        try {
            IAuthorityGroupManager groupManager = AuthorityGroupManagerFactory.make(tc);
            if (groupManager.save(authorityGroup)) {
                return 2;
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiWriteOutputConnection(IThreadContext tc, Configuration output, Configuration input, String connectionName) throws ManifoldCFException {
        ConfigurationNode connectionNode = ManifoldCF.findConfigurationNode((Configuration)input, (String)API_OUTPUTCONNECTIONNODE);
        if (connectionNode == null) {
            throw new ManifoldCFException("Input argument must have 'outputconnection' field");
        }
        OutputConnection outputConnection = new OutputConnection();
        ManifoldCF.processOutputConnection(outputConnection, connectionNode);
        if (outputConnection.getName() == null) {
            outputConnection.setName(connectionName);
        } else if (!outputConnection.getName().equals(connectionName)) {
            throw new ManifoldCFException("Connection name in path and in object must agree");
        }
        try {
            IOutputConnectionManager connectionManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
            if (connectionManager.save((IOutputConnection)outputConnection)) {
                return 2;
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiWriteTransformationConnection(IThreadContext tc, Configuration output, Configuration input, String connectionName) throws ManifoldCFException {
        ConfigurationNode connectionNode = ManifoldCF.findConfigurationNode((Configuration)input, (String)API_TRANSFORMATIONCONNECTIONNODE);
        if (connectionNode == null) {
            throw new ManifoldCFException("Input argument must have 'transformationconnection' field");
        }
        TransformationConnection transformationConnection = new TransformationConnection();
        ManifoldCF.processTransformationConnection(transformationConnection, connectionNode);
        if (transformationConnection.getName() == null) {
            transformationConnection.setName(connectionName);
        } else if (!transformationConnection.getName().equals(connectionName)) {
            throw new ManifoldCFException("Connection name in path and in object must agree");
        }
        try {
            ITransformationConnectionManager connectionManager = TransformationConnectionManagerFactory.make((IThreadContext)tc);
            if (connectionManager.save((ITransformationConnection)transformationConnection)) {
                return 2;
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiWriteAuthorityConnection(IThreadContext tc, Configuration output, Configuration input, String connectionName) throws ManifoldCFException {
        ConfigurationNode connectionNode = ManifoldCF.findConfigurationNode((Configuration)input, (String)API_AUTHORITYCONNECTIONNODE);
        if (connectionNode == null) {
            throw new ManifoldCFException("Input argument must have 'authorityconnection' field");
        }
        AuthorityConnection authorityConnection = new AuthorityConnection();
        ManifoldCF.processAuthorityConnection(authorityConnection, connectionNode);
        if (authorityConnection.getName() == null) {
            authorityConnection.setName(connectionName);
        } else if (!authorityConnection.getName().equals(connectionName)) {
            throw new ManifoldCFException("Connection name in path and in object must agree");
        }
        try {
            IAuthorityConnectionManager connectionManager = AuthorityConnectionManagerFactory.make(tc);
            if (connectionManager.save(authorityConnection)) {
                return 2;
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiWriteMappingConnection(IThreadContext tc, Configuration output, Configuration input, String connectionName) throws ManifoldCFException {
        ConfigurationNode connectionNode = ManifoldCF.findConfigurationNode((Configuration)input, (String)API_MAPPINGCONNECTIONNODE);
        if (connectionNode == null) {
            throw new ManifoldCFException("Input argument must have 'mappingconnection' field");
        }
        MappingConnection mappingConnection = new MappingConnection();
        ManifoldCF.processMappingConnection(mappingConnection, connectionNode);
        if (mappingConnection.getName() == null) {
            mappingConnection.setName(connectionName);
        } else if (!mappingConnection.getName().equals(connectionName)) {
            throw new ManifoldCFException("Connection name in path and in object must agree");
        }
        try {
            IMappingConnectionManager connectionManager = MappingConnectionManagerFactory.make(tc);
            if (connectionManager.save(mappingConnection)) {
                return 2;
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiWriteRepositoryConnection(IThreadContext tc, Configuration output, Configuration input, String connectionName) throws ManifoldCFException {
        ConfigurationNode connectionNode = ManifoldCF.findConfigurationNode((Configuration)input, (String)API_REPOSITORYCONNECTIONNODE);
        if (connectionNode == null) {
            throw new ManifoldCFException("Input argument must have 'repositoryconnection' field");
        }
        RepositoryConnection repositoryConnection = new RepositoryConnection();
        ManifoldCF.processRepositoryConnection(repositoryConnection, connectionNode);
        if (repositoryConnection.getName() == null) {
            repositoryConnection.setName(connectionName);
        } else if (!repositoryConnection.getName().equals(connectionName)) {
            throw new ManifoldCFException("Connection name in path and in object must agree");
        }
        try {
            IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(tc);
            if (connectionManager.save(repositoryConnection)) {
                return 2;
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiWriteClearHistoryRepositoryConnection(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(tc);
            connectionManager.cleanUpHistoryData(connectionName);
            return 2;
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            return 1;
        }
    }

    protected static int apiWriteNotificationConnection(IThreadContext tc, Configuration output, Configuration input, String connectionName) throws ManifoldCFException {
        ConfigurationNode connectionNode = ManifoldCF.findConfigurationNode((Configuration)input, (String)API_NOTIFICATIONCONNECTIONNODE);
        if (connectionNode == null) {
            throw new ManifoldCFException("Input argument must have 'notificationconnection' field");
        }
        NotificationConnection notificationConnection = new NotificationConnection();
        ManifoldCF.processNotificationConnection(notificationConnection, connectionNode);
        if (notificationConnection.getName() == null) {
            notificationConnection.setName(connectionName);
        } else if (!notificationConnection.getName().equals(connectionName)) {
            throw new ManifoldCFException("Connection name in path and in object must agree");
        }
        try {
            INotificationConnectionManager connectionManager = NotificationConnectionManagerFactory.make(tc);
            if (connectionManager.save(notificationConnection)) {
                return 2;
            }
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiWriteClearVersionsOutputConnection(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            ManifoldCF.signalOutputConnectionRedo((IThreadContext)tc, (String)connectionName);
            return 2;
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            return 1;
        }
    }

    protected static int apiWriteClearOutputConnection(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            ManifoldCF.signalOutputConnectionRemoved((IThreadContext)tc, (String)connectionName);
            return 2;
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            return 1;
        }
    }

    public static int executeWriteCommand(IThreadContext tc, Configuration output, String path, Configuration input) throws ManifoldCFException {
        if (path.startsWith("start/")) {
            Long jobID = new Long(path.substring("start/".length()));
            return ManifoldCF.apiWriteStartJob(tc, output, jobID, false);
        }
        if (path.startsWith("startminimal/")) {
            Long jobID = new Long(path.substring("startminimal/".length()));
            return ManifoldCF.apiWriteStartJob(tc, output, jobID, true);
        }
        if (path.startsWith("abort/")) {
            Long jobID = new Long(path.substring("abort/".length()));
            return ManifoldCF.apiWriteAbortJob(tc, output, jobID);
        }
        if (path.startsWith("restart/")) {
            Long jobID = new Long(path.substring("restart/".length()));
            return ManifoldCF.apiWriteRestartJob(tc, output, jobID, false);
        }
        if (path.startsWith("restartminimal/")) {
            Long jobID = new Long(path.substring("restartminimal/".length()));
            return ManifoldCF.apiWriteRestartJob(tc, output, jobID, true);
        }
        if (path.startsWith("pause/")) {
            Long jobID = new Long(path.substring("pause/".length()));
            return ManifoldCF.apiWritePauseJob(tc, output, jobID);
        }
        if (path.startsWith("resume/")) {
            Long jobID = new Long(path.substring("resume/".length()));
            return ManifoldCF.apiWriteResumeJob(tc, output, jobID);
        }
        if (path.startsWith("reseed/")) {
            Long jobID = new Long(path.substring("reseed/".length()));
            return ManifoldCF.apiWriteReseedJob(tc, output, jobID);
        }
        if (path.startsWith("jobs/")) {
            Long jobID = new Long(path.substring("jobs/".length()));
            return ManifoldCF.apiWriteJob(tc, output, input, jobID);
        }
        if (path.startsWith("authoritygroups/")) {
            String groupName = ManifoldCF.decodeAPIPathElement(path.substring("authoritygroups/".length()));
            return ManifoldCF.apiWriteAuthorityGroup(tc, output, input, groupName);
        }
        if (path.startsWith("outputconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("outputconnections/".length()));
            return ManifoldCF.apiWriteOutputConnection(tc, output, input, connectionName);
        }
        if (path.startsWith("transformationconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("transformationconnections/".length()));
            return ManifoldCF.apiWriteTransformationConnection(tc, output, input, connectionName);
        }
        if (path.startsWith("mappingconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("mappingconnections/".length()));
            return ManifoldCF.apiWriteMappingConnection(tc, output, input, connectionName);
        }
        if (path.startsWith("authorityconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("authorityconnections/".length()));
            return ManifoldCF.apiWriteAuthorityConnection(tc, output, input, connectionName);
        }
        if (path.startsWith("repositoryconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("repositoryconnections/".length()));
            return ManifoldCF.apiWriteRepositoryConnection(tc, output, input, connectionName);
        }
        if (path.startsWith("notificationconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("notificationconnections/".length()));
            return ManifoldCF.apiWriteNotificationConnection(tc, output, input, connectionName);
        }
        if (path.startsWith("clearhistory/")) {
            int firstSeparator = "clearhistory/".length();
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring(firstSeparator));
            return ManifoldCF.apiWriteClearHistoryRepositoryConnection(tc, output, connectionName);
        }
        if (path.startsWith("reset/")) {
            int firstSeparator = "reset/".length();
            int secondSeparator = path.indexOf("/", firstSeparator);
            if (secondSeparator == -1) {
                ManifoldCF.createErrorNode((Configuration)output, (String)"Need connection name.");
                return 0;
            }
            String connectionType = path.substring(firstSeparator, secondSeparator);
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring(secondSeparator + 1));
            if (connectionType.equals("outputconnections")) {
                return ManifoldCF.apiWriteClearVersionsOutputConnection(tc, output, connectionName);
            }
            ManifoldCF.createErrorNode((Configuration)output, (String)("Unknown connection type '" + connectionType + "'."));
            return 0;
        }
        if (path.startsWith("clearversions/")) {
            int firstSeparator = "clearversions/".length();
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring(firstSeparator));
            return ManifoldCF.apiWriteClearVersionsOutputConnection(tc, output, connectionName);
        }
        if (path.startsWith("clearrecords/")) {
            int firstSeparator = "clearrecords/".length();
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring(firstSeparator));
            return ManifoldCF.apiWriteClearOutputConnection(tc, output, connectionName);
        }
        ManifoldCF.createErrorNode((Configuration)output, (String)"Unrecognized resource.");
        return 0;
    }

    protected static int apiDeleteJob(IThreadContext tc, Configuration output, Long jobID) throws ManifoldCFException {
        try {
            IJobManager jobManager = JobManagerFactory.make(tc);
            jobManager.deleteJob(jobID);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiDeleteAuthorityGroup(IThreadContext tc, Configuration output, String groupName) throws ManifoldCFException {
        try {
            IAuthorityGroupManager groupManager = AuthorityGroupManagerFactory.make(tc);
            groupManager.delete(groupName);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiDeleteOutputConnection(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            IOutputConnectionManager connectionManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
            connectionManager.delete(connectionName);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiDeleteAuthorityConnection(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            IAuthorityConnectionManager connectionManager = AuthorityConnectionManagerFactory.make(tc);
            connectionManager.delete(connectionName);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiDeleteRepositoryConnection(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(tc);
            connectionManager.delete(connectionName);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    protected static int apiDeleteNotificationConnection(IThreadContext tc, Configuration output, String connectionName) throws ManifoldCFException {
        try {
            INotificationConnectionManager connectionManager = NotificationConnectionManagerFactory.make(tc);
            connectionManager.delete(connectionName);
        }
        catch (ManifoldCFException e) {
            ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
        }
        return 1;
    }

    public static int executeDeleteCommand(IThreadContext tc, Configuration output, String path) throws ManifoldCFException {
        if (path.startsWith("jobs/")) {
            Long jobID = new Long(path.substring("jobs/".length()));
            return ManifoldCF.apiDeleteJob(tc, output, jobID);
        }
        if (path.startsWith("authoritygroups/")) {
            String groupName = ManifoldCF.decodeAPIPathElement(path.substring("authoritygroups/".length()));
            return ManifoldCF.apiDeleteAuthorityGroup(tc, output, groupName);
        }
        if (path.startsWith("outputconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("outputconnections/".length()));
            return ManifoldCF.apiDeleteOutputConnection(tc, output, connectionName);
        }
        if (path.startsWith("authorityconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("authorityconnections/".length()));
            return ManifoldCF.apiDeleteAuthorityConnection(tc, output, connectionName);
        }
        if (path.startsWith("repositoryconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("repositoryconnections/".length()));
            return ManifoldCF.apiDeleteRepositoryConnection(tc, output, connectionName);
        }
        if (path.startsWith("notificationconnections/")) {
            String connectionName = ManifoldCF.decodeAPIPathElement(path.substring("notificationconnections/".length()));
            return ManifoldCF.apiDeleteNotificationConnection(tc, output, connectionName);
        }
        ManifoldCF.createErrorNode((Configuration)output, (String)"Unrecognized resource.");
        return 0;
    }

    protected static void processJobDescription(JobDescription jobDescription, ConfigurationNode jobNode) throws ManifoldCFException {
        HashMap<String, PipelineStage> pipelineStages = new HashMap<String, PipelineStage>();
        for (int i = 0; i < jobNode.getChildCount(); ++i) {
            ConfigurationNode cn;
            ConfigurationNode child = jobNode.findChild(i);
            String childType = child.getType();
            if (childType.equals(JOBNODE_ID)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Job id node requires a value");
                }
                jobDescription.setID(new Long(child.getValue()));
                continue;
            }
            if (childType.equals("description")) {
                jobDescription.setDescription(child.getValue());
                continue;
            }
            if (childType.equals(JOBNODE_CONNECTIONNAME)) {
                jobDescription.setConnectionName(child.getValue());
                continue;
            }
            if (childType.equals(JOBNODE_PIPELINESTAGE)) {
                String stageID = null;
                String stagePrerequisite = null;
                String stageIsOutput = null;
                String stageConnectionName = null;
                String stageDescription = null;
                ConfigurationNode stageSpecification = null;
                for (int q = 0; q < child.getChildCount(); ++q) {
                    ConfigurationNode cn2 = child.findChild(q);
                    if (cn2.getType().equals(JOBNODE_STAGEID)) {
                        stageID = cn2.getValue();
                        continue;
                    }
                    if (cn2.getType().equals(JOBNODE_STAGEPREREQUISITE)) {
                        stagePrerequisite = cn2.getValue();
                        continue;
                    }
                    if (cn2.getType().equals(JOBNODE_STAGEISOUTPUT)) {
                        stageIsOutput = cn2.getValue();
                        continue;
                    }
                    if (cn2.getType().equals(JOBNODE_STAGECONNECTIONNAME)) {
                        stageConnectionName = cn2.getValue();
                        continue;
                    }
                    if (cn2.getType().equals(JOBNODE_STAGEDESCRIPTION)) {
                        stageDescription = cn2.getValue();
                        continue;
                    }
                    if (cn2.getType().equals(JOBNODE_STAGESPECIFICATION)) {
                        stageSpecification = cn2;
                        continue;
                    }
                    throw new ManifoldCFException("Found an unexpected node type: '" + cn2.getType() + "'");
                }
                if (stageID == null) {
                    throw new ManifoldCFException("Missing required field: 'stage_id'");
                }
                if (stageIsOutput == null) {
                    throw new ManifoldCFException("Missing required field: 'stage_isoutput'");
                }
                if (stageConnectionName == null) {
                    throw new ManifoldCFException("Missing required field: 'stage_connectionname'");
                }
                pipelineStages.put(stageID, new PipelineStage(stagePrerequisite, stageIsOutput.equals("true"), stageConnectionName, stageDescription, stageSpecification));
                continue;
            }
            if (childType.equals(JOBNODE_NOTIFICATIONSTAGE)) {
                String stageConnectionName = null;
                String stageDescription = null;
                ConfigurationNode stageSpecification = null;
                for (int q = 0; q < child.getChildCount(); ++q) {
                    ConfigurationNode cn3 = child.findChild(q);
                    if (cn3.getType().equals(JOBNODE_STAGECONNECTIONNAME)) {
                        stageConnectionName = cn3.getValue();
                        continue;
                    }
                    if (cn3.getType().equals(JOBNODE_STAGEDESCRIPTION)) {
                        stageDescription = cn3.getValue();
                        continue;
                    }
                    if (cn3.getType().equals(JOBNODE_STAGESPECIFICATION)) {
                        stageSpecification = cn3;
                        continue;
                    }
                    throw new ManifoldCFException("Found an unexpected node type: '" + cn3.getType() + "'");
                }
                if (stageConnectionName == null) {
                    throw new ManifoldCFException("Missing required field: 'stage_connectionname'");
                }
                Specification os = jobDescription.addNotification(stageConnectionName, stageDescription);
                os.clearChildren();
                if (stageSpecification == null) continue;
                for (int j = 0; j < stageSpecification.getChildCount(); ++j) {
                    ConfigurationNode cn4 = stageSpecification.findChild(j);
                    os.addChild(os.getChildCount(), (ConfigurationNode)new SpecificationNode(cn4));
                }
                continue;
            }
            if (childType.equals(JOBNODE_DOCUMENTSPECIFICATION)) {
                DocumentSpecification ds = jobDescription.getSpecification();
                ds.clearChildren();
                for (int j = 0; j < child.getChildCount(); ++j) {
                    ConfigurationNode cn5 = child.findChild(j);
                    ds.addChild(ds.getChildCount(), (ConfigurationNode)new SpecificationNode(cn5));
                }
                continue;
            }
            if (childType.equals(JOBNODE_STARTMODE)) {
                jobDescription.setStartMethod(ManifoldCF.mapToStartMode(child.getValue()));
                continue;
            }
            if (childType.equals(JOBNODE_RUNMODE)) {
                jobDescription.setType(ManifoldCF.mapToRunMode(child.getValue()));
                continue;
            }
            if (childType.equals(JOBNODE_HOPCOUNTMODE)) {
                jobDescription.setHopcountMode(ManifoldCF.mapToHopcountMode(child.getValue()));
                continue;
            }
            if (childType.equals(JOBNODE_PRIORITY)) {
                try {
                    jobDescription.setPriority(Integer.parseInt(child.getValue()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                }
            }
            if (childType.equals(JOBNODE_RECRAWLINTERVAL)) {
                jobDescription.setInterval(ManifoldCF.interpretInterval(child.getValue()));
                continue;
            }
            if (childType.equals(JOBNODE_EXPIRATIONINTERVAL)) {
                jobDescription.setExpiration(ManifoldCF.interpretInterval(child.getValue()));
                continue;
            }
            if (childType.equals(JOBNODE_RESEEDINTERVAL)) {
                jobDescription.setReseedInterval(ManifoldCF.interpretInterval(child.getValue()));
                continue;
            }
            if (childType.equals(JOBNODE_HOPCOUNT)) {
                String linkType = null;
                String hopCount = null;
                int q = 0;
                while (q < child.getChildCount()) {
                    if ((cn = child.findChild(q++)).getType().equals(JOBNODE_LINKTYPE)) {
                        linkType = cn.getValue();
                        continue;
                    }
                    if (cn.getType().equals(JOBNODE_COUNT)) {
                        hopCount = cn.getValue();
                        continue;
                    }
                    throw new ManifoldCFException("Found an unexpected node type: '" + cn.getType() + "'");
                }
                if (linkType == null) {
                    throw new ManifoldCFException("Missing required field: 'link_type'");
                }
                if (hopCount == null) {
                    throw new ManifoldCFException("Missing required field: 'count'");
                }
                jobDescription.addHopCountFilter(linkType, new Long(hopCount));
                continue;
            }
            if (childType.equals(JOBNODE_FORCEDPARAM)) {
                String paramName = null;
                String paramValue = null;
                for (int q = 0; q < child.getChildCount(); ++q) {
                    cn = child.findChild(q);
                    if (cn.getType().equals(JOBNODE_PARAMNAME)) {
                        paramName = cn.getValue();
                        continue;
                    }
                    if (cn.getType().equals(JOBNODE_PARAMVALUE)) {
                        paramValue = cn.getValue();
                        continue;
                    }
                    throw new ManifoldCFException("Found an unexpected node type: '" + cn.getType() + "'");
                }
                if (paramName == null) {
                    throw new ManifoldCFException("Missing required field: 'paramname'");
                }
                if (paramValue == null) {
                    throw new ManifoldCFException("Missing required field: 'paramvalue'");
                }
                jobDescription.addForcedMetadataValue(paramName, paramValue);
                continue;
            }
            if (childType.equals(JOBNODE_SCHEDULE)) {
                String timezone = null;
                Long duration = null;
                boolean requestMinimum = false;
                EnumeratedValues dayOfWeek = null;
                EnumeratedValues monthOfYear = null;
                EnumeratedValues dayOfMonth = null;
                EnumeratedValues year = null;
                EnumeratedValues hourOfDay = null;
                EnumeratedValues minutesOfHour = null;
                int q = 0;
                while (q < child.getChildCount()) {
                    ConfigurationNode scheduleField;
                    String fieldType;
                    if ((fieldType = (scheduleField = child.findChild(q++)).getType()).equals(JOBNODE_REQUESTMINIMUM)) {
                        requestMinimum = scheduleField.getValue().equals("true");
                        continue;
                    }
                    if (fieldType.equals(JOBNODE_TIMEZONE)) {
                        timezone = scheduleField.getValue();
                        continue;
                    }
                    if (fieldType.equals(JOBNODE_DURATION)) {
                        duration = new Long(scheduleField.getValue());
                        continue;
                    }
                    if (fieldType.equals(JOBNODE_DAYOFWEEK)) {
                        dayOfWeek = ManifoldCF.processEnumeratedValues(scheduleField);
                        continue;
                    }
                    if (fieldType.equals(JOBNODE_MONTHOFYEAR)) {
                        monthOfYear = ManifoldCF.processEnumeratedValues(scheduleField);
                        continue;
                    }
                    if (fieldType.equals(JOBNODE_YEAR)) {
                        year = ManifoldCF.processEnumeratedValues(scheduleField);
                        continue;
                    }
                    if (fieldType.equals(JOBNODE_DAYOFMONTH)) {
                        dayOfMonth = ManifoldCF.processEnumeratedValues(scheduleField);
                        continue;
                    }
                    if (fieldType.equals(JOBNODE_HOUROFDAY)) {
                        hourOfDay = ManifoldCF.processEnumeratedValues(scheduleField);
                        continue;
                    }
                    if (fieldType.equals(JOBNODE_MINUTESOFHOUR)) {
                        minutesOfHour = ManifoldCF.processEnumeratedValues(scheduleField);
                        continue;
                    }
                    throw new ManifoldCFException("Unrecognized field in schedule record: '" + fieldType + "'");
                }
                ScheduleRecord sr = new ScheduleRecord(dayOfWeek, monthOfYear, dayOfMonth, year, hourOfDay, minutesOfHour, timezone, duration, requestMinimum);
                jobDescription.addScheduleRecord(sr);
                continue;
            }
            throw new ManifoldCFException("Unrecognized job field: '" + childType + "'");
        }
        ArrayList<String> orderedStageNames = new ArrayList<String>();
        HashSet<String> keysSeen = new HashSet<String>();
        for (String stageName : pipelineStages.keySet()) {
            PipelineStage ps = (PipelineStage)pipelineStages.get(stageName);
            if (keysSeen.contains(stageName)) continue;
            ManifoldCF.addStage(stageName, orderedStageNames, keysSeen, pipelineStages);
        }
        int k = 0;
        for (String stageName : orderedStageNames) {
            PipelineStage ps = (PipelineStage)pipelineStages.get(stageName);
            ps.ordinal = k++;
            int prerequisite = ps.prerequisite == null ? -1 : ((PipelineStage)pipelineStages.get((Object)ps.prerequisite)).ordinal;
            Specification os = jobDescription.addPipelineStage(prerequisite, ps.isOutput, ps.connectionName, ps.description);
            os.clearChildren();
            if (ps.specification == null) continue;
            for (int j = 0; j < ps.specification.getChildCount(); ++j) {
                ConfigurationNode cn = ps.specification.findChild(j);
                os.addChild(os.getChildCount(), (ConfigurationNode)new SpecificationNode(cn));
            }
        }
    }

    protected static void addStage(String stageName, List<String> orderedStageNames, Set<String> keysSeen, Map<String, PipelineStage> pipelineStages) throws ManifoldCFException {
        if (keysSeen.contains(stageName)) {
            return;
        }
        PipelineStage ps = pipelineStages.get(stageName);
        if (ps == null) {
            throw new ManifoldCFException("Stage reference error: '" + stageName + "' is unknown");
        }
        if (ps.prerequisite != null) {
            ManifoldCF.addStage(ps.prerequisite, orderedStageNames, keysSeen, pipelineStages);
        }
        orderedStageNames.add(stageName);
        keysSeen.add(stageName);
    }

    protected static void formatJobDescription(ConfigurationNode jobNode, IJobDescription job) {
        SpecificationNode cn;
        int k;
        Specification spec;
        String description;
        ConfigurationNode stage;
        int j;
        ConfigurationNode child;
        if (job.getID() != null) {
            child = new ConfigurationNode(JOBNODE_ID);
            child.setValue(job.getID().toString());
            jobNode.addChild(jobNode.getChildCount(), child);
        }
        if (job.getDescription() != null) {
            child = new ConfigurationNode("description");
            child.setValue(job.getDescription());
            jobNode.addChild(jobNode.getChildCount(), child);
        }
        if (job.getConnectionName() != null) {
            child = new ConfigurationNode(JOBNODE_CONNECTIONNAME);
            child.setValue(job.getConnectionName());
            jobNode.addChild(jobNode.getChildCount(), child);
        }
        DocumentSpecification ds = job.getSpecification();
        child = new ConfigurationNode(JOBNODE_DOCUMENTSPECIFICATION);
        for (j = 0; j < ds.getChildCount(); ++j) {
            SpecificationNode cn2 = ds.getChild(j);
            child.addChild(child.getChildCount(), (ConfigurationNode)cn2);
        }
        jobNode.addChild(jobNode.getChildCount(), child);
        for (j = 0; j < job.countPipelineStages(); ++j) {
            child = new ConfigurationNode(JOBNODE_PIPELINESTAGE);
            stage = new ConfigurationNode(JOBNODE_STAGEID);
            stage.setValue(Integer.toString(j));
            child.addChild(child.getChildCount(), stage);
            if (job.getPipelineStagePrerequisite(j) != -1) {
                stage = new ConfigurationNode(JOBNODE_STAGEPREREQUISITE);
                stage.setValue(Integer.toString(job.getPipelineStagePrerequisite(j)));
                child.addChild(child.getChildCount(), stage);
            }
            stage = new ConfigurationNode(JOBNODE_STAGEISOUTPUT);
            stage.setValue(job.getPipelineStageIsOutputConnection(j) ? "true" : "false");
            child.addChild(child.getChildCount(), stage);
            stage = new ConfigurationNode(JOBNODE_STAGECONNECTIONNAME);
            stage.setValue(job.getPipelineStageConnectionName(j));
            child.addChild(child.getChildCount(), stage);
            description = job.getPipelineStageDescription(j);
            if (description != null) {
                stage = new ConfigurationNode(JOBNODE_STAGEDESCRIPTION);
                stage.setValue(description);
                child.addChild(child.getChildCount(), stage);
            }
            spec = job.getPipelineStageSpecification(j);
            stage = new ConfigurationNode(JOBNODE_STAGESPECIFICATION);
            for (k = 0; k < spec.getChildCount(); ++k) {
                cn = spec.getChild(k);
                stage.addChild(stage.getChildCount(), (ConfigurationNode)cn);
            }
            child.addChild(child.getChildCount(), stage);
            jobNode.addChild(jobNode.getChildCount(), child);
        }
        for (j = 0; j < job.countNotifications(); ++j) {
            child = new ConfigurationNode(JOBNODE_NOTIFICATIONSTAGE);
            stage = new ConfigurationNode(JOBNODE_STAGEID);
            stage.setValue(Integer.toString(j));
            child.addChild(child.getChildCount(), stage);
            stage = new ConfigurationNode(JOBNODE_STAGECONNECTIONNAME);
            stage.setValue(job.getNotificationConnectionName(j));
            child.addChild(child.getChildCount(), stage);
            description = job.getNotificationDescription(j);
            if (description != null) {
                stage = new ConfigurationNode(JOBNODE_STAGEDESCRIPTION);
                stage.setValue(description);
                child.addChild(child.getChildCount(), stage);
            }
            spec = job.getNotificationSpecification(j);
            stage = new ConfigurationNode(JOBNODE_STAGESPECIFICATION);
            for (k = 0; k < spec.getChildCount(); ++k) {
                cn = spec.getChild(k);
                stage.addChild(stage.getChildCount(), (ConfigurationNode)cn);
            }
            child.addChild(child.getChildCount(), stage);
            jobNode.addChild(jobNode.getChildCount(), child);
        }
        child = new ConfigurationNode(JOBNODE_STARTMODE);
        child.setValue(ManifoldCF.startModeMap(job.getStartMethod()));
        jobNode.addChild(jobNode.getChildCount(), child);
        child = new ConfigurationNode(JOBNODE_RUNMODE);
        child.setValue(ManifoldCF.runModeMap(job.getType()));
        jobNode.addChild(jobNode.getChildCount(), child);
        child = new ConfigurationNode(JOBNODE_HOPCOUNTMODE);
        child.setValue(ManifoldCF.hopcountModeMap(job.getHopcountMode()));
        jobNode.addChild(jobNode.getChildCount(), child);
        child = new ConfigurationNode(JOBNODE_PRIORITY);
        child.setValue(Integer.toString(job.getPriority()));
        jobNode.addChild(jobNode.getChildCount(), child);
        child = new ConfigurationNode(JOBNODE_RECRAWLINTERVAL);
        child.setValue(job.getInterval() == null ? "infinite" : job.getInterval().toString());
        jobNode.addChild(jobNode.getChildCount(), child);
        child = new ConfigurationNode(JOBNODE_EXPIRATIONINTERVAL);
        child.setValue(job.getExpiration() == null ? "infinite" : job.getExpiration().toString());
        jobNode.addChild(jobNode.getChildCount(), child);
        child = new ConfigurationNode(JOBNODE_RESEEDINTERVAL);
        child.setValue(job.getReseedInterval() == null ? "infinite" : job.getReseedInterval().toString());
        jobNode.addChild(jobNode.getChildCount(), child);
        Map filters = job.getHopCountFilters();
        for (String linkType : filters.keySet()) {
            Long hopCount = (Long)filters.get(linkType);
            child = new ConfigurationNode(JOBNODE_HOPCOUNT);
            ConfigurationNode cn3 = new ConfigurationNode(JOBNODE_LINKTYPE);
            cn3.setValue(linkType);
            child.addChild(child.getChildCount(), cn3);
            cn3 = new ConfigurationNode(JOBNODE_COUNT);
            cn3.setValue(hopCount.toString());
            child.addChild(child.getChildCount(), cn3);
            jobNode.addChild(jobNode.getChildCount(), child);
        }
        Map<String, Set<String>> forcedMetadata = job.getForcedMetadata();
        for (String paramName : forcedMetadata.keySet()) {
            Set<String> values = forcedMetadata.get(paramName);
            for (String paramValue : values) {
                child = new ConfigurationNode(JOBNODE_FORCEDPARAM);
                ConfigurationNode cn4 = new ConfigurationNode(JOBNODE_PARAMNAME);
                cn4.setValue(paramName);
                child.addChild(child.getChildCount(), cn4);
                cn4 = new ConfigurationNode(JOBNODE_PARAMVALUE);
                cn4.setValue(paramValue);
                child.addChild(child.getChildCount(), cn4);
                jobNode.addChild(jobNode.getChildCount(), child);
            }
        }
        for (int j2 = 0; j2 < job.getScheduleRecordCount(); ++j2) {
            ScheduleRecord sr = job.getScheduleRecord(j2);
            child = new ConfigurationNode(JOBNODE_SCHEDULE);
            ConfigurationNode recordChild = new ConfigurationNode(JOBNODE_REQUESTMINIMUM);
            recordChild.setValue(sr.getRequestMinimum() ? "true" : "false");
            child.addChild(child.getChildCount(), recordChild);
            if (sr.getTimezone() != null) {
                recordChild = new ConfigurationNode(JOBNODE_TIMEZONE);
                recordChild.setValue(sr.getTimezone());
                child.addChild(child.getChildCount(), recordChild);
            }
            if (sr.getDuration() != null) {
                recordChild = new ConfigurationNode(JOBNODE_DURATION);
                recordChild.setValue(sr.getDuration().toString());
                child.addChild(child.getChildCount(), recordChild);
            }
            if (sr.getDayOfWeek() != null) {
                ManifoldCF.formatEnumeratedValues(child, JOBNODE_DAYOFWEEK, sr.getDayOfWeek());
            }
            if (sr.getMonthOfYear() != null) {
                ManifoldCF.formatEnumeratedValues(child, JOBNODE_MONTHOFYEAR, sr.getMonthOfYear());
            }
            if (sr.getDayOfMonth() != null) {
                ManifoldCF.formatEnumeratedValues(child, JOBNODE_DAYOFMONTH, sr.getDayOfMonth());
            }
            if (sr.getYear() != null) {
                ManifoldCF.formatEnumeratedValues(child, JOBNODE_YEAR, sr.getYear());
            }
            if (sr.getHourOfDay() != null) {
                ManifoldCF.formatEnumeratedValues(child, JOBNODE_HOUROFDAY, sr.getHourOfDay());
            }
            if (sr.getMinutesOfHour() != null) {
                ManifoldCF.formatEnumeratedValues(child, JOBNODE_MINUTESOFHOUR, sr.getMinutesOfHour());
            }
            jobNode.addChild(jobNode.getChildCount(), child);
        }
    }

    protected static void formatEnumeratedValues(ConfigurationNode recordNode, String childType, EnumeratedValues value) {
        ConfigurationNode child = new ConfigurationNode(childType);
        Iterator iter = value.getValues();
        while (iter.hasNext()) {
            Integer theValue = (Integer)iter.next();
            ConfigurationNode valueNode = new ConfigurationNode("value");
            valueNode.setValue(theValue.toString());
            child.addChild(child.getChildCount(), valueNode);
        }
        recordNode.addChild(recordNode.getChildCount(), child);
    }

    protected static EnumeratedValues processEnumeratedValues(ConfigurationNode fieldNode) throws ManifoldCFException {
        ArrayList<Integer> values = new ArrayList<Integer>();
        int i = 0;
        while (i < fieldNode.getChildCount()) {
            ConfigurationNode cn;
            if ((cn = fieldNode.findChild(i++)).getType().equals("value")) {
                try {
                    values.add(new Integer(cn.getValue()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Error processing enumerated value node: " + e.getMessage(), (Throwable)e);
                }
            }
            throw new ManifoldCFException("Error processing enumerated value nodes: Unrecognized node type '" + cn.getType() + "'");
        }
        return new EnumeratedValues(values);
    }

    protected static String presentInterval(Long interval) {
        if (interval == null) {
            return "infinite";
        }
        return interval.toString();
    }

    protected static Long interpretInterval(String interval) throws ManifoldCFException {
        if (interval == null || interval.equals("infinite")) {
            return null;
        }
        return new Long(interval);
    }

    protected static String startModeMap(int startMethod) {
        switch (startMethod) {
            case 0: {
                return "schedule window start";
            }
            case 1: {
                return "schedule window anytime";
            }
            case 2: {
                return "manual";
            }
        }
        return "unknown";
    }

    protected static int mapToStartMode(String startMethod) throws ManifoldCFException {
        if (startMethod.equals("schedule window start")) {
            return 0;
        }
        if (startMethod.equals("schedule window anytime")) {
            return 1;
        }
        if (startMethod.equals("manual")) {
            return 2;
        }
        throw new ManifoldCFException("Unrecognized start method: '" + startMethod + "'");
    }

    protected static String runModeMap(int type) {
        switch (type) {
            case 0: {
                return "continuous";
            }
            case 1: {
                return "scan once";
            }
        }
        return "unknown";
    }

    protected static int mapToRunMode(String mode) throws ManifoldCFException {
        if (mode.equals("continuous")) {
            return 0;
        }
        if (mode.equals("scan once")) {
            return 1;
        }
        throw new ManifoldCFException("Unrecognized run method: '" + mode + "'");
    }

    protected static String hopcountModeMap(int mode) {
        switch (mode) {
            case 0: {
                return "accurate";
            }
            case 1: {
                return "no delete";
            }
            case 2: {
                return "never delete";
            }
        }
        return "unknown";
    }

    protected static int mapToHopcountMode(String mode) throws ManifoldCFException {
        if (mode.equals("accurate")) {
            return 0;
        }
        if (mode.equals("no delete")) {
            return 1;
        }
        if (mode.equals("never delete")) {
            return 2;
        }
        throw new ManifoldCFException("Unrecognized hopcount method: '" + mode + "'");
    }

    protected static void formatJobStatus(ConfigurationNode jobStatusNode, JobStatus jobStatus) {
        ConfigurationNode child = new ConfigurationNode("job_id");
        child.setValue(jobStatus.getJobID().toString());
        jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        child = new ConfigurationNode(JOBSTATUSNODE_STATUS);
        child.setValue(ManifoldCF.statusMap(jobStatus.getStatus()));
        jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        if (jobStatus.getErrorText() != null) {
            child = new ConfigurationNode(JOBSTATUSNODE_ERRORTEXT);
            child.setValue(jobStatus.getErrorText());
            jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        }
        if (jobStatus.getStartTime() != -1L) {
            child = new ConfigurationNode(JOBSTATUSNODE_STARTTIME);
            child.setValue(new Long(jobStatus.getStartTime()).toString());
            jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        }
        if (jobStatus.getEndTime() != -1L) {
            child = new ConfigurationNode(JOBSTATUSNODE_ENDTIME);
            child.setValue(new Long(jobStatus.getEndTime()).toString());
            jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        }
        child = new ConfigurationNode(JOBSTATUSNODE_DOCUMENTSINQUEUE);
        child.setValue(new Long(jobStatus.getDocumentsInQueue()).toString());
        jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        child = new ConfigurationNode(JOBSTATUSNODE_DOCUMENTSOUTSTANDING);
        child.setValue(new Long(jobStatus.getDocumentsOutstanding()).toString());
        jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        child = new ConfigurationNode(JOBSTATUSNODE_DOCUMENTSPROCESSED);
        child.setValue(new Long(jobStatus.getDocumentsProcessed()).toString());
        jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        child = new ConfigurationNode(JOBSTATUSNODE_QUEUEEXACT);
        child.setValue(new Boolean(jobStatus.getQueueCountExact()).toString());
        jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        child = new ConfigurationNode(JOBSTATUSNODE_OUTSTANDINGEXACT);
        child.setValue(new Boolean(jobStatus.getOutstandingCountExact()).toString());
        jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
        child = new ConfigurationNode(JOBSTATUSNODE_PROCESSEDEXACT);
        child.setValue(new Boolean(jobStatus.getProcessedCountExact()).toString());
        jobStatusNode.addChild(jobStatusNode.getChildCount(), child);
    }

    protected static String statusMap(int status) {
        switch (status) {
            case 0: {
                return "not yet run";
            }
            case 1: {
                return "running";
            }
            case 2: {
                return "stopping";
            }
            case 4: {
                return "resuming";
            }
            case 3: {
                return "paused";
            }
            case 5: {
                return "done";
            }
            case 6: {
                return "waiting";
            }
            case 7: {
                return "starting up";
            }
            case 8: {
                return "cleaning up";
            }
            case 9: {
                return "error";
            }
            case 10: {
                return "aborting";
            }
            case 11: {
                return "restarting";
            }
            case 12: {
                return "running no connector";
            }
            case 13: {
                return "terminating";
            }
            case 14: {
                return "notifying";
            }
        }
        return "unknown";
    }

    protected static void processAuthorityGroup(AuthorityGroup group, ConfigurationNode groupNode) throws ManifoldCFException {
        int i = 0;
        while (i < groupNode.getChildCount()) {
            ConfigurationNode child;
            String childType;
            if ((childType = (child = groupNode.findChild(i++)).getType()).equals("isnew")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Authority group isnew node requires a value");
                }
                group.setIsNew(child.getValue().equals("true"));
                continue;
            }
            if (childType.equals("name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Authority group name node requires a value");
                }
                group.setName(child.getValue());
                continue;
            }
            if (childType.equals("description")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Authority group description node requires a value");
                }
                group.setDescription(child.getValue());
                continue;
            }
            throw new ManifoldCFException("Unrecognized authority group field: '" + childType + "'");
        }
    }

    protected static void formatAuthorityGroup(ConfigurationNode groupNode, IAuthorityGroup group) {
        ConfigurationNode child = new ConfigurationNode("isnew");
        child.setValue(group.getIsNew() ? "true" : "false");
        groupNode.addChild(groupNode.getChildCount(), child);
        child = new ConfigurationNode("name");
        child.setValue(group.getName());
        groupNode.addChild(groupNode.getChildCount(), child);
        if (group.getDescription() != null) {
            child = new ConfigurationNode("description");
            child.setValue(group.getDescription());
            groupNode.addChild(groupNode.getChildCount(), child);
        }
    }

    protected static void processOutputConnection(OutputConnection connection, ConfigurationNode connectionNode) throws ManifoldCFException {
        int i = 0;
        while (i < connectionNode.getChildCount()) {
            ConfigurationNode child;
            String childType;
            if ((childType = (child = connectionNode.findChild(i++)).getType()).equals("isnew")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection isnew node requires a value");
                }
                connection.setIsNew(child.getValue().equals("true"));
                continue;
            }
            if (childType.equals("name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection name node requires a value");
                }
                connection.setName(child.getValue());
                continue;
            }
            if (childType.equals("class_name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection classname node requires a value");
                }
                connection.setClassName(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_MAXCONNECTIONS)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection maxconnections node requires a value");
                }
                try {
                    connection.setMaxConnections(Integer.parseInt(child.getValue()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Error parsing max connections: " + e.getMessage(), (Throwable)e);
                }
            }
            if (childType.equals("description")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection description node requires a value");
                }
                connection.setDescription(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_CONFIGURATION)) {
                ConfigParams cp = connection.getConfigParams();
                cp.clearChildren();
                int j = 0;
                while (j < child.getChildCount()) {
                    ConfigurationNode cn = child.findChild(j++);
                    cp.addChild(cp.getChildCount(), (ConfigurationNode)new ConfigNode(cn));
                }
                continue;
            }
            throw new ManifoldCFException("Unrecognized output connection field: '" + childType + "'");
        }
        if (connection.getClassName() == null) {
            throw new ManifoldCFException("Missing connection field: 'class_name'");
        }
    }

    protected static void formatOutputConnection(ConfigurationNode connectionNode, IOutputConnection connection) {
        ConfigurationNode child = new ConfigurationNode("isnew");
        child.setValue(connection.getIsNew() ? "true" : "false");
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode("name");
        child.setValue(connection.getName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode("class_name");
        child.setValue(connection.getClassName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode(CONNECTIONNODE_MAXCONNECTIONS);
        child.setValue(Integer.toString(connection.getMaxConnections()));
        connectionNode.addChild(connectionNode.getChildCount(), child);
        if (connection.getDescription() != null) {
            child = new ConfigurationNode("description");
            child.setValue(connection.getDescription());
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
        ConfigParams cp = connection.getConfigParams();
        child = new ConfigurationNode(CONNECTIONNODE_CONFIGURATION);
        int j = 0;
        while (j < cp.getChildCount()) {
            ConfigurationNode cn = cp.findChild(j++);
            child.addChild(child.getChildCount(), cn);
        }
        connectionNode.addChild(connectionNode.getChildCount(), child);
    }

    protected static void processTransformationConnection(TransformationConnection connection, ConfigurationNode connectionNode) throws ManifoldCFException {
        int i = 0;
        while (i < connectionNode.getChildCount()) {
            ConfigurationNode child;
            String childType;
            if ((childType = (child = connectionNode.findChild(i++)).getType()).equals("isnew")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection isnew node requires a value");
                }
                connection.setIsNew(child.getValue().equals("true"));
                continue;
            }
            if (childType.equals("name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection name node requires a value");
                }
                connection.setName(child.getValue());
                continue;
            }
            if (childType.equals("class_name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection classname node requires a value");
                }
                connection.setClassName(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_MAXCONNECTIONS)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection maxconnections node requires a value");
                }
                try {
                    connection.setMaxConnections(Integer.parseInt(child.getValue()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Error parsing max connections: " + e.getMessage(), (Throwable)e);
                }
            }
            if (childType.equals("description")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection description node requires a value");
                }
                connection.setDescription(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_CONFIGURATION)) {
                ConfigParams cp = connection.getConfigParams();
                cp.clearChildren();
                int j = 0;
                while (j < child.getChildCount()) {
                    ConfigurationNode cn = child.findChild(j++);
                    cp.addChild(cp.getChildCount(), (ConfigurationNode)new ConfigNode(cn));
                }
                continue;
            }
            throw new ManifoldCFException("Unrecognized output connection field: '" + childType + "'");
        }
        if (connection.getClassName() == null) {
            throw new ManifoldCFException("Missing connection field: 'class_name'");
        }
    }

    protected static void formatTransformationConnection(ConfigurationNode connectionNode, ITransformationConnection connection) {
        ConfigurationNode child = new ConfigurationNode("isnew");
        child.setValue(connection.getIsNew() ? "true" : "false");
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode("name");
        child.setValue(connection.getName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode("class_name");
        child.setValue(connection.getClassName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode(CONNECTIONNODE_MAXCONNECTIONS);
        child.setValue(Integer.toString(connection.getMaxConnections()));
        connectionNode.addChild(connectionNode.getChildCount(), child);
        if (connection.getDescription() != null) {
            child = new ConfigurationNode("description");
            child.setValue(connection.getDescription());
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
        ConfigParams cp = connection.getConfigParams();
        child = new ConfigurationNode(CONNECTIONNODE_CONFIGURATION);
        int j = 0;
        while (j < cp.getChildCount()) {
            ConfigurationNode cn = cp.findChild(j++);
            child.addChild(child.getChildCount(), cn);
        }
        connectionNode.addChild(connectionNode.getChildCount(), child);
    }

    protected static void processAuthorityConnection(AuthorityConnection connection, ConfigurationNode connectionNode) throws ManifoldCFException {
        int i = 0;
        while (i < connectionNode.getChildCount()) {
            ConfigurationNode child;
            String childType;
            if ((childType = (child = connectionNode.findChild(i++)).getType()).equals("isnew")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection isnew node requires a value");
                }
                connection.setIsNew(child.getValue().equals("true"));
                continue;
            }
            if (childType.equals("name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection name node requires a value");
                }
                connection.setName(child.getValue());
                continue;
            }
            if (childType.equals("class_name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection classname node requires a value");
                }
                connection.setClassName(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_MAXCONNECTIONS)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection maxconnections node requires a value");
                }
                try {
                    connection.setMaxConnections(Integer.parseInt(child.getValue()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Error parsing max connections: " + e.getMessage(), (Throwable)e);
                }
            }
            if (childType.equals(CONNECTIONNODE_PREREQUISITE)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection prerequisite node requires a value");
                }
                connection.setPrerequisiteMapping(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_AUTHDOMAIN)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection authdomain node requires a value");
                }
                connection.setAuthDomain(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_AUTHGROUP)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection authgroup node requires a value");
                }
                connection.setAuthGroup(child.getValue());
                continue;
            }
            if (childType.equals("description")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection description node requires a value");
                }
                connection.setDescription(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_CONFIGURATION)) {
                ConfigParams cp = connection.getConfigParams();
                cp.clearChildren();
                int j = 0;
                while (j < child.getChildCount()) {
                    ConfigurationNode cn = child.findChild(j++);
                    cp.addChild(cp.getChildCount(), (ConfigurationNode)new ConfigNode(cn));
                }
                continue;
            }
            throw new ManifoldCFException("Unrecognized authority connection field: '" + childType + "'");
        }
        if (connection.getClassName() == null) {
            throw new ManifoldCFException("Missing connection field: 'class_name'");
        }
    }

    protected static void formatAuthorityConnection(ConfigurationNode connectionNode, IAuthorityConnection connection) {
        ConfigurationNode child = new ConfigurationNode("isnew");
        child.setValue(connection.getIsNew() ? "true" : "false");
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode("name");
        child.setValue(connection.getName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode("class_name");
        child.setValue(connection.getClassName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode(CONNECTIONNODE_MAXCONNECTIONS);
        child.setValue(Integer.toString(connection.getMaxConnections()));
        connectionNode.addChild(connectionNode.getChildCount(), child);
        if (connection.getPrerequisiteMapping() != null) {
            child = new ConfigurationNode(CONNECTIONNODE_PREREQUISITE);
            child.setValue(connection.getPrerequisiteMapping());
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
        if (connection.getDescription() != null) {
            child = new ConfigurationNode("description");
            child.setValue(connection.getDescription());
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
        if (connection.getAuthDomain() != null) {
            child = new ConfigurationNode(CONNECTIONNODE_AUTHDOMAIN);
            child.setValue(connection.getAuthDomain());
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
        child = new ConfigurationNode(CONNECTIONNODE_AUTHGROUP);
        child.setValue(connection.getAuthGroup());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        ConfigParams cp = connection.getConfigParams();
        child = new ConfigurationNode(CONNECTIONNODE_CONFIGURATION);
        int j = 0;
        while (j < cp.getChildCount()) {
            ConfigurationNode cn = cp.findChild(j++);
            child.addChild(child.getChildCount(), cn);
        }
        connectionNode.addChild(connectionNode.getChildCount(), child);
    }

    protected static void processMappingConnection(MappingConnection connection, ConfigurationNode connectionNode) throws ManifoldCFException {
        int i = 0;
        while (i < connectionNode.getChildCount()) {
            ConfigurationNode child;
            String childType;
            if ((childType = (child = connectionNode.findChild(i++)).getType()).equals("isnew")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection isnew node requires a value");
                }
                connection.setIsNew(child.getValue().equals("true"));
                continue;
            }
            if (childType.equals("name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection name node requires a value");
                }
                connection.setName(child.getValue());
                continue;
            }
            if (childType.equals("class_name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection classname node requires a value");
                }
                connection.setClassName(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_MAXCONNECTIONS)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection maxconnections node requires a value");
                }
                try {
                    connection.setMaxConnections(Integer.parseInt(child.getValue()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Error parsing max connections: " + e.getMessage(), (Throwable)e);
                }
            }
            if (childType.equals(CONNECTIONNODE_PREREQUISITE)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection prerequisite node requires a value");
                }
                connection.setPrerequisiteMapping(child.getValue());
                continue;
            }
            if (childType.equals("description")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection description node requires a value");
                }
                connection.setDescription(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_CONFIGURATION)) {
                ConfigParams cp = connection.getConfigParams();
                cp.clearChildren();
                int j = 0;
                while (j < child.getChildCount()) {
                    ConfigurationNode cn = child.findChild(j++);
                    cp.addChild(cp.getChildCount(), (ConfigurationNode)new ConfigNode(cn));
                }
                continue;
            }
            throw new ManifoldCFException("Unrecognized mapping connection field: '" + childType + "'");
        }
        if (connection.getClassName() == null) {
            throw new ManifoldCFException("Missing connection field: 'class_name'");
        }
    }

    protected static void formatMappingConnection(ConfigurationNode connectionNode, IMappingConnection connection) {
        ConfigurationNode child = new ConfigurationNode("isnew");
        child.setValue(connection.getIsNew() ? "true" : "false");
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode("name");
        child.setValue(connection.getName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode("class_name");
        child.setValue(connection.getClassName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode(CONNECTIONNODE_MAXCONNECTIONS);
        child.setValue(Integer.toString(connection.getMaxConnections()));
        connectionNode.addChild(connectionNode.getChildCount(), child);
        if (connection.getPrerequisiteMapping() != null) {
            child = new ConfigurationNode(CONNECTIONNODE_PREREQUISITE);
            child.setValue(connection.getPrerequisiteMapping());
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
        if (connection.getDescription() != null) {
            child = new ConfigurationNode("description");
            child.setValue(connection.getDescription());
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
        ConfigParams cp = connection.getConfigParams();
        child = new ConfigurationNode(CONNECTIONNODE_CONFIGURATION);
        int j = 0;
        while (j < cp.getChildCount()) {
            ConfigurationNode cn = cp.findChild(j++);
            child.addChild(child.getChildCount(), cn);
        }
        connectionNode.addChild(connectionNode.getChildCount(), child);
    }

    protected static void processRepositoryConnection(RepositoryConnection connection, ConfigurationNode connectionNode) throws ManifoldCFException {
        int i = 0;
        while (i < connectionNode.getChildCount()) {
            ConfigurationNode child;
            String childType;
            if ((childType = (child = connectionNode.findChild(i++)).getType()).equals("isnew")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection isnew node requires a value");
                }
                connection.setIsNew(child.getValue().equals("true"));
                continue;
            }
            if (childType.equals("name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection name node requires a value");
                }
                connection.setName(child.getValue());
                continue;
            }
            if (childType.equals("class_name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection classname node requires a value");
                }
                connection.setClassName(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_MAXCONNECTIONS)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection maxconnections node requires a value");
                }
                try {
                    connection.setMaxConnections(Integer.parseInt(child.getValue()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Error parsing max connections: " + e.getMessage(), (Throwable)e);
                }
            }
            if (childType.equals("description")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection description node requires a value");
                }
                connection.setDescription(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_CONFIGURATION)) {
                ConfigParams cp = connection.getConfigParams();
                cp.clearChildren();
                int j = 0;
                while (j < child.getChildCount()) {
                    ConfigurationNode cn = child.findChild(j++);
                    cp.addChild(cp.getChildCount(), (ConfigurationNode)new ConfigNode(cn));
                }
                continue;
            }
            if (childType.equals(CONNECTIONNODE_ACLAUTHORITY)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection aclauthority node requires a value");
                }
                connection.setACLAuthority(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_THROTTLE)) {
                String match = null;
                String description = null;
                Float rate = null;
                int q = 0;
                while (q < child.getChildCount()) {
                    ConfigurationNode throttleField;
                    String fieldType;
                    if ((fieldType = (throttleField = child.findChild(q++)).getType()).equals(CONNECTIONNODE_MATCH)) {
                        match = throttleField.getValue();
                        continue;
                    }
                    if (fieldType.equals(CONNECTIONNODE_MATCHDESCRIPTION)) {
                        description = throttleField.getValue();
                        continue;
                    }
                    if (fieldType.equals(CONNECTIONNODE_RATE)) {
                        rate = new Float(throttleField.getValue());
                        continue;
                    }
                    throw new ManifoldCFException("Unrecognized throttle field: '" + fieldType + "'");
                }
                if (match == null) {
                    throw new ManifoldCFException("Missing throttle field: 'match'");
                }
                if (rate == null) {
                    throw new ManifoldCFException("Missing throttle field: 'rate'");
                }
                connection.addThrottleValue(match, description, rate.floatValue());
                continue;
            }
            throw new ManifoldCFException("Unrecognized repository connection field: '" + childType + "'");
        }
        if (connection.getClassName() == null) {
            throw new ManifoldCFException("Missing connection field: 'class_name'");
        }
    }

    protected static void formatRepositoryConnection(ConfigurationNode connectionNode, IRepositoryConnection connection) {
        ConfigurationNode child = new ConfigurationNode("isnew");
        child.setValue(connection.getIsNew() ? "true" : "false");
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode("name");
        child.setValue(connection.getName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode("class_name");
        child.setValue(connection.getClassName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode(CONNECTIONNODE_MAXCONNECTIONS);
        child.setValue(Integer.toString(connection.getMaxConnections()));
        connectionNode.addChild(connectionNode.getChildCount(), child);
        if (connection.getDescription() != null) {
            child = new ConfigurationNode("description");
            child.setValue(connection.getDescription());
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
        ConfigParams cp = connection.getConfigParams();
        child = new ConfigurationNode(CONNECTIONNODE_CONFIGURATION);
        int j = 0;
        while (j < cp.getChildCount()) {
            ConfigurationNode cn = cp.findChild(j++);
            child.addChild(child.getChildCount(), cn);
        }
        connectionNode.addChild(connectionNode.getChildCount(), child);
        if (connection.getACLAuthority() != null) {
            child = new ConfigurationNode(CONNECTIONNODE_ACLAUTHORITY);
            child.setValue(connection.getACLAuthority());
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
        String[] throttles = connection.getThrottles();
        j = 0;
        while (j < throttles.length) {
            String match = throttles[j++];
            String description = connection.getThrottleDescription(match);
            float rate = connection.getThrottleValue(match);
            child = new ConfigurationNode(CONNECTIONNODE_THROTTLE);
            ConfigurationNode throttleChildNode = new ConfigurationNode(CONNECTIONNODE_MATCH);
            throttleChildNode.setValue(match);
            child.addChild(child.getChildCount(), throttleChildNode);
            if (description != null) {
                throttleChildNode = new ConfigurationNode(CONNECTIONNODE_MATCHDESCRIPTION);
                throttleChildNode.setValue(description);
                child.addChild(child.getChildCount(), throttleChildNode);
            }
            throttleChildNode = new ConfigurationNode(CONNECTIONNODE_RATE);
            throttleChildNode.setValue(new Float(rate).toString());
            child.addChild(child.getChildCount(), throttleChildNode);
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
    }

    protected static void processNotificationConnection(NotificationConnection connection, ConfigurationNode connectionNode) throws ManifoldCFException {
        int i = 0;
        while (i < connectionNode.getChildCount()) {
            ConfigurationNode child;
            String childType;
            if ((childType = (child = connectionNode.findChild(i++)).getType()).equals("isnew")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection isnew node requires a value");
                }
                connection.setIsNew(child.getValue().equals("true"));
                continue;
            }
            if (childType.equals("name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection name node requires a value");
                }
                connection.setName(child.getValue());
                continue;
            }
            if (childType.equals("class_name")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection classname node requires a value");
                }
                connection.setClassName(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_MAXCONNECTIONS)) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection maxconnections node requires a value");
                }
                try {
                    connection.setMaxConnections(Integer.parseInt(child.getValue()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Error parsing max connections: " + e.getMessage(), (Throwable)e);
                }
            }
            if (childType.equals("description")) {
                if (child.getValue() == null) {
                    throw new ManifoldCFException("Connection description node requires a value");
                }
                connection.setDescription(child.getValue());
                continue;
            }
            if (childType.equals(CONNECTIONNODE_CONFIGURATION)) {
                ConfigParams cp = connection.getConfigParams();
                cp.clearChildren();
                int j = 0;
                while (j < child.getChildCount()) {
                    ConfigurationNode cn = child.findChild(j++);
                    cp.addChild(cp.getChildCount(), (ConfigurationNode)new ConfigNode(cn));
                }
                continue;
            }
            throw new ManifoldCFException("Unrecognized notification connection field: '" + childType + "'");
        }
        if (connection.getClassName() == null) {
            throw new ManifoldCFException("Missing connection field: 'class_name'");
        }
    }

    protected static void formatNotificationConnection(ConfigurationNode connectionNode, INotificationConnection connection) {
        ConfigurationNode child = new ConfigurationNode("isnew");
        child.setValue(connection.getIsNew() ? "true" : "false");
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode("name");
        child.setValue(connection.getName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode("class_name");
        child.setValue(connection.getClassName());
        connectionNode.addChild(connectionNode.getChildCount(), child);
        child = new ConfigurationNode(CONNECTIONNODE_MAXCONNECTIONS);
        child.setValue(Integer.toString(connection.getMaxConnections()));
        connectionNode.addChild(connectionNode.getChildCount(), child);
        if (connection.getDescription() != null) {
            child = new ConfigurationNode("description");
            child.setValue(connection.getDescription());
            connectionNode.addChild(connectionNode.getChildCount(), child);
        }
        ConfigParams cp = connection.getConfigParams();
        child = new ConfigurationNode(CONNECTIONNODE_CONFIGURATION);
        int j = 0;
        while (j < cp.getChildCount()) {
            ConfigurationNode cn = cp.findChild(j++);
            child.addChild(child.getChildCount(), cn);
        }
        connectionNode.addChild(connectionNode.getChildCount(), child);
    }

    static {
        docState.put("neverprocessed", new Integer(0));
        docState.put("previouslyprocessed", new Integer(1));
        docState.put("outofscope", new Integer(2));
        docStatus = new HashMap<String, Integer>();
        docStatus.put("inactive", new Integer(0));
        docStatus.put("processing", new Integer(1));
        docStatus.put("expiring", new Integer(2));
        docStatus.put("deleting", new Integer(3));
        docStatus.put("readyforprocessing", new Integer(4));
        docStatus.put("readyforexpiration", new Integer(5));
        docStatus.put("waitingforprocessing", new Integer(6));
        docStatus.put("waitingforexpiration", new Integer(7));
        docStatus.put("waitingforever", new Integer(8));
        docStatus.put("hopcountexceeded", new Integer(9));
    }

    protected static class PipelineStage {
        public final String prerequisite;
        public final boolean isOutput;
        public final String connectionName;
        public final String description;
        public final ConfigurationNode specification;
        public int ordinal;

        public PipelineStage(String prerequisite, boolean isOutput, String connectionName, String description, ConfigurationNode specification) {
            this.prerequisite = prerequisite;
            this.isOutput = isOutput;
            this.connectionName = connectionName;
            this.description = description;
            this.specification = specification;
        }
    }
}

