/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.ProgressMonitor;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.ChainsawColumns;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.ColumnComparator;
import org.apache.log4j.chainsaw.CyclicBufferList;
import org.apache.log4j.chainsaw.EventContainer;
import org.apache.log4j.chainsaw.EventCountListener;
import org.apache.log4j.chainsaw.LoggerNameListener;
import org.apache.log4j.chainsaw.LoggerNameModel;
import org.apache.log4j.chainsaw.LoggerNameModelSupport;
import org.apache.log4j.chainsaw.LoggingEventWrapper;
import org.apache.log4j.chainsaw.NewKeyEvent;
import org.apache.log4j.chainsaw.NewKeyListener;
import org.apache.log4j.chainsaw.RuleMediator;
import org.apache.log4j.chainsaw.color.RuleColorizer;
import org.apache.log4j.chainsaw.helper.SwingHelper;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

class ChainsawCyclicBufferTableModel
extends AbstractTableModel
implements EventContainer,
PropertyChangeListener {
    private static final int DEFAULT_CAPACITY = 5000;
    private boolean cyclic = true;
    private int cyclicBufferSize;
    List unfilteredList;
    List filteredList;
    private boolean currentSortAscending;
    private int currentSortColumn;
    private final EventListenerList eventListenerList = new EventListenerList();
    private final List<String> columnNames = new ArrayList<String>(ChainsawColumns.getColumnsNames());
    private boolean sortEnabled = false;
    private boolean reachedCapacity = false;
    private final Logger logger = LogManager.getLogger(ChainsawCyclicBufferTableModel.class);
    private final LoggerNameModel loggerNameModelDelegate = new LoggerNameModelSupport();
    private final Object mutex = new Object();
    int uniqueRow;
    private final Set uniquePropertyKeys = new HashSet();
    private Rule ruleMediator;
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private RuleColorizer colorizer;
    private final String tableModelName;

    public ChainsawCyclicBufferTableModel(int cyclicBufferSize, RuleColorizer colorizer, String tableModelName) {
        this.propertySupport.addPropertyChangeListener("cyclic", new ModelChanger());
        this.cyclicBufferSize = cyclicBufferSize;
        this.colorizer = colorizer;
        this.tableModelName = tableModelName;
        this.unfilteredList = new CyclicBufferList(cyclicBufferSize);
        this.filteredList = new CyclicBufferList(cyclicBufferSize);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof Rule) {
            if (evt.getSource() == this.ruleMediator && evt.getPropertyName().equals("findRule")) {
                if (((RuleMediator)((Object)evt.getSource())).isFindRuleRequired()) {
                    this.reFilter();
                }
            } else {
                this.reFilter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LoggingEventWrapper> getMatchingEvents(Rule rule) {
        ArrayList unfilteredCopy;
        ArrayList<LoggingEventWrapper> list = new ArrayList<LoggingEventWrapper>();
        Iterator iterator = this.mutex;
        synchronized (iterator) {
            unfilteredCopy = new ArrayList(this.unfilteredList);
        }
        for (Object anUnfilteredCopy : unfilteredCopy) {
            LoggingEventWrapper loggingEventWrapper = (LoggingEventWrapper)anUnfilteredCopy;
            if (!rule.evaluate(loggingEventWrapper.getLoggingEvent(), null)) continue;
            list.add(loggingEventWrapper);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reFilter() {
        int newSize;
        int previousSize;
        Object object = this.mutex;
        synchronized (object) {
            this.propertySupport.firePropertyChange("refilter", Boolean.FALSE, Boolean.TRUE);
            previousSize = this.filteredList.size();
            this.filteredList.clear();
            if (this.ruleMediator == null) {
                LoggingEventWrapper lastEvent = null;
                for (Object anUnfilteredList : this.unfilteredList) {
                    LoggingEventWrapper loggingEventWrapper = (LoggingEventWrapper)anUnfilteredList;
                    loggingEventWrapper.setDisplayed(true);
                    this.updateEventMillisDelta(loggingEventWrapper, lastEvent);
                    this.filteredList.add(loggingEventWrapper);
                    lastEvent = loggingEventWrapper;
                }
            } else {
                Iterator iter = this.unfilteredList.iterator();
                LoggingEventWrapper lastEvent = null;
                while (iter.hasNext()) {
                    LoggingEventWrapper loggingEventWrapper = (LoggingEventWrapper)iter.next();
                    if (this.ruleMediator.evaluate(loggingEventWrapper.getLoggingEvent(), null)) {
                        loggingEventWrapper.setDisplayed(true);
                        this.filteredList.add(loggingEventWrapper);
                        this.updateEventMillisDelta(loggingEventWrapper, lastEvent);
                        lastEvent = loggingEventWrapper;
                        continue;
                    }
                    loggingEventWrapper.setDisplayed(false);
                }
            }
            newSize = this.filteredList.size();
        }
        SwingHelper.invokeOnEDT(() -> {
            if (newSize > 0) {
                if (previousSize == newSize) {
                    this.fireTableRowsUpdated(0, newSize - 1);
                } else if (previousSize > newSize) {
                    this.fireTableRowsUpdated(0, newSize - 1);
                    this.fireTableDataChanged();
                } else if (previousSize < newSize) {
                    if (previousSize > 0) {
                        this.fireTableRowsUpdated(0, previousSize - 1);
                    }
                    this.fireTableRowsInserted(Math.max(0, previousSize), newSize - 1);
                }
            } else {
                this.fireTableDataChanged();
            }
            this.notifyCountListeners();
            SwingHelper.invokeOnEDT(() -> this.propertySupport.firePropertyChange("refilter", Boolean.TRUE, Boolean.FALSE));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int locate(Rule rule, int startLocation, boolean searchForward) {
        ArrayList filteredListCopy;
        Object object = this.mutex;
        synchronized (object) {
            filteredListCopy = new ArrayList(this.filteredList);
        }
        if (searchForward) {
            int i;
            for (i = startLocation; i < filteredListCopy.size(); ++i) {
                if (!rule.evaluate(((LoggingEventWrapper)filteredListCopy.get(i)).getLoggingEvent(), null)) continue;
                return i;
            }
            for (i = 0; i < startLocation; ++i) {
                if (!rule.evaluate(((LoggingEventWrapper)filteredListCopy.get(i)).getLoggingEvent(), null)) continue;
                return i;
            }
        } else {
            int i;
            for (i = startLocation; i > -1; --i) {
                if (!rule.evaluate(((LoggingEventWrapper)filteredListCopy.get(i)).getLoggingEvent(), null)) continue;
                return i;
            }
            for (i = filteredListCopy.size() - 1; i > startLocation; --i) {
                if (!rule.evaluate(((LoggingEventWrapper)filteredListCopy.get(i)).getLoggingEvent(), null)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void removeLoggerNameListener(LoggerNameListener l) {
        this.loggerNameModelDelegate.removeLoggerNameListener(l);
    }

    @Override
    public boolean addLoggerName(String loggerName) {
        return this.loggerNameModelDelegate.addLoggerName(loggerName);
    }

    public String toString() {
        return "ChainsawCyclicBufferTableModel{name='" + this.tableModelName + "'}";
    }

    @Override
    public void reset() {
        this.loggerNameModelDelegate.reset();
    }

    @Override
    public void addLoggerNameListener(LoggerNameListener l) {
        this.loggerNameModelDelegate.addLoggerNameListener(l);
    }

    @Override
    public Collection getLoggerNames() {
        return this.loggerNameModelDelegate.getLoggerNames();
    }

    @Override
    public void addEventCountListener(EventCountListener listener) {
        this.eventListenerList.add(EventCountListener.class, listener);
    }

    @Override
    public boolean isSortable(int col) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCountListeners() {
        EventCountListener[] listeners = (EventCountListener[])this.eventListenerList.getListeners(EventCountListener.class);
        EventCountListener[] eventCountListenerArray = this.mutex;
        synchronized (this.mutex) {
            int filteredListSize = this.filteredList.size();
            int unfilteredListSize = this.unfilteredList.size();
            // ** MonitorExit[var4_2] (shouldn't be in output)
            for (EventCountListener listener : listeners) {
                listener.eventCountChanged(filteredListSize, unfilteredListSize);
            }
            return;
        }
    }

    @Override
    public void setRuleMediator(RuleMediator ruleMediator) {
        if (this.ruleMediator != null) {
            this.ruleMediator.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.ruleMediator = ruleMediator;
        if (this.ruleMediator != null) {
            this.ruleMediator.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.reFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort() {
        boolean sort;
        int filteredListSize;
        Object object = this.mutex;
        synchronized (object) {
            filteredListSize = this.filteredList.size();
            boolean bl = sort = this.sortEnabled && filteredListSize > 0;
            if (sort) {
                LoggingEventWrapper lastEvent = null;
                for (Object aFilteredList : this.filteredList) {
                    LoggingEventWrapper e = (LoggingEventWrapper)aFilteredList;
                    e.setDisplayed(true);
                    this.updateEventMillisDelta(e, lastEvent);
                    lastEvent = e;
                }
                this.filteredList.sort(new ColumnComparator(this.getColumnName(this.currentSortColumn), this.currentSortColumn, this.currentSortAscending));
            }
        }
        if (sort) {
            SwingHelper.invokeOnEDT(() -> this.fireTableRowsUpdated(0, Math.max(filteredListSize - 1, 0)));
        }
    }

    @Override
    public boolean isSortEnabled() {
        return this.sortEnabled;
    }

    @Override
    public void sortColumn(int col, boolean ascending) {
        this.logger.debug((Object)("request to sort col=" + col));
        this.currentSortAscending = ascending;
        this.currentSortColumn = col;
        this.sortEnabled = true;
        this.sort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearModel() {
        this.reachedCapacity = false;
        Object object = this.mutex;
        synchronized (object) {
            this.unfilteredList.clear();
            this.filteredList.clear();
            this.uniqueRow = 0;
        }
        SwingHelper.invokeOnEDT(this::fireTableDataChanged);
        this.notifyCountListeners();
        this.loggerNameModelDelegate.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getAllEvents() {
        Object object = this.mutex;
        synchronized (object) {
            return new ArrayList(this.unfilteredList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getFilteredEvents() {
        Object object = this.mutex;
        synchronized (object) {
            return new ArrayList(this.filteredList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowIndex(LoggingEventWrapper loggingEventWrapper) {
        Object object = this.mutex;
        synchronized (object) {
            return this.filteredList.indexOf(loggingEventWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePropertyFromEvents(String propName) {
        ArrayList unfilteredListCopy;
        ArrayList filteredListCopy;
        Object object = this.mutex;
        synchronized (object) {
            filteredListCopy = new ArrayList(this.filteredList);
            unfilteredListCopy = new ArrayList(this.unfilteredList);
        }
        for (int i = 0; i < filteredListCopy.size(); ++i) {
            LoggingEventWrapper loggingEventWrapper = (LoggingEventWrapper)filteredListCopy.get(i);
            Object result = loggingEventWrapper.removeProperty(propName);
            if (result == null) continue;
            this.fireRowUpdated(i, false);
        }
        for (Object anUnfilteredListCopy : unfilteredListCopy) {
            LoggingEventWrapper loggingEventWrapper = (LoggingEventWrapper)anUnfilteredListCopy;
            loggingEventWrapper.removeProperty(propName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateEventsWithFindRule(Rule findRule) {
        ArrayList unfilteredListCopy;
        int count = 0;
        Iterator iterator = this.mutex;
        synchronized (iterator) {
            unfilteredListCopy = new ArrayList(this.unfilteredList);
        }
        for (Object anUnfilteredListCopy : unfilteredListCopy) {
            LoggingEventWrapper loggingEventWrapper = (LoggingEventWrapper)anUnfilteredListCopy;
            loggingEventWrapper.evaluateSearchRule(findRule);
            if (!loggingEventWrapper.isSearchMatch() || !loggingEventWrapper.isDisplayed()) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColoredRow(int startLocation, boolean searchForward) {
        ArrayList filteredListCopy;
        Object object = this.mutex;
        synchronized (object) {
            filteredListCopy = new ArrayList(this.filteredList);
        }
        if (searchForward) {
            LoggingEventWrapper event;
            int i;
            for (i = startLocation; i < filteredListCopy.size(); ++i) {
                event = (LoggingEventWrapper)filteredListCopy.get(i);
                if (event.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND) && event.getColorRuleForeground().equals(ChainsawConstants.COLOR_DEFAULT_FOREGROUND)) continue;
                return i;
            }
            for (i = 0; i < startLocation; ++i) {
                event = (LoggingEventWrapper)filteredListCopy.get(i);
                if (event.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND) && event.getColorRuleForeground().equals(ChainsawConstants.COLOR_DEFAULT_FOREGROUND)) continue;
                return i;
            }
        } else {
            LoggingEventWrapper event;
            int i;
            for (i = startLocation; i > -1; --i) {
                event = (LoggingEventWrapper)filteredListCopy.get(i);
                if (event.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND) && event.getColorRuleForeground().equals(ChainsawConstants.COLOR_DEFAULT_FOREGROUND)) continue;
                return i;
            }
            for (i = filteredListCopy.size() - 1; i > startLocation; --i) {
                event = (LoggingEventWrapper)filteredListCopy.get(i);
                if (event.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND) && event.getColorRuleForeground().equals(ChainsawConstants.COLOR_DEFAULT_FOREGROUND)) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSearchMatchCount() {
        int searchMatchCount = 0;
        Object object = this.mutex;
        synchronized (object) {
            for (Object aFilteredList : this.filteredList) {
                LoggingEventWrapper wrapper = (LoggingEventWrapper)aFilteredList;
                if (!wrapper.isSearchMatch() || !wrapper.isDisplayed()) continue;
                ++searchMatchCount;
            }
        }
        return searchMatchCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoggingEventWrapper getRow(int row) {
        Object object = this.mutex;
        synchronized (object) {
            if (row < this.filteredList.size() && row > -1) {
                return (LoggingEventWrapper)this.filteredList.get(row);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Object object = this.mutex;
        synchronized (object) {
            return this.filteredList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        LoggingEvent event = null;
        Object object = this.mutex;
        synchronized (object) {
            if (rowIndex < this.filteredList.size() && rowIndex > -1) {
                event = ((LoggingEventWrapper)this.filteredList.get(rowIndex)).getLoggingEvent();
            }
        }
        if (event == null) {
            return null;
        }
        LocationInfo info = null;
        if (event.locationInformationExists()) {
            info = event.getLocationInformation();
        }
        switch (columnIndex + 1) {
            case 14: {
                String id = event.getProperty("log4jid");
                if (id != null) {
                    return id;
                }
                return rowIndex;
            }
            case 4: {
                return event.getLevel();
            }
            case 2: {
                return event.getProperty("marker");
            }
            case 13: {
                return event.getProperty("millisdelta");
            }
            case 1: {
                return event.getLoggerName();
            }
            case 3: {
                return new Date(event.getTimeStamp());
            }
            case 6: {
                return event.getRenderedMessage();
            }
            case 7: {
                return event.getNDC();
            }
            case 5: {
                return event.getThreadName();
            }
            case 8: {
                return event.getThrowableStrRep();
            }
            case 9: {
                return info == null || "?".equals(info.getClassName()) ? "" : info.getClassName();
            }
            case 11: {
                return info == null || "?".equals(info.getFileName()) ? "" : info.getFileName();
            }
            case 12: {
                return info == null || "?".equals(info.getLineNumber()) ? "" : info.getLineNumber();
            }
            case 10: {
                return info == null || "?".equals(info.getMethodName()) ? "" : info.getMethodName();
            }
        }
        if (columnIndex < this.columnNames.size()) {
            String result = event.getProperty(this.columnNames.get(columnIndex).toString());
            if (result == null) {
                String lowerColName = this.columnNames.get(columnIndex).toString().toLowerCase(Locale.ENGLISH);
                Set entrySet = event.getProperties().entrySet();
                for (Map.Entry anEntrySet : entrySet) {
                    Map.Entry thisEntry = anEntrySet;
                    if (!thisEntry.getKey().toString().equalsIgnoreCase(lowerColName)) continue;
                    result = thisEntry.getValue().toString();
                }
            }
            if (result != null) {
                return result;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAddRow(LoggingEventWrapper loggingEventWrapper) {
        Object id = loggingEventWrapper.getLoggingEvent().getProperty("log4jid");
        if (id == null) {
            id = ++this.uniqueRow;
            loggingEventWrapper.setProperty("log4jid", id.toString());
        }
        loggingEventWrapper.updateColorRuleColors(this.colorizer.getBackgroundColor(loggingEventWrapper.getLoggingEvent()), this.colorizer.getForegroundColor(loggingEventWrapper.getLoggingEvent()));
        Rule findRule = this.colorizer.getFindRule();
        if (findRule != null) {
            loggingEventWrapper.evaluateSearchRule(this.colorizer.getFindRule());
        }
        boolean rowAdded = false;
        Object object = this.mutex;
        synchronized (object) {
            CyclicBufferList bufferList;
            if (this.cyclic && (bufferList = (CyclicBufferList)this.unfilteredList).size() == bufferList.getMaxSize()) {
                this.reachedCapacity = true;
            }
            int unfilteredSize = this.unfilteredList.size();
            LoggingEventWrapper lastLoggingEventWrapper = null;
            if (unfilteredSize > 0) {
                lastLoggingEventWrapper = (LoggingEventWrapper)this.unfilteredList.get(unfilteredSize - 1);
            }
            this.unfilteredList.add(loggingEventWrapper);
            if (this.ruleMediator == null || this.ruleMediator.evaluate(loggingEventWrapper.getLoggingEvent(), null)) {
                loggingEventWrapper.setDisplayed(true);
                this.updateEventMillisDelta(loggingEventWrapper, lastLoggingEventWrapper);
                this.filteredList.add(loggingEventWrapper);
                rowAdded = true;
            } else {
                loggingEventWrapper.setDisplayed(false);
            }
        }
        this.checkForNewColumn(loggingEventWrapper);
        return rowAdded;
    }

    private void updateEventMillisDelta(LoggingEventWrapper loggingEventWrapper, LoggingEventWrapper lastLoggingEventWrapper) {
        if (lastLoggingEventWrapper != null) {
            loggingEventWrapper.setPreviousDisplayedEventTimestamp(lastLoggingEventWrapper.getLoggingEvent().getTimeStamp());
        } else {
            loggingEventWrapper.setPreviousDisplayedEventTimestamp(loggingEventWrapper.getLoggingEvent().getTimeStamp());
        }
    }

    private void checkForNewColumn(LoggingEventWrapper loggingEventWrapper) {
        boolean newColumn = this.uniquePropertyKeys.addAll(loggingEventWrapper.getPropertyKeySet());
        if (newColumn) {
            for (Object o : loggingEventWrapper.getPropertyKeySet()) {
                String key = o.toString().toUpperCase();
                if (this.columnNames.contains(key) || "log4jid".equalsIgnoreCase(key)) continue;
                this.columnNames.add(key);
                this.logger.debug((Object)("Adding col '" + key + "', columnNames=" + this.columnNames));
                this.fireNewKeyColumnAdded(new NewKeyEvent(this, this.columnNames.indexOf(key), key, loggingEventWrapper.getLoggingEvent().getProperty(key)));
            }
        }
    }

    @Override
    public void fireTableEvent(int begin, int end, int count) {
        SwingHelper.invokeOnEDT(() -> {
            if (this.cyclic) {
                if (!this.reachedCapacity) {
                    if (begin + count < this.cyclicBufferSize) {
                        this.fireTableRowsInserted(begin, end);
                    } else {
                        this.fireTableRowsInserted(begin, this.cyclicBufferSize - 1);
                        this.fireTableRowsUpdated(0, this.cyclicBufferSize - 1);
                        this.reachedCapacity = true;
                    }
                } else {
                    this.fireTableRowsUpdated(0, this.cyclicBufferSize - 1);
                }
            } else {
                this.fireTableRowsInserted(begin, end);
            }
        });
    }

    @Override
    public void fireRowUpdated(int row, boolean checkForNewColumns) {
        LoggingEventWrapper loggingEventWrapper = this.getRow(row);
        if (loggingEventWrapper != null) {
            loggingEventWrapper.updateColorRuleColors(this.colorizer.getBackgroundColor(loggingEventWrapper.getLoggingEvent()), this.colorizer.getForegroundColor(loggingEventWrapper.getLoggingEvent()));
            Rule findRule = this.colorizer.getFindRule();
            if (findRule != null) {
                loggingEventWrapper.evaluateSearchRule(this.colorizer.getFindRule());
            }
            this.fireTableRowsUpdated(row, row);
            if (checkForNewColumns) {
                this.checkForNewColumn(loggingEventWrapper);
            }
        }
    }

    private void fireNewKeyColumnAdded(NewKeyEvent e) {
        NewKeyListener[] listeners;
        for (NewKeyListener listener : listeners = (NewKeyListener[])this.eventListenerList.getListeners(NewKeyListener.class)) {
            listener.newKeyAdded(e);
        }
    }

    @Override
    public int getMaxSize() {
        return this.cyclicBufferSize;
    }

    @Override
    public void addNewKeyListener(NewKeyListener l) {
        this.eventListenerList.add(NewKeyListener.class, l);
    }

    @Override
    public void removeNewKeyListener(NewKeyListener l) {
        this.eventListenerList.remove(NewKeyListener.class, l);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.getColumnName(columnIndex).equalsIgnoreCase("marker")) {
            return true;
        }
        return columnIndex < this.columnNames.size() && super.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void setCyclic(boolean cyclic) {
        if (this.cyclic == cyclic) {
            return;
        }
        boolean old = this.cyclic;
        this.cyclic = cyclic;
        this.propertySupport.firePropertyChange("cyclic", old, cyclic);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(propertyName, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.unfilteredList.size();
        }
    }

    private class ModelChanger
    implements PropertyChangeListener {
        private ModelChanger() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            Thread thread = new Thread(() -> {
                int index = 0;
                try (ProgressMonitor monitor = null;){
                    Object object = ChainsawCyclicBufferTableModel.this.mutex;
                    synchronized (object) {
                        AbstractList newFilteredList;
                        AbstractList newUnfilteredList;
                        monitor = new ProgressMonitor(null, "Switching models...", "Transferring between data structures, please wait...", 0, ChainsawCyclicBufferTableModel.this.unfilteredList.size() + 1);
                        monitor.setMillisToDecideToPopup(250);
                        monitor.setMillisToPopup(100);
                        ChainsawCyclicBufferTableModel.this.logger.debug((Object)("Changing Model, isCyclic is now " + ChainsawCyclicBufferTableModel.this.cyclic));
                        if (ChainsawCyclicBufferTableModel.this.cyclic) {
                            newUnfilteredList = new CyclicBufferList(ChainsawCyclicBufferTableModel.this.cyclicBufferSize);
                            newFilteredList = new CyclicBufferList(ChainsawCyclicBufferTableModel.this.cyclicBufferSize);
                        } else {
                            newUnfilteredList = new ArrayList(ChainsawCyclicBufferTableModel.this.cyclicBufferSize);
                            newFilteredList = new ArrayList(ChainsawCyclicBufferTableModel.this.cyclicBufferSize);
                        }
                        boolean increment = false;
                        for (Object anUnfilteredList : ChainsawCyclicBufferTableModel.this.unfilteredList) {
                            LoggingEventWrapper loggingEventWrapper = (LoggingEventWrapper)anUnfilteredList;
                            newUnfilteredList.add(loggingEventWrapper);
                            monitor.setProgress(index++);
                        }
                        ChainsawCyclicBufferTableModel.this.unfilteredList = newUnfilteredList;
                        ChainsawCyclicBufferTableModel.this.filteredList = newFilteredList;
                    }
                    monitor.setNote("Refiltering...");
                    ChainsawCyclicBufferTableModel.this.reFilter();
                    monitor.setProgress(index++);
                }
                ChainsawCyclicBufferTableModel.this.logger.debug((Object)"Model Change completed");
            });
            thread.setPriority(2);
            thread.start();
        }
    }
}

