/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import com.github.benmanes.caffeine.cache.Cache;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.server.core.api.interceptor.context.ModDnAva;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.MasterTable;
import org.apache.directory.server.xdbm.ParentIdAndRdn;

public interface Store {
    public static final String[] SYS_INDEX_OID_ARRAY = new String[]{"1.3.6.1.4.1.18060.0.4.1.2.3", "1.3.6.1.4.1.18060.0.4.1.2.50", "1.3.6.1.4.1.18060.0.4.1.2.7", "1.3.6.1.4.1.18060.0.4.1.2.5", "1.3.6.1.4.1.18060.0.4.1.2.6", "1.3.6.1.4.1.4203.666.1.7", "2.5.4.0", "2.5.18.5"};
    public static final Set<String> SYS_INDEX_OIDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SYS_INDEX_OID_ARRAY)));

    public void setPartitionPath(URI var1);

    public URI getPartitionPath();

    public void setSyncOnWrite(boolean var1);

    public boolean isSyncOnWrite();

    public void setCacheSize(int var1);

    public int getCacheSize();

    public void addIndex(Index<?, String> var1) throws Exception;

    public Index<String, String> getPresenceIndex();

    public Index<Dn, String> getAliasIndex();

    public Index<String, String> getOneAliasIndex();

    public Index<String, String> getSubAliasIndex();

    public String getSuffixId(PartitionTxn var1) throws LdapException;

    public Index<ParentIdAndRdn, String> getRdnIndex();

    public Index<String, String> getObjectClassIndex();

    public Index<String, String> getEntryCsnIndex();

    public Iterator<String> getUserIndices();

    public Iterator<String> getSystemIndices();

    public boolean hasIndexOn(AttributeType var1) throws LdapException;

    public boolean hasUserIndexOn(AttributeType var1) throws LdapException;

    public boolean hasSystemIndexOn(AttributeType var1) throws LdapException;

    public Index<?, String> getIndex(AttributeType var1) throws IndexNotFoundException;

    public Index<?, String> getUserIndex(AttributeType var1) throws IndexNotFoundException;

    public Index<?, String> getSystemIndex(AttributeType var1) throws IndexNotFoundException;

    public String getEntryId(PartitionTxn var1, Dn var2) throws LdapException;

    public Dn getEntryDn(PartitionTxn var1, String var2) throws LdapException;

    public String getParentId(PartitionTxn var1, String var2) throws LdapException;

    public long count(PartitionTxn var1) throws LdapException;

    public Entry delete(PartitionTxn var1, String var2) throws LdapException;

    public Entry fetch(PartitionTxn var1, String var2) throws LdapException;

    public Entry fetch(PartitionTxn var1, String var2, Dn var3) throws LdapException;

    public long getChildCount(PartitionTxn var1, String var2) throws LdapException;

    public Entry modify(PartitionTxn var1, Dn var2, Modification ... var3) throws LdapException;

    public void rename(PartitionTxn var1, Dn var2, Rdn var3, boolean var4, Entry var5) throws LdapException;

    public void moveAndRename(PartitionTxn var1, Dn var2, Dn var3, Rdn var4, Map<String, List<ModDnAva>> var5, Entry var6) throws LdapException;

    public void move(PartitionTxn var1, Dn var2, Dn var3, Dn var4, Entry var5) throws LdapException;

    public MasterTable getMasterTable();

    public ReadWriteLock getReadWriteLock();

    public Cache<String, Dn> getAliasCache();
}

