// ***************************************************************************************************************************
// * Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file *
// * distributed with this work for additional information regarding copyright ownership.  The ASF licenses this file        *
// * to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance            *
// * with the License.  You may obtain a copy of the License at                                                              *
// *                                                                                                                         *
// *  http://www.apache.org/licenses/LICENSE-2.0                                                                             *
// *                                                                                                                         *
// * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an  *
// * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the License for the        *
// * specific language governing permissions and limitations under the License.                                              *
// ***************************************************************************************************************************
package org.apache.juneau.httppart;

/**
 * Valid values for the <c>type</c> field.
 *
 * <ul class='seealso'>
 * 	<li class='link'>{@doc jm.HttpPartSerializersParsers}
 * 	<li class='extlink'>{@source}
 * </ul>
 */
public enum HttpPartDataType {

	/**
	 * String.
	 */
	STRING,

	/**
	 * Floating point number.
	 */
	NUMBER,

	/**
	 * Decimal number.
	 */
	INTEGER,

	/**
	 * Boolean.
	 */
	BOOLEAN,

	/**
	 * Array or collection.
	 */
	ARRAY,

	/**
	 * Map or bean.
	 */
	OBJECT,

	/**
	 * File.
	 */
	FILE,

	/**
	 * Not specified.
	 */
	NO_TYPE;

	/**
	 * Create from lowercase string.
	 *
	 * @param value The enum name.
	 * @return The enum.
	 */
	public static HttpPartDataType fromString(String value) {
		return valueOf(value.toUpperCase());
	}

	@Override /* Object */
	public String toString() {
		return name().toLowerCase();
	}
}