/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.StringRange;
import org.apache.juneau.StringRanges;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.BasicHeader;

public class BasicStringRangesHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final String stringValue;
    private final StringRanges value;
    private final Supplier<StringRanges> supplier;

    public static BasicStringRangesHeader of(String name, String value) {
        return value == null ? null : new BasicStringRangesHeader(name, value);
    }

    public static BasicStringRangesHeader of(String name, StringRanges value) {
        return value == null ? null : new BasicStringRangesHeader(name, value);
    }

    public static BasicStringRangesHeader of(String name, Supplier<StringRanges> value) {
        return value == null ? null : new BasicStringRangesHeader(name, value);
    }

    public BasicStringRangesHeader(String name, String value) {
        super(name, value);
        this.stringValue = value;
        this.value = StringRanges.of(value);
        this.supplier = null;
    }

    public BasicStringRangesHeader(String name, StringRanges value) {
        super(name, Utils.s(value));
        this.stringValue = null;
        this.value = value;
        this.supplier = null;
    }

    public BasicStringRangesHeader(String name, Supplier<StringRanges> value) {
        super(name, null);
        this.stringValue = null;
        this.value = null;
        this.supplier = value;
    }

    public Optional<StringRanges> asStringRanges() {
        return Utils.opt(this.value());
    }

    public StringRange getRange(int index) {
        StringRanges x = this.value();
        return x == null ? null : x.getRange(index);
    }

    @Override
    public String getValue() {
        return Utils.nn(this.stringValue) ? this.stringValue : Utils.s(this.value());
    }

    public int match(List<String> names) {
        StringRanges x = this.value();
        return x == null ? -1 : x.match(names);
    }

    public StringRanges orElse(StringRanges other) {
        StringRanges x = this.value();
        return Utils.nn(x) ? x : other;
    }

    public StringRanges toStringRanges() {
        return this.value();
    }

    private StringRanges value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

