/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;

public class AnnotationUtils {
    public static boolean equals(Annotation a1, Annotation a2) {
        Class<? extends Annotation> t2;
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        Class<? extends Annotation> t1 = a1.annotationType();
        if (!t1.equals(t2 = a2.annotationType())) {
            return false;
        }
        return !AnnotationUtils.getAnnotationMethods(t1).anyMatch(x -> !AnnotationUtils.memberEquals(x.getReturnType(), Utils.safeSupplier(() -> x.invoke((Object)a1, new Object[0])), Utils.safeSupplier(() -> x.invoke((Object)a2, new Object[0]))));
    }

    public static int hash(Annotation a) {
        return AnnotationUtils.getAnnotationMethods(a.annotationType()).mapToInt(x -> AnnotationUtils.hashMember(x.getName(), Utils.safeSupplier(() -> x.invoke((Object)a, new Object[0])))).sum();
    }

    public static Stream<Annotation> streamRepeated(Annotation a) {
        ClassInfoTyped<? extends Annotation> ci = ReflectionUtils.info(a.annotationType());
        MethodInfo mi = ci.getRepeatedAnnotationMethod();
        if (Utils.nn(mi)) {
            Annotation[] annotations = (Annotation[])mi.invoke(a, new Object[0]);
            return Arrays.stream(annotations);
        }
        return Stream.of(a);
    }

    private static boolean annotationArrayMemberEquals(Annotation[] a1, Annotation[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (!Utils.neq(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayMemberEquals(Class<?> componentType, Object o1, Object o2) {
        if (componentType.isAnnotation()) {
            return AnnotationUtils.annotationArrayMemberEquals((Annotation[])o1, (Annotation[])o2);
        }
        if (componentType.equals(Byte.TYPE)) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (componentType.equals(Short.TYPE)) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        if (componentType.equals(Integer.TYPE)) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (componentType.equals(Character.TYPE)) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (componentType.equals(Long.TYPE)) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (componentType.equals(Float.TYPE)) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (componentType.equals(Double.TYPE)) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (componentType.equals(Boolean.TYPE)) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        return Arrays.equals((Object[])o1, (Object[])o2);
    }

    private static int arrayMemberHash(Class<?> componentType, Object o) {
        if (componentType.equals(Byte.TYPE)) {
            return Arrays.hashCode((byte[])o);
        }
        if (componentType.equals(Short.TYPE)) {
            return Arrays.hashCode((short[])o);
        }
        if (componentType.equals(Integer.TYPE)) {
            return Arrays.hashCode((int[])o);
        }
        if (componentType.equals(Character.TYPE)) {
            return Arrays.hashCode((char[])o);
        }
        if (componentType.equals(Long.TYPE)) {
            return Arrays.hashCode((long[])o);
        }
        if (componentType.equals(Float.TYPE)) {
            return Arrays.hashCode((float[])o);
        }
        if (componentType.equals(Double.TYPE)) {
            return Arrays.hashCode((double[])o);
        }
        if (componentType.equals(Boolean.TYPE)) {
            return Arrays.hashCode((boolean[])o);
        }
        return Arrays.hashCode((Object[])o);
    }

    private static Stream<Method> getAnnotationMethods(Class<? extends Annotation> type) {
        return CollectionUtils.l(type.getDeclaredMethods()).stream();
    }

    private static int hashMember(String name, Object value) {
        int part1 = name.hashCode() * 127;
        if (value == null) {
            return part1;
        }
        if (Utils.isArray(value)) {
            return part1 ^ AnnotationUtils.arrayMemberHash(value.getClass().getComponentType(), value);
        }
        if (value instanceof Annotation) {
            Annotation value2 = (Annotation)value;
            return part1 ^ AnnotationUtils.hash(value2);
        }
        return part1 ^ value.hashCode();
    }

    private static boolean memberEquals(Class<?> type, Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (type.isArray()) {
            return AnnotationUtils.arrayMemberEquals(type.getComponentType(), o1, o2);
        }
        if (type.isAnnotation()) {
            return Utils.eq((Annotation)o1, (Annotation)o2);
        }
        return o1.equals(o2);
    }
}

